/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpretedFunction
extends NativeFunction
implements Script {
    private static final long serialVersionUID = 541475680333911468L;
    InterpreterData idata;
    SecurityController securityController;
    Object securityDomain;

    private InterpretedFunction(InterpreterData interpreterData, Object object) {
        Object object2;
        this.idata = interpreterData;
        Context context = Context.getContext();
        SecurityController securityController = context.getSecurityController();
        if (securityController != null) {
            object2 = securityController.getDynamicSecurityDomain(object);
        } else {
            if (object != null) {
                throw new IllegalArgumentException();
            }
            object2 = null;
        }
        this.securityController = securityController;
        this.securityDomain = object2;
    }

    private InterpretedFunction(InterpretedFunction interpretedFunction, int n) {
        this.idata = interpretedFunction.idata.itsNestedFunctions[n];
        this.securityController = interpretedFunction.securityController;
        this.securityDomain = interpretedFunction.securityDomain;
    }

    static InterpretedFunction createScript(InterpreterData interpreterData, Object object) {
        return new InterpretedFunction(interpreterData, object);
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, Object object) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData, object);
        interpretedFunction.initScriptFunction(context, scriptable, interpretedFunction.idata.isES6Generator);
        return interpretedFunction;
    }

    static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpretedFunction interpretedFunction, int n) {
        InterpretedFunction interpretedFunction2 = new InterpretedFunction(interpretedFunction, n);
        interpretedFunction2.initScriptFunction(context, scriptable, interpretedFunction2.idata.isES6Generator);
        return interpretedFunction2;
    }

    @Override
    public String getFunctionName() {
        return this.idata.itsName == null ? "" : this.idata.itsName;
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!ScriptRuntime.hasTopCall(context)) {
            return ScriptRuntime.doTopCall(this, context, scriptable, scriptable2, objectArray, this.idata.isStrict);
        }
        return Interpreter.interpret(this, context, scriptable, scriptable2, objectArray);
    }

    @Override
    public Object exec(Context context, Scriptable scriptable) {
        if (!this.isScript()) {
            throw new IllegalStateException();
        }
        Object object = !ScriptRuntime.hasTopCall(context) ? ScriptRuntime.doTopCall(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs, this.idata.isStrict) : Interpreter.interpret(this, context, scriptable, scriptable, ScriptRuntime.emptyArgs);
        context.processMicrotasks();
        return object;
    }

    public boolean isScript() {
        return this.idata.itsFunctionType == 0;
    }

    @Override
    public String getEncodedSource() {
        return Interpreter.getEncodedSource(this.idata);
    }

    @Override
    public DebuggableScript getDebuggableView() {
        return this.idata;
    }

    @Override
    public Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        return Interpreter.resumeGenerator(context, scriptable, n, object, object2);
    }

    @Override
    protected int getLanguageVersion() {
        return this.idata.languageVersion;
    }

    @Override
    protected int getParamCount() {
        if (this.idata.argsHasRest) {
            return this.idata.argCount - 1;
        }
        return this.idata.argCount;
    }

    @Override
    protected int getParamAndVarCount() {
        return this.idata.argNames.length;
    }

    @Override
    protected String getParamOrVarName(int n) {
        return this.idata.argNames[n];
    }

    @Override
    protected boolean getParamOrVarConst(int n) {
        return this.idata.argIsConst[n];
    }

    boolean hasFunctionNamed(String string) {
        for (int i = 0; i < this.idata.getFunctionCount(); ++i) {
            InterpreterData interpreterData = (InterpreterData)this.idata.getFunction(i);
            if (interpreterData.declaredAsFunctionExpression || !string.equals(interpreterData.getFunctionName())) continue;
            return false;
        }
        return true;
    }
}

