/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;

public class GdbMemoryMapping {
    private final BigInteger start;
    private final BigInteger end;
    private final BigInteger size;
    private final BigInteger offset;
    private final String flags;
    private final String objfile;

    public GdbMemoryMapping(BigInteger start, BigInteger end, BigInteger size, BigInteger offset, String flags, String objfile) {
        this.start = start;
        this.end = end;
        this.size = size;
        this.offset = offset;
        this.flags = flags;
        this.objfile = objfile;
        assert (Objects.equals(start.add(size), end));
    }

    public BigInteger getStart() {
        return this.start;
    }

    public BigInteger getEnd() {
        return this.end;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getObjfile() {
        return this.objfile;
    }

    static class Index {
        final NavigableMap<BigInteger, GdbMemoryMapping> mappings;
        final Map<String, BigInteger> bases;

        public Index(NavigableMap<BigInteger, GdbMemoryMapping> mappings) {
            this.mappings = mappings;
            this.bases = new HashMap<String, BigInteger>();
            for (GdbMemoryMapping mapping : mappings.values()) {
                if (mapping.objfile == null || mapping.objfile.isBlank() || this.bases.containsKey(mapping.objfile)) continue;
                this.bases.put(mapping.objfile, mapping.start);
            }
        }

        public BigInteger computeBase(BigInteger vma) {
            Map.Entry<BigInteger, GdbMemoryMapping> floor = this.mappings.floorEntry(vma);
            if (floor == null) {
                return vma;
            }
            GdbMemoryMapping mapping = floor.getValue();
            if (mapping.objfile.isBlank() || mapping.end.compareTo(vma) <= 0) {
                return vma;
            }
            return Objects.requireNonNull(this.bases.get(mapping.objfile));
        }

        public long computeBase(long vma) {
            return this.computeBase(BigInteger.valueOf(vma)).longValueExact();
        }
    }
}

