/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommandWithThreadId;
import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.parsing.GdbParsingUtils;
import generic.Span;
import generic.ULongSpan;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.nio.ByteBuffer;
import java.util.List;

public class GdbReadMemoryCommand
extends AbstractGdbCommandWithThreadId<ULongSpan.ULongSpanSet> {
    private final long addr;
    private final ByteBuffer buf;
    private final int len;

    public GdbReadMemoryCommand(GdbManagerImpl manager, Integer threadId, long addr, ByteBuffer buf, int len) {
        super(manager, threadId);
        this.addr = addr;
        this.buf = buf;
        this.len = len;
    }

    @Override
    protected String encode(String threadPart) {
        return "-data-read-memory-bytes" + threadPart + " 0x" + Long.toHexString(this.addr) + " " + this.len;
    }

    @Override
    public ULongSpan.ULongSpanSet complete(GdbPendingCommand<?> pending) {
        int pos;
        GdbCommandDoneEvent done = (GdbCommandDoneEvent)pending.checkCompletion(GdbCommandDoneEvent.class);
        List<GdbMiParser.GdbMiFieldList> rangeList = done.assumeMemoryContentsList();
        ULongSpan.DefaultULongSpanSet spanSet = new ULongSpan.DefaultULongSpanSet();
        int max = pos = this.buf.position();
        for (GdbMiParser.GdbMiFieldList r : rangeList) {
            byte[] contents;
            long start;
            long begin = GdbParsingUtils.parsePrefixedHex(r.getString("begin"));
            long offset = GdbParsingUtils.parsePrefixedHex(r.getString("offset"));
            long end = GdbParsingUtils.parsePrefixedHex(r.getString("end"));
            int length = (int)(end - (start = begin + offset));
            if (length != (contents = NumericUtilities.convertStringToBytes((String)r.getString("contents"))).length) {
                Msg.warn((Object)this, (Object)"Received fewer bytes than indicated by bounds");
            }
            int diff = (int)(start - this.addr);
            int newPos = pos + diff;
            max = Math.max(max, newPos + length);
            this.buf.position(newPos);
            this.buf.put(contents);
            spanSet.add((Span)ULongSpan.extent((long)start, (int)length));
        }
        this.buf.position(max);
        return spanSet;
    }
}

