/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadSelectedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;

public class GdbSetActiveThreadCommand
extends AbstractGdbCommand<Void> {
    private final int threadId;
    private final boolean internal;

    public GdbSetActiveThreadCommand(GdbManagerImpl manager, int threadId, boolean internal) {
        super(manager);
        this.threadId = threadId;
        this.internal = internal;
    }

    @Override
    public String encode() {
        return "-thread-select " + this.threadId;
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadSelectedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return this.internal;
    }
}

