/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.reason;

import agent.gdb.manager.parsing.GdbMiParser;
import agent.gdb.manager.reason.GdbBreakpointHitReason;
import agent.gdb.manager.reason.GdbEndSteppingRangeReason;
import agent.gdb.manager.reason.GdbExitNormallyReason;
import agent.gdb.manager.reason.GdbExitedReason;
import agent.gdb.manager.reason.GdbSignalReceivedReason;
import ghidra.util.Msg;
import java.util.Map;
import java.util.function.Function;

public interface GdbReason {
    public static final Map<String, Function<GdbMiParser.GdbMiFieldList, ? extends GdbReason>> TYPES = Map.ofEntries(Map.entry("signal-received", GdbSignalReceivedReason::new), Map.entry("breakpoint-hit", GdbBreakpointHitReason::new), Map.entry("end-stepping-range", GdbEndSteppingRangeReason::new), Map.entry("exited", GdbExitedReason::new), Map.entry("exited-normally", GdbExitNormallyReason::new));

    public static GdbReason getReason(GdbMiParser.GdbMiFieldList info) {
        String reasonStr = info.getString("reason");
        if (reasonStr == null) {
            return Reasons.NONE;
        }
        Function<GdbMiParser.GdbMiFieldList, ? extends GdbReason> cons = TYPES.get(reasonStr);
        if (cons == null) {
            Msg.warn(GdbReason.class, (Object)("Unknown stop reason: " + reasonStr));
            return Reasons.UNKNOWN;
        }
        return cons.apply(info);
    }

    public String desc();

    public static enum Reasons implements GdbReason
    {
        NONE("No reason"),
        UNKNOWN("Unknown");

        final String desc;

        private Reasons(String desc) {
            this.desc = desc;
        }

        @Override
        public String desc() {
            return this.desc;
        }
    }
}

