/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.PdbAnalyzerCommon;
import ghidra.app.plugin.core.analysis.PdbUniversalAnalyzer;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;

public class PdbAnalyzer
extends AbstractAnalyzer {
    static final String NAME = "PDB MSDIA";
    static final boolean DEFAULT_ENABLEMENT = false;
    private static final String DESCRIPTION = "PDB Analyzer.\nRequires MS DIA-SDK for raw PDB processing (Windows only).\nAlso supports pre-processed XML files.\nPDB Symbol Server searching is configured in Edit -> Symbol Server Config.\n";
    private static final String ERROR_TITLE = "Error in PDB Analyzer";
    private boolean searchRemoteLocations = false;
    private long lastTransactionId = -1L;

    public PdbAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(false);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        long txId = program.getCurrentTransactionInfo().getID();
        if (txId == this.lastTransactionId) {
            return false;
        }
        this.lastTransactionId = txId;
        if (!set.contains((AddressSetView)program.getMemory())) {
            return false;
        }
        if (PdbParser.isAlreadyLoaded(program)) {
            if (!PdbUniversalAnalyzer.isEnabled(program)) {
                Msg.info((Object)((Object)this), (Object)"Skipping PDB analysis since it has previously run.");
                Msg.info((Object)((Object)this), (Object)">> Clear 'PDB Loaded' program property or use Load PDB action if additional PDB processing required.");
            }
            return true;
        }
        if (PdbUniversalAnalyzer.isEnabled(program)) {
            log.appendMsg(this.getName(), "Stopped: Cannot run with PDB Universal Analyzer enabled");
            return false;
        }
        File pdbFile = PdbAnalyzerCommon.findPdb((Analyzer)this, program, this.searchRemoteLocations, monitor);
        if (pdbFile == null) {
            return false;
        }
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)program);
        return this.parsePdb(pdbFile, program, mgr, monitor, log);
    }

    boolean parsePdb(File pdb, Program program, AutoAnalysisManager mgr, TaskMonitor monitor, MessageLog log) {
        DataTypeManagerService dataTypeManagerService = mgr.getDataTypeManagerService();
        PdbParser parser = new PdbParser(pdb, program, dataTypeManagerService, true, false, monitor);
        try {
            parser.parse();
            parser.openDataTypeArchives();
            parser.applyTo(log);
            return true;
        }
        catch (PdbException e) {
            String message = e.getMessage();
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        catch (CancelledException e) {
            return false;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)((Object)this), null, (String)ERROR_TITLE, (Object)msg, (Throwable)e);
            return false;
        }
    }

    public boolean canAnalyze(Program program) {
        return PdbAnalyzerCommon.canAnalyzeProgram(program);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption("Search remote symbol servers", (Object)this.searchRemoteLocations, null, "If checked, allow searching remote symbol servers for PDB files.");
    }

    public void optionsChanged(Options options, Program program) {
        this.searchRemoteLocations = options.getBoolean("Search remote symbol servers", this.searchRemoteLocations);
    }

    public static void setPdbFileOption(Program program, File pdbFile) {
        PdbAnalyzerCommon.setPdbFileOption(NAME, program, pdbFile);
    }

    public static void setAllowRemoteOption(Program program, boolean allowRemote) {
        PdbAnalyzerCommon.setAllowRemoteOption(NAME, program, allowRemote);
    }
}

