/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13CoffSymbolRva;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeExports;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeImports;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FileChecksums;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FrameData;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13FuncMdTokenMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13IlLines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13InlineeLines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Lines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13MergedAssemblyInput;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13StringTable;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Symbols;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13TypeMdTokenMap;
import ghidra.app.util.bin.format.pdb2.pdbreader.UnknownC13Section;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

enum C13Type {
    UNKNOWN(Integer.MIN_VALUE, UnknownC13Section.class),
    ALL(0, C13Section.class),
    SYMBOLS(241, C13Symbols.class),
    LINES(242, C13Lines.class),
    STRING_TABLE(243, C13StringTable.class),
    FILE_CHECKSUMS(244, C13FileChecksums.class),
    FRAMEDATA(245, C13FrameData.class),
    INLINEE_LINES(246, C13InlineeLines.class),
    CROSS_SCOPE_IMPORTS(247, C13CrossScopeImports.class),
    CROSS_SCOPE_EXPORTS(248, C13CrossScopeExports.class),
    IL_LINES(249, C13IlLines.class),
    FUNC_MDTOKEN_MAP(250, C13FuncMdTokenMap.class),
    TYPE_MDTOKEN_MAP(251, C13TypeMdTokenMap.class),
    MERGED_ASSEMBLY_INPUT(252, C13MergedAssemblyInput.class),
    COFF_SYMBOL_RVA(253, C13CoffSymbolRva.class);

    private static final int IGNORE_BIT = Integer.MIN_VALUE;
    private static final int IGNORE_BIT_MASK = Integer.MAX_VALUE;
    private static final Map<Integer, C13Type> BY_VALUE;
    private static final Map<Class<? extends C13Section>, C13Type> BY_CLASS_VALUE;
    private final int value;
    private final Class<? extends C13Section> classValue;

    public static C13Type fromValue(int val) {
        C13Type t = BY_VALUE.getOrDefault(C13Type.maskIgnore(val), UNKNOWN);
        if (t == UNKNOWN) {
            Msg.debug(C13Type.class, (Object)String.format("C13Debug - Unknown section type %08x", val));
        }
        return t;
    }

    public static C13Type fromClassValue(Class<? extends C13Section> classVal) {
        C13Type t = BY_CLASS_VALUE.getOrDefault(classVal, UNKNOWN);
        if (t == UNKNOWN) {
            Msg.debug(C13Type.class, (Object)String.format("C13Debug - Unknown classValue %s", classVal.getSimpleName()));
        }
        return t;
    }

    public static boolean ignore(int val) {
        return (val & Integer.MIN_VALUE) != 0;
    }

    public static int maskIgnore(int val) {
        return val & Integer.MAX_VALUE;
    }

    private C13Type(int value, Class<? extends C13Section> classValue) {
        this.value = value;
        this.classValue = classValue;
    }

    public int getValue() {
        return this.value;
    }

    public Class<? extends C13Section> getSectionClass() {
        return this.classValue;
    }

    static {
        BY_VALUE = new HashMap<Integer, C13Type>();
        BY_CLASS_VALUE = new HashMap<Class<? extends C13Section>, C13Type>();
        for (C13Type val : C13Type.values()) {
            BY_VALUE.put(val.value, val);
            BY_CLASS_VALUE.put(val.classValue, val);
        }
    }
}

