/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeParser;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractNestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOneMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractOverloadedMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractStaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFieldListMsType
extends AbstractMsType {
    private List<MsTypeField> baseClassList = new ArrayList<MsTypeField>();
    private List<MsTypeField> memberList = new ArrayList<MsTypeField>();
    private List<MsTypeField> methodList = new ArrayList<MsTypeField>();
    private List<AbstractMemberMsType> nonstaticMemberList = new ArrayList<AbstractMemberMsType>();
    private List<AbstractStaticMemberMsType> staticMemberList = new ArrayList<AbstractStaticMemberMsType>();
    private List<AbstractVirtualFunctionTablePointerMsType> vftPtrList = new ArrayList<AbstractVirtualFunctionTablePointerMsType>();
    private List<AbstractNestedTypeMsType> nestedTypeList = new ArrayList<AbstractNestedTypeMsType>();
    private List<AbstractEnumerateMsType> enumerateList = new ArrayList<AbstractEnumerateMsType>();
    private List<AbstractIndexMsType> indexList = new ArrayList<AbstractIndexMsType>();

    public AbstractFieldListMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException, CancelledException {
        super(pdb, reader);
        while (reader.hasMore()) {
            MsTypeField type = TypeParser.parseField(pdb, reader);
            if (type instanceof AbstractBaseClassMsType || type instanceof AbstractVirtualBaseClassMsType || type instanceof AbstractIndirectVirtualBaseClassMsType) {
                this.baseClassList.add(type);
                continue;
            }
            if (type instanceof AbstractOverloadedMethodMsType || type instanceof AbstractOneMethodMsType) {
                this.methodList.add(type);
                continue;
            }
            if (type instanceof AbstractMemberMsType) {
                AbstractMemberMsType member = (AbstractMemberMsType)type;
                this.nonstaticMemberList.add(member);
                this.memberList.add(member);
                continue;
            }
            if (type instanceof AbstractStaticMemberMsType) {
                AbstractStaticMemberMsType member = (AbstractStaticMemberMsType)type;
                this.staticMemberList.add(member);
                this.memberList.add(member);
                continue;
            }
            if (type instanceof AbstractVirtualFunctionTablePointerMsType) {
                AbstractVirtualFunctionTablePointerMsType vftPtr = (AbstractVirtualFunctionTablePointerMsType)type;
                this.vftPtrList.add(vftPtr);
                this.memberList.add(vftPtr);
                continue;
            }
            if (type instanceof AbstractNestedTypeMsType) {
                AbstractNestedTypeMsType member = (AbstractNestedTypeMsType)type;
                this.nestedTypeList.add(member);
                this.memberList.add(member);
                continue;
            }
            if (type instanceof AbstractEnumerateMsType) {
                AbstractEnumerateMsType enumerate = (AbstractEnumerateMsType)type;
                this.enumerateList.add(enumerate);
                this.memberList.add(enumerate);
                continue;
            }
            if (type instanceof AbstractIndexMsType) {
                this.indexList.add((AbstractIndexMsType)type);
                continue;
            }
            PdbLog.message("Unexpected type in Field List" + type.getClass().getSimpleName());
        }
    }

    public List<MsTypeField> getBaseClassList() {
        return this.baseClassList;
    }

    public List<MsTypeField> getMemberList() {
        return this.memberList;
    }

    public List<MsTypeField> getMethodList() {
        return this.methodList;
    }

    public List<AbstractMemberMsType> getNonStaticMembers() {
        return this.nonstaticMemberList;
    }

    public List<AbstractVirtualFunctionTablePointerMsType> getVftPointers() {
        return this.vftPtrList;
    }

    public List<AbstractNestedTypeMsType> getNestedTypes() {
        return this.nestedTypeList;
    }

    public List<AbstractEnumerateMsType> getEnumerates() {
        return this.enumerateList;
    }

    public List<AbstractIndexMsType> getIndexList() {
        return this.indexList;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder classBuilder = new StringBuilder();
        DelimiterState dsBases = new DelimiterState(" : ", ", ");
        for (MsTypeField type : this.baseClassList) {
            classBuilder.append(dsBases.out(true, type.toString()));
        }
        StringBuilder memberBuilder = new StringBuilder();
        memberBuilder.append(" {");
        DelimiterState dsMembers = new DelimiterState("", ",");
        for (MsTypeField type : this.memberList) {
            memberBuilder.append(dsMembers.out(true, type.toString()));
        }
        memberBuilder.append("}");
        StringBuilder otherBuilder = new StringBuilder();
        if (this.methodList.size() != 0) {
            otherBuilder.append("...");
        }
        builder.append((CharSequence)classBuilder);
        builder.append((CharSequence)memberBuilder);
        builder.append((CharSequence)otherBuilder);
    }
}

