/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.math.BigInteger;

public class PrimitiveMsType
extends AbstractMsType {
    protected int recNum;
    protected String typeString;
    protected int typeSize;

    public PrimitiveMsType(AbstractPdb pdb, int recNum) {
        super(pdb, null);
        this.recNum = recNum;
        this.processType();
    }

    @Override
    public int getPdbId() {
        return -1;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        if (builder.length() != 0) {
            builder.insert(0, " ");
        }
        builder.insert(0, this.typeString);
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.getTypeSize());
    }

    @Override
    public String getName() {
        return this.typeString;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public int getNumber() {
        return this.recNum;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public boolean isNoType() {
        return this.recNum == 0;
    }

    private void processType() {
        switch (this.recNum) {
            case 0: {
                this.typeString = "T_NOTYPE";
                this.typeSize = 0;
                break;
            }
            case 1: {
                this.typeString = "T_ABS";
                this.typeSize = 0;
                break;
            }
            case 2: {
                this.typeString = "T_SEGMENT";
                this.typeSize = 0;
                break;
            }
            case 3: {
                this.typeString = "void";
                this.typeSize = 0;
                break;
            }
            case 259: {
                this.typeString = "void near*";
                this.typeSize = 2;
                break;
            }
            case 515: {
                this.typeString = "void far*";
                this.typeSize = 4;
                break;
            }
            case 771: {
                this.typeString = "void huge*";
                this.typeSize = 4;
                break;
            }
            case 1027: {
                this.typeString = "void *";
                this.typeSize = 4;
                break;
            }
            case 1283: {
                this.typeString = "T_32PFVOID";
                this.typeSize = 4;
                break;
            }
            case 1539: {
                this.typeString = "T_64PFVOID";
                this.typeSize = 8;
                break;
            }
            case 1795: {
                this.typeString = "T_128PFVOID";
                this.typeSize = 16;
                break;
            }
            case 4: {
                this.typeString = "T_CURRENCY";
                this.typeSize = 8;
                break;
            }
            case 5: {
                this.typeString = "T_NBASICSTR";
                this.typeSize = 0;
                break;
            }
            case 6: {
                this.typeString = "T_FBASICSTR";
                this.typeSize = 0;
                break;
            }
            case 7: {
                this.typeString = "T_NOTTRANS";
                this.typeSize = 0;
                break;
            }
            case 8: {
                this.typeString = "T_HRESULT";
                this.typeSize = 4;
                break;
            }
            case 1032: {
                this.typeString = "T_32PHRESULT";
                this.typeSize = 4;
                break;
            }
            case 1544: {
                this.typeString = "T_64PHRESULT";
                this.typeSize = 8;
                break;
            }
            case 1800: {
                this.typeString = "T_128PHRESULT";
                this.typeSize = 16;
                break;
            }
            case 96: {
                this.typeString = "T_BIT";
                this.typeSize = 0;
                break;
            }
            case 97: {
                this.typeString = "T_PASCHAR";
                this.typeSize = 0;
                break;
            }
            case 98: {
                this.typeString = "T_BOOL32FF";
                this.typeSize = 0;
                break;
            }
            case 16: {
                this.typeString = "signed char";
                this.typeSize = 1;
                break;
            }
            case 272: {
                this.typeString = "signed char near*";
                this.typeSize = 2;
                break;
            }
            case 528: {
                this.typeString = "char far*";
                this.typeSize = 4;
                break;
            }
            case 784: {
                this.typeString = "char huge*";
                this.typeSize = 4;
                break;
            }
            case 1040: {
                this.typeString = "char *";
                this.typeSize = 4;
                break;
            }
            case 1296: {
                this.typeString = "T_32PFCHAR";
                this.typeSize = 6;
                break;
            }
            case 1552: {
                this.typeString = "T_64PCHAR";
                this.typeSize = 8;
                break;
            }
            case 1808: {
                this.typeString = "T_128PCHAR";
                this.typeSize = 16;
                break;
            }
            case 32: {
                this.typeString = "unsigned char";
                this.typeSize = 1;
                break;
            }
            case 288: {
                this.typeString = "unsigned char near*";
                this.typeSize = 2;
                break;
            }
            case 544: {
                this.typeString = "unsigned char far*";
                this.typeSize = 4;
                break;
            }
            case 800: {
                this.typeString = "unsigned char huge*";
                this.typeSize = 4;
                break;
            }
            case 1056: {
                this.typeString = "unsigned char *";
                this.typeSize = 4;
                break;
            }
            case 1312: {
                this.typeString = "T_32PFUCHAR";
                this.typeSize = 6;
                break;
            }
            case 1568: {
                this.typeString = "T_64PUCHAR";
                this.typeSize = 8;
                break;
            }
            case 1824: {
                this.typeString = "T_128PUCHAR";
                this.typeSize = 16;
                break;
            }
            case 112: {
                this.typeString = "char";
                this.typeSize = 1;
                break;
            }
            case 368: {
                this.typeString = "char near*";
                this.typeSize = 2;
                break;
            }
            case 624: {
                this.typeString = "char far*";
                this.typeSize = 4;
                break;
            }
            case 880: {
                this.typeString = "char huge*";
                this.typeSize = 4;
                break;
            }
            case 1136: {
                this.typeString = "char *";
                this.typeSize = 4;
                break;
            }
            case 1392: {
                this.typeString = "T_32PFRCHAR";
                this.typeSize = 6;
                break;
            }
            case 1648: {
                this.typeString = "T_64PRCHAR";
                this.typeSize = 8;
                break;
            }
            case 1904: {
                this.typeString = "T_128PRCHAR";
                this.typeSize = 16;
                break;
            }
            case 113: {
                this.typeString = "wchar_t";
                this.typeSize = 2;
                break;
            }
            case 369: {
                this.typeString = "wchar_t near*";
                this.typeSize = 2;
                break;
            }
            case 625: {
                this.typeString = "wchar_t far*";
                this.typeSize = 4;
                break;
            }
            case 881: {
                this.typeString = "wchar_t huge*";
                this.typeSize = 4;
                break;
            }
            case 1137: {
                this.typeString = "wchar_t *";
                this.typeSize = 4;
                break;
            }
            case 1393: {
                this.typeString = "T_32PFWCHAR";
                this.typeSize = 6;
                break;
            }
            case 1649: {
                this.typeString = "T_64PWCHAR";
                this.typeSize = 8;
                break;
            }
            case 1905: {
                this.typeString = "T_128PWCHAR";
                this.typeSize = 16;
                break;
            }
            case 122: {
                this.typeString = "T_CHAR16";
                this.typeSize = 2;
                break;
            }
            case 378: {
                this.typeString = "T_PCHAR16";
                this.typeSize = 2;
                break;
            }
            case 634: {
                this.typeString = "T_PFCHAR16";
                this.typeSize = 4;
                break;
            }
            case 890: {
                this.typeString = "T_PHCHAR16";
                this.typeSize = 4;
                break;
            }
            case 1146: {
                this.typeString = "T_32PCHAR16";
                this.typeSize = 4;
                break;
            }
            case 1402: {
                this.typeString = "T_32PFCHAR16";
                this.typeSize = 6;
                break;
            }
            case 1658: {
                this.typeString = "T_64PCHAR16";
                this.typeSize = 8;
                break;
            }
            case 1914: {
                this.typeString = "T_128PCHAR16";
                this.typeSize = 16;
                break;
            }
            case 123: {
                this.typeString = "T_CHAR32";
                this.typeSize = 4;
                break;
            }
            case 379: {
                this.typeString = "T_PCHAR32";
                this.typeSize = 2;
                break;
            }
            case 635: {
                this.typeString = "T_PFCHAR32";
                this.typeSize = 4;
                break;
            }
            case 891: {
                this.typeString = "T_PHCHAR32";
                this.typeSize = 4;
                break;
            }
            case 1147: {
                this.typeString = "T_32PCHAR32";
                this.typeSize = 4;
                break;
            }
            case 1403: {
                this.typeString = "T_32PFCHAR32";
                this.typeSize = 6;
                break;
            }
            case 1659: {
                this.typeString = "T_64PCHAR32";
                this.typeSize = 8;
                break;
            }
            case 1915: {
                this.typeString = "T_128PCHAR32";
                this.typeSize = 16;
                break;
            }
            case 104: {
                this.typeString = "T_INT1";
                this.typeSize = 1;
                break;
            }
            case 360: {
                this.typeString = "T_PINT1";
                this.typeSize = 2;
                break;
            }
            case 616: {
                this.typeString = "T_PFINT1";
                this.typeSize = 4;
                break;
            }
            case 872: {
                this.typeString = "T_PHINT1";
                this.typeSize = 4;
                break;
            }
            case 1128: {
                this.typeString = "T_32PINT1";
                this.typeSize = 4;
                break;
            }
            case 1384: {
                this.typeString = "T_32PFINT1";
                this.typeSize = 6;
                break;
            }
            case 1640: {
                this.typeString = "T_64PINT1";
                this.typeSize = 8;
                break;
            }
            case 1896: {
                this.typeString = "T_128PINT1";
                this.typeSize = 16;
                break;
            }
            case 105: {
                this.typeString = "T_UINT1";
                this.typeSize = 1;
                break;
            }
            case 361: {
                this.typeString = "T_PUINT1";
                this.typeSize = 2;
                break;
            }
            case 617: {
                this.typeString = "T_PFUINT1";
                this.typeSize = 4;
                break;
            }
            case 873: {
                this.typeString = "T_PHUINT1";
                this.typeSize = 4;
                break;
            }
            case 1129: {
                this.typeString = "T_32PUINT1";
                this.typeSize = 4;
                break;
            }
            case 1385: {
                this.typeString = "T_32PFUINT1";
                this.typeSize = 6;
                break;
            }
            case 1641: {
                this.typeString = "T_64PUINT1";
                this.typeSize = 8;
                break;
            }
            case 1897: {
                this.typeString = "T_128PUINT1";
                this.typeSize = 16;
                break;
            }
            case 17: {
                this.typeString = "short";
                this.typeSize = 2;
                break;
            }
            case 273: {
                this.typeString = "short near*";
                this.typeSize = 2;
                break;
            }
            case 529: {
                this.typeString = "short far*";
                this.typeSize = 4;
                break;
            }
            case 785: {
                this.typeString = "short huge*";
                this.typeSize = 4;
                break;
            }
            case 1041: {
                this.typeString = "T_32PSHORT";
                this.typeSize = 4;
                break;
            }
            case 1297: {
                this.typeString = "T_32PFSHORT";
                this.typeSize = 6;
                break;
            }
            case 1553: {
                this.typeString = "T_64PSHORT";
                this.typeSize = 8;
                break;
            }
            case 1809: {
                this.typeString = "T_128PSHORT";
                this.typeSize = 16;
                break;
            }
            case 33: {
                this.typeString = "unsigned short";
                this.typeSize = 2;
                break;
            }
            case 289: {
                this.typeString = "unsigned short near*";
                this.typeSize = 2;
                break;
            }
            case 545: {
                this.typeString = "unsigned short far*";
                this.typeSize = 4;
                break;
            }
            case 801: {
                this.typeString = "unsigned short huge*";
                this.typeSize = 4;
                break;
            }
            case 1057: {
                this.typeString = "T_32PUSHORT";
                this.typeSize = 4;
                break;
            }
            case 1313: {
                this.typeString = "T_32PFUSHORT";
                this.typeSize = 6;
                break;
            }
            case 1569: {
                this.typeString = "T_64PUSHORT";
                this.typeSize = 8;
                break;
            }
            case 1825: {
                this.typeString = "T_128PUSHORT";
                this.typeSize = 16;
                break;
            }
            case 114: {
                this.typeString = "int16";
                this.typeSize = 2;
                break;
            }
            case 370: {
                this.typeString = "int16 near*";
                this.typeSize = 2;
                break;
            }
            case 626: {
                this.typeString = "int16 far*";
                this.typeSize = 4;
                break;
            }
            case 882: {
                this.typeString = "int16 huge*";
                this.typeSize = 4;
                break;
            }
            case 1138: {
                this.typeString = "T_32PINT2";
                this.typeSize = 4;
                break;
            }
            case 1394: {
                this.typeString = "T_32PFINT2";
                this.typeSize = 6;
                break;
            }
            case 1650: {
                this.typeString = "T_64PINT2";
                this.typeSize = 8;
                break;
            }
            case 1906: {
                this.typeString = "T_128PINT2";
                this.typeSize = 16;
                break;
            }
            case 115: {
                this.typeString = "unsigned int16";
                this.typeSize = 2;
                break;
            }
            case 371: {
                this.typeString = "unsigned int16 near*";
                this.typeSize = 2;
                break;
            }
            case 627: {
                this.typeString = "unsigned int16 far*";
                this.typeSize = 4;
                break;
            }
            case 883: {
                this.typeString = "unsigned int16 huge*";
                this.typeSize = 4;
                break;
            }
            case 1139: {
                this.typeString = "T_32PUINT2";
                this.typeSize = 4;
                break;
            }
            case 1395: {
                this.typeString = "T_32PFUINT2";
                this.typeSize = 6;
                break;
            }
            case 1651: {
                this.typeString = "T_64PUINT2";
                this.typeSize = 8;
                break;
            }
            case 1907: {
                this.typeString = "T_128PUINT2";
                this.typeSize = 16;
                break;
            }
            case 18: {
                this.typeString = "long";
                this.typeSize = 4;
                break;
            }
            case 274: {
                this.typeString = "long near*";
                this.typeSize = 2;
                break;
            }
            case 530: {
                this.typeString = "long far*";
                this.typeSize = 4;
                break;
            }
            case 786: {
                this.typeString = "long huge*";
                this.typeSize = 4;
                break;
            }
            case 1042: {
                this.typeString = "T_32PLONG";
                this.typeSize = 4;
                break;
            }
            case 1298: {
                this.typeString = "T_32PFLONG";
                this.typeSize = 6;
                break;
            }
            case 1554: {
                this.typeString = "T_64PLONG";
                this.typeSize = 8;
                break;
            }
            case 1810: {
                this.typeString = "T_128PLONG";
                this.typeSize = 16;
                break;
            }
            case 34: {
                this.typeString = "unsigned long";
                this.typeSize = 4;
                break;
            }
            case 290: {
                this.typeString = "unsigned long near*";
                this.typeSize = 2;
                break;
            }
            case 546: {
                this.typeString = "unsigned long far*";
                this.typeSize = 4;
                break;
            }
            case 802: {
                this.typeString = "unsigned long huge*";
                this.typeSize = 4;
                break;
            }
            case 1058: {
                this.typeString = "T_32PULONG";
                this.typeSize = 4;
                break;
            }
            case 1314: {
                this.typeString = "T_32PFULONG";
                this.typeSize = 6;
                break;
            }
            case 1570: {
                this.typeString = "T_64PULONG";
                this.typeSize = 8;
                break;
            }
            case 1826: {
                this.typeString = "T_128PULONG";
                this.typeSize = 16;
                break;
            }
            case 116: {
                this.typeString = "int";
                this.typeSize = 4;
                break;
            }
            case 372: {
                this.typeString = "PINT4";
                this.typeSize = 2;
                break;
            }
            case 628: {
                this.typeString = "PFINT4";
                this.typeSize = 4;
                break;
            }
            case 884: {
                this.typeString = "PHINT4";
                this.typeSize = 4;
                break;
            }
            case 1140: {
                this.typeString = "T_32PINT4";
                this.typeSize = 4;
                break;
            }
            case 1396: {
                this.typeString = "T_32PFINT4";
                this.typeSize = 6;
                break;
            }
            case 1652: {
                this.typeString = "T_64PINT4";
                this.typeSize = 8;
                break;
            }
            case 1908: {
                this.typeString = "T_128PINT4";
                this.typeSize = 16;
                break;
            }
            case 117: {
                this.typeString = "unsigned";
                this.typeSize = 4;
                break;
            }
            case 373: {
                this.typeString = "PUINT4";
                this.typeSize = 2;
                break;
            }
            case 629: {
                this.typeString = "PFUINT4";
                this.typeSize = 4;
                break;
            }
            case 885: {
                this.typeString = "PHUINT4";
                this.typeSize = 4;
                break;
            }
            case 1141: {
                this.typeString = "T_32PUINT4";
                this.typeSize = 4;
                break;
            }
            case 1397: {
                this.typeString = "T_32PFUINT4";
                this.typeSize = 6;
                break;
            }
            case 1653: {
                this.typeString = "T_64PUINT4";
                this.typeSize = 8;
                break;
            }
            case 1909: {
                this.typeString = "T_128PUINT4";
                this.typeSize = 16;
                break;
            }
            case 19: {
                this.typeString = "T_QUAD";
                this.typeSize = 8;
                break;
            }
            case 275: {
                this.typeString = "T_PQUAD";
                this.typeSize = 2;
                break;
            }
            case 531: {
                this.typeString = "T_PFQUAD";
                this.typeSize = 4;
                break;
            }
            case 787: {
                this.typeString = "T_PHQUAD";
                this.typeSize = 4;
                break;
            }
            case 1043: {
                this.typeString = "T_32PQUAD";
                this.typeSize = 4;
                break;
            }
            case 1299: {
                this.typeString = "T_32PFQUAD";
                this.typeSize = 6;
                break;
            }
            case 1555: {
                this.typeString = "T_64PQUAD";
                this.typeSize = 8;
                break;
            }
            case 1811: {
                this.typeString = "T_128PQUAD";
                this.typeSize = 16;
                break;
            }
            case 35: {
                this.typeString = "T_UQUAD";
                this.typeSize = 8;
                break;
            }
            case 291: {
                this.typeString = "T_PUQUAD";
                this.typeSize = 2;
                break;
            }
            case 547: {
                this.typeString = "T_PFUQUAD";
                this.typeSize = 4;
                break;
            }
            case 803: {
                this.typeString = "T_PHUQUAD";
                this.typeSize = 4;
                break;
            }
            case 1059: {
                this.typeString = "T_32PUQUAD";
                this.typeSize = 4;
                break;
            }
            case 1315: {
                this.typeString = "T_32PFUQUAD";
                this.typeSize = 6;
                break;
            }
            case 1571: {
                this.typeString = "T_64PUQUAD";
                this.typeSize = 8;
                break;
            }
            case 1827: {
                this.typeString = "T_128PUQUAD";
                this.typeSize = 16;
                break;
            }
            case 118: {
                this.typeString = "T_INT8";
                this.typeSize = 8;
                break;
            }
            case 374: {
                this.typeString = "T_PINT8";
                this.typeSize = 2;
                break;
            }
            case 630: {
                this.typeString = "T_PFINT8";
                this.typeSize = 4;
                break;
            }
            case 886: {
                this.typeString = "T_PHINT8";
                this.typeSize = 4;
                break;
            }
            case 1142: {
                this.typeString = "T_32PINT8";
                this.typeSize = 4;
                break;
            }
            case 1398: {
                this.typeString = "T_32PFINT8";
                this.typeSize = 6;
                break;
            }
            case 1654: {
                this.typeString = "T_64PINT8";
                this.typeSize = 8;
                break;
            }
            case 1910: {
                this.typeString = "T_128PINT8";
                this.typeSize = 16;
                break;
            }
            case 119: {
                this.typeString = "T_UINT8";
                this.typeSize = 8;
                break;
            }
            case 375: {
                this.typeString = "T_PUINT8";
                this.typeSize = 2;
                break;
            }
            case 631: {
                this.typeString = "T_PFUINT8";
                this.typeSize = 4;
                break;
            }
            case 887: {
                this.typeString = "T_PHUINT8";
                this.typeSize = 4;
                break;
            }
            case 1143: {
                this.typeString = "T_32PUINT8";
                this.typeSize = 4;
                break;
            }
            case 1399: {
                this.typeString = "T_32PFUINT8";
                this.typeSize = 6;
                break;
            }
            case 1655: {
                this.typeString = "T_64PUINT8";
                this.typeSize = 8;
                break;
            }
            case 1911: {
                this.typeString = "T_128PUINT8";
                this.typeSize = 16;
                break;
            }
            case 20: {
                this.typeString = "T_OCT";
                this.typeSize = 16;
                break;
            }
            case 276: {
                this.typeString = "T_POCT";
                this.typeSize = 2;
                break;
            }
            case 532: {
                this.typeString = "T_PFOCT";
                this.typeSize = 4;
                break;
            }
            case 788: {
                this.typeString = "T_PHOCT";
                this.typeSize = 4;
                break;
            }
            case 1044: {
                this.typeString = "T_32POCT";
                this.typeSize = 4;
                break;
            }
            case 1300: {
                this.typeString = "T_32PFOCT";
                this.typeSize = 6;
                break;
            }
            case 1556: {
                this.typeString = "T_64POCT";
                this.typeSize = 8;
                break;
            }
            case 1812: {
                this.typeString = "T_128POCT";
                this.typeSize = 16;
                break;
            }
            case 36: {
                this.typeString = "T_UOCT";
                this.typeSize = 16;
                break;
            }
            case 292: {
                this.typeString = "T_PUOCT";
                this.typeSize = 2;
                break;
            }
            case 548: {
                this.typeString = "T_PFUOCT";
                this.typeSize = 4;
                break;
            }
            case 804: {
                this.typeString = "T_PHUOCT";
                this.typeSize = 4;
                break;
            }
            case 1060: {
                this.typeString = "T_32PUOCT";
                this.typeSize = 4;
                break;
            }
            case 1316: {
                this.typeString = "T_32PFUOCT";
                this.typeSize = 6;
                break;
            }
            case 1572: {
                this.typeString = "T_64PUOCT";
                this.typeSize = 8;
                break;
            }
            case 1828: {
                this.typeString = "T_128PUOCT";
                this.typeSize = 16;
                break;
            }
            case 120: {
                this.typeString = "T_INT16";
                this.typeSize = 16;
                break;
            }
            case 376: {
                this.typeString = "T_PINT16";
                this.typeSize = 2;
                break;
            }
            case 632: {
                this.typeString = "T_PFINT16";
                this.typeSize = 4;
                break;
            }
            case 888: {
                this.typeString = "T_PHINT16";
                this.typeSize = 4;
                break;
            }
            case 1144: {
                this.typeString = "T_32PINT16";
                this.typeSize = 4;
                break;
            }
            case 1400: {
                this.typeString = "T_32PFINT16";
                this.typeSize = 6;
                break;
            }
            case 1656: {
                this.typeString = "T_64PINT16";
                this.typeSize = 8;
                break;
            }
            case 1912: {
                this.typeString = "T_128PINT16";
                this.typeSize = 16;
                break;
            }
            case 121: {
                this.typeString = "T_UINT16";
                this.typeSize = 16;
                break;
            }
            case 377: {
                this.typeString = "T_PUINT16";
                this.typeSize = 2;
                break;
            }
            case 633: {
                this.typeString = "T_PFUINT16";
                this.typeSize = 4;
                break;
            }
            case 889: {
                this.typeString = "T_PHUINT16";
                this.typeSize = 4;
                break;
            }
            case 1145: {
                this.typeString = "T_32PUINT16";
                this.typeSize = 4;
                break;
            }
            case 1401: {
                this.typeString = "T_32PFUINT16";
                this.typeSize = 6;
                break;
            }
            case 1657: {
                this.typeString = "T_64PUINT16";
                this.typeSize = 8;
                break;
            }
            case 1913: {
                this.typeString = "T_128PUINT16";
                this.typeSize = 16;
                break;
            }
            case 70: {
                this.typeString = "T_REAL16";
                this.typeSize = 2;
                break;
            }
            case 326: {
                this.typeString = "T_PREAL16";
                this.typeSize = 2;
                break;
            }
            case 582: {
                this.typeString = "T_PFREAL16";
                this.typeSize = 4;
                break;
            }
            case 838: {
                this.typeString = "T_PHREAL16";
                this.typeSize = 4;
                break;
            }
            case 1094: {
                this.typeString = "T_32PREAL16";
                this.typeSize = 4;
                break;
            }
            case 1350: {
                this.typeString = "T_32PFREAL16";
                this.typeSize = 6;
                break;
            }
            case 1606: {
                this.typeString = "T_64PREAL16";
                this.typeSize = 8;
                break;
            }
            case 1862: {
                this.typeString = "T_128PREAL16";
                this.typeSize = 16;
                break;
            }
            case 64: {
                this.typeString = "T_REAL32";
                this.typeSize = 4;
                break;
            }
            case 320: {
                this.typeString = "T_PREAL32";
                this.typeSize = 2;
                break;
            }
            case 576: {
                this.typeString = "T_PFREAL32";
                this.typeSize = 4;
                break;
            }
            case 832: {
                this.typeString = "T_PHREAL32";
                this.typeSize = 4;
                break;
            }
            case 1088: {
                this.typeString = "T_32PREAL32";
                this.typeSize = 4;
                break;
            }
            case 1344: {
                this.typeString = "T_32PFREAL32";
                this.typeSize = 6;
                break;
            }
            case 1600: {
                this.typeString = "T_64PREAL32";
                this.typeSize = 8;
                break;
            }
            case 1856: {
                this.typeString = "T_128PREAL32";
                this.typeSize = 16;
                break;
            }
            case 69: {
                this.typeString = "T_REAL32PP";
                this.typeSize = 4;
                break;
            }
            case 325: {
                this.typeString = "T_PREAL32PP";
                this.typeSize = 2;
                break;
            }
            case 581: {
                this.typeString = "T_PFREAL32PP";
                this.typeSize = 4;
                break;
            }
            case 837: {
                this.typeString = "T_PHREAL32PP";
                this.typeSize = 4;
                break;
            }
            case 1093: {
                this.typeString = "T_32PREAL32PP";
                this.typeSize = 4;
                break;
            }
            case 1349: {
                this.typeString = "T_32PFREAL32PP";
                this.typeSize = 6;
                break;
            }
            case 1605: {
                this.typeString = "T_64PREAL32PP";
                this.typeSize = 8;
                break;
            }
            case 1861: {
                this.typeString = "T_128PREAL32PP";
                this.typeSize = 16;
                break;
            }
            case 68: {
                this.typeString = "T_REAL48";
                this.typeSize = 6;
                break;
            }
            case 324: {
                this.typeString = "T_PREAL48";
                this.typeSize = 2;
                break;
            }
            case 580: {
                this.typeString = "T_PFREAL48";
                this.typeSize = 4;
                break;
            }
            case 836: {
                this.typeString = "T_PHREAL48";
                this.typeSize = 4;
                break;
            }
            case 1092: {
                this.typeString = "T_32PREAL48";
                this.typeSize = 4;
                break;
            }
            case 1348: {
                this.typeString = "T_32PFREAL48";
                this.typeSize = 6;
                break;
            }
            case 1604: {
                this.typeString = "T_64PREAL48";
                this.typeSize = 8;
                break;
            }
            case 1860: {
                this.typeString = "T_128PREAL48";
                this.typeSize = 16;
                break;
            }
            case 65: {
                this.typeString = "T_REAL64";
                this.typeSize = 8;
                break;
            }
            case 321: {
                this.typeString = "T_PREAL64";
                this.typeSize = 2;
                break;
            }
            case 577: {
                this.typeString = "T_PFREAL64";
                this.typeSize = 4;
                break;
            }
            case 833: {
                this.typeString = "T_PHREAL64";
                this.typeSize = 4;
                break;
            }
            case 1089: {
                this.typeString = "T_32PREAL64";
                this.typeSize = 4;
                break;
            }
            case 1345: {
                this.typeString = "T_32PFREAL64";
                this.typeSize = 6;
                break;
            }
            case 1601: {
                this.typeString = "T_64PREAL64";
                this.typeSize = 8;
                break;
            }
            case 1857: {
                this.typeString = "T_128PREAL64";
                this.typeSize = 16;
                break;
            }
            case 66: {
                this.typeString = "T_REAL80";
                this.typeSize = 10;
                break;
            }
            case 322: {
                this.typeString = "T_PREAL80";
                this.typeSize = 2;
                break;
            }
            case 578: {
                this.typeString = "T_PFREAL80";
                this.typeSize = 4;
                break;
            }
            case 834: {
                this.typeString = "T_PHREAL80";
                this.typeSize = 4;
                break;
            }
            case 1090: {
                this.typeString = "T_32PREAL80";
                this.typeSize = 4;
                break;
            }
            case 1346: {
                this.typeString = "T_32PFREAL80";
                this.typeSize = 6;
                break;
            }
            case 1602: {
                this.typeString = "T_64PREAL80";
                this.typeSize = 8;
                break;
            }
            case 1858: {
                this.typeString = "T_128PREAL80";
                this.typeSize = 16;
                break;
            }
            case 67: {
                this.typeString = "T_REAL128";
                this.typeSize = 16;
                break;
            }
            case 323: {
                this.typeString = "T_PREAL128";
                this.typeSize = 2;
                break;
            }
            case 579: {
                this.typeString = "T_PFREAL128";
                this.typeSize = 4;
                break;
            }
            case 835: {
                this.typeString = "T_PHREAL128";
                this.typeSize = 4;
                break;
            }
            case 1091: {
                this.typeString = "T_32PREAL128";
                this.typeSize = 4;
                break;
            }
            case 1347: {
                this.typeString = "T_32PFREAL128";
                this.typeSize = 6;
                break;
            }
            case 1603: {
                this.typeString = "T_64PREAL128";
                this.typeSize = 8;
                break;
            }
            case 1859: {
                this.typeString = "T_128PREAL128";
                this.typeSize = 16;
                break;
            }
            case 80: {
                this.typeString = "T_CPLX32";
                this.typeSize = 4;
                break;
            }
            case 336: {
                this.typeString = "T_PCPLX32";
                this.typeSize = 2;
                break;
            }
            case 592: {
                this.typeString = "T_PFCPLX32";
                this.typeSize = 4;
                break;
            }
            case 848: {
                this.typeString = "T_PHCPLX32";
                this.typeSize = 4;
                break;
            }
            case 1104: {
                this.typeString = "T_32PCPLX32";
                this.typeSize = 4;
                break;
            }
            case 1360: {
                this.typeString = "T_32PFCPLX32";
                this.typeSize = 6;
                break;
            }
            case 1616: {
                this.typeString = "T_64PCPLX32";
                this.typeSize = 8;
                break;
            }
            case 1872: {
                this.typeString = "T_128PCPLX32";
                this.typeSize = 16;
                break;
            }
            case 81: {
                this.typeString = "T_CPLX64";
                this.typeSize = 8;
                break;
            }
            case 337: {
                this.typeString = "T_PCPLX64";
                this.typeSize = 2;
                break;
            }
            case 593: {
                this.typeString = "T_PFCPLX64";
                this.typeSize = 4;
                break;
            }
            case 849: {
                this.typeString = "T_PHCPLX64";
                this.typeSize = 4;
                break;
            }
            case 1105: {
                this.typeString = "T_32PCPLX64";
                this.typeSize = 4;
                break;
            }
            case 1361: {
                this.typeString = "T_32PFCPLX64";
                this.typeSize = 6;
                break;
            }
            case 1617: {
                this.typeString = "T_64PCPLX64";
                this.typeSize = 8;
                break;
            }
            case 1873: {
                this.typeString = "T_128PCPLX64";
                this.typeSize = 16;
                break;
            }
            case 82: {
                this.typeString = "T_CPLX80";
                this.typeSize = 10;
                break;
            }
            case 338: {
                this.typeString = "T_PCPLX80";
                this.typeSize = 2;
                break;
            }
            case 594: {
                this.typeString = "T_PFCPLX80";
                this.typeSize = 4;
                break;
            }
            case 850: {
                this.typeString = "T_PHCPLX80";
                this.typeSize = 4;
                break;
            }
            case 1106: {
                this.typeString = "T_32PCPLX80";
                this.typeSize = 4;
                break;
            }
            case 1362: {
                this.typeString = "T_32PFCPLX80";
                this.typeSize = 6;
                break;
            }
            case 1618: {
                this.typeString = "T_64PCPLX80";
                this.typeSize = 8;
                break;
            }
            case 1874: {
                this.typeString = "T_128PCPLX80";
                this.typeSize = 16;
                break;
            }
            case 83: {
                this.typeString = "T_CPLX128";
                this.typeSize = 16;
                break;
            }
            case 339: {
                this.typeString = "T_PCPLX128";
                this.typeSize = 2;
                break;
            }
            case 595: {
                this.typeString = "T_PFCPLX128";
                this.typeSize = 4;
                break;
            }
            case 851: {
                this.typeString = "T_PHCPLX128";
                this.typeSize = 4;
                break;
            }
            case 1107: {
                this.typeString = "T_32PCPLX128";
                this.typeSize = 4;
                break;
            }
            case 1363: {
                this.typeString = "T_32PFCPLX128";
                this.typeSize = 6;
                break;
            }
            case 1619: {
                this.typeString = "T_64PCPLX128";
                this.typeSize = 8;
                break;
            }
            case 1875: {
                this.typeString = "T_128PCPLX128";
                this.typeSize = 16;
                break;
            }
            case 48: {
                this.typeString = "T_BOOL08";
                this.typeSize = 1;
                break;
            }
            case 304: {
                this.typeString = "T_PBOOL08";
                this.typeSize = 2;
                break;
            }
            case 560: {
                this.typeString = "T_PFBOOL08";
                this.typeSize = 4;
                break;
            }
            case 816: {
                this.typeString = "T_PHBOOL08";
                this.typeSize = 4;
                break;
            }
            case 1072: {
                this.typeString = "T_32PBOOL08";
                this.typeSize = 4;
                break;
            }
            case 1328: {
                this.typeString = "T_32PFBOOL08";
                this.typeSize = 6;
                break;
            }
            case 1584: {
                this.typeString = "T_64PBOOL08";
                this.typeSize = 8;
                break;
            }
            case 1840: {
                this.typeString = "T_128PBOOL08";
                this.typeSize = 16;
                break;
            }
            case 49: {
                this.typeString = "T_BOOL16";
                this.typeSize = 2;
                break;
            }
            case 305: {
                this.typeString = "T_PBOOL16";
                this.typeSize = 2;
                break;
            }
            case 561: {
                this.typeString = "T_PFBOOL16";
                this.typeSize = 4;
                break;
            }
            case 817: {
                this.typeString = "T_PHBOOL16";
                this.typeSize = 4;
                break;
            }
            case 1073: {
                this.typeString = "T_32PBOOL16";
                this.typeSize = 4;
                break;
            }
            case 1329: {
                this.typeString = "T_32PFBOOL16";
                this.typeSize = 6;
                break;
            }
            case 1585: {
                this.typeString = "T_64PBOOL16";
                this.typeSize = 8;
                break;
            }
            case 1841: {
                this.typeString = "T_128PBOOL16";
                this.typeSize = 16;
                break;
            }
            case 50: {
                this.typeString = "T_BOOL32";
                this.typeSize = 4;
                break;
            }
            case 306: {
                this.typeString = "T_PBOOL32";
                this.typeSize = 2;
                break;
            }
            case 562: {
                this.typeString = "T_PFBOOL32";
                this.typeSize = 4;
                break;
            }
            case 818: {
                this.typeString = "T_PHBOOL32";
                this.typeSize = 4;
                break;
            }
            case 1074: {
                this.typeString = "T_32PBOOL32";
                this.typeSize = 4;
                break;
            }
            case 1330: {
                this.typeString = "T_32PFBOOL32";
                this.typeSize = 6;
                break;
            }
            case 1586: {
                this.typeString = "T_64PBOOL32";
                this.typeSize = 8;
                break;
            }
            case 1842: {
                this.typeString = "T_128PBOOL32";
                this.typeSize = 16;
                break;
            }
            case 51: {
                this.typeString = "T_BOOL64";
                this.typeSize = 8;
                break;
            }
            case 307: {
                this.typeString = "T_PBOOL64";
                this.typeSize = 2;
                break;
            }
            case 563: {
                this.typeString = "T_PFBOOL64";
                this.typeSize = 4;
                break;
            }
            case 819: {
                this.typeString = "T_PHBOOL64";
                this.typeSize = 4;
                break;
            }
            case 1075: {
                this.typeString = "T_32PBOOL64";
                this.typeSize = 4;
                break;
            }
            case 1331: {
                this.typeString = "T_32PFBOOL64";
                this.typeSize = 6;
                break;
            }
            case 1587: {
                this.typeString = "T_64PBOOL64";
                this.typeSize = 8;
                break;
            }
            case 1843: {
                this.typeString = "T_128PBOOL64";
                this.typeSize = 16;
                break;
            }
            case 52: {
                this.typeString = "T_BOOL128";
                this.typeSize = 16;
                break;
            }
            case 308: {
                this.typeString = "T_PBOOL128";
                this.typeSize = 2;
                break;
            }
            case 564: {
                this.typeString = "T_PFBOOL128";
                this.typeSize = 4;
                break;
            }
            case 820: {
                this.typeString = "T_PHBOOL128";
                this.typeSize = 4;
                break;
            }
            case 1076: {
                this.typeString = "T_32PBOOL128";
                this.typeSize = 4;
                break;
            }
            case 1332: {
                this.typeString = "T_32PFBOOL128";
                this.typeSize = 6;
                break;
            }
            case 1588: {
                this.typeString = "T_64PBOOL128";
                this.typeSize = 8;
                break;
            }
            case 1844: {
                this.typeString = "T_128PBOOL128";
                this.typeSize = 16;
                break;
            }
            case 496: {
                this.typeString = "T_NCVPTR";
                this.typeSize = 2;
                break;
            }
            case 752: {
                this.typeString = "T_FCVPTR";
                this.typeSize = 4;
                break;
            }
            case 1008: {
                this.typeString = "T_HCVPTR";
                this.typeSize = 4;
                break;
            }
            case 1264: {
                this.typeString = "T_32NCVPTR";
                this.typeSize = 4;
                break;
            }
            case 1520: {
                this.typeString = "T_32FCVPTR";
                this.typeSize = 6;
                break;
            }
            case 1776: {
                this.typeString = "T_64NCVPTR";
                this.typeSize = 8;
                break;
            }
            case 2032: {
                this.typeString = "T_128NCVPTR";
                this.typeSize = 16;
                break;
            }
            default: {
                this.pdb.getPdbReaderMetrics().witnessPrimitive(this.recNum);
                this.typeString = String.format("_UnknownPrimitiveType0X%04X_", this.recNum);
                this.typeSize = 1;
            }
        }
    }
}

