/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.DataTypeNamingUtil;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractArgumentsListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.CallingConvention;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrimitiveMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFunctionTypeApplier
extends MsTypeApplier {
    public AbstractFunctionTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    protected abstract CallingConvention getCallingConvention(AbstractMsType var1);

    protected abstract Pointer getThisPointer(AbstractMsType var1, FixupContext var2, boolean var3) throws CancelledException, PdbException;

    protected abstract Composite getContainingComplexApplier(AbstractMsType var1, FixupContext var2, boolean var3) throws CancelledException, PdbException;

    protected abstract void processContainingType(AbstractMsType var1);

    protected boolean isConstructor(AbstractMsType type) {
        return false;
    }

    protected abstract RecordNumber getReturnRecordNumber(AbstractMsType var1);

    protected abstract RecordNumber getArgListRecordNumber(AbstractMsType var1);

    private boolean setReturnType(FunctionDefinitionDataType functionDefinition, AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        if (this.isConstructor(type)) {
            return true;
        }
        RecordNumber returnRecord = this.getReturnRecordNumber(type);
        if (returnRecord == null) {
            return false;
        }
        DataType returnType = this.applicator.getProcessedDataType(returnRecord, fixupContext, breakCycle);
        if (returnType == null) {
            return false;
        }
        if (this.applicator.isPlaceholderPointer(returnType)) {
            return false;
        }
        functionDefinition.setReturnType(returnType);
        return true;
    }

    private void setCallingConvention(FunctionDefinitionDataType functionDefinition, CallingConvention callingConvention, Pointer thisPointer) {
        String convention;
        if (thisPointer != null) {
            convention = "__thiscall";
        } else {
            switch (callingConvention) {
                case THISCALL: {
                    convention = "__thiscall";
                    break;
                }
                case NEAR_C: {
                    convention = "__cdecl";
                    break;
                }
                case NEAR_VECTOR: {
                    convention = "__vectorcall";
                    break;
                }
                default: {
                    convention = "__cdecl";
                }
            }
        }
        try {
            functionDefinition.setCallingConvention(convention);
        }
        catch (InvalidInputException e) {
            this.applicator.appendLogMsg("Failed to set calling convention `" + convention + "` for " + functionDefinition.getName());
        }
    }

    private boolean setArguments(FunctionDefinitionDataType functionDefinition, AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        RecordNumber argsRecord = this.getArgListRecordNumber(type);
        AbstractMsType aType = this.applicator.getPdb().getTypeRecord(argsRecord);
        if (!(aType instanceof AbstractArgumentsListMsType)) {
            this.applicator.appendLogMsg("PDB Warning: expecting args list but found " + aType.getClass().getSimpleName() + " for parameter list of " + functionDefinition.getName());
            return false;
        }
        AbstractArgumentsListMsType argsList = (AbstractArgumentsListMsType)aType;
        boolean hasPlaceholder = false;
        List<RecordNumber> args = argsList.getArgRecordNumbers();
        ArrayList<ParameterDefinitionImpl> parameterDefinitionList = new ArrayList<ParameterDefinitionImpl>();
        int parameterCount = 0;
        for (RecordNumber arg : args) {
            PrimitiveMsType primitive;
            this.applicator.checkCancelled();
            AbstractMsType argMsType = this.applicator.getPdb().getTypeRecord(arg);
            if (argMsType instanceof PrimitiveMsType && (primitive = (PrimitiveMsType)argMsType).isNoType()) break;
            DataType argDataType = this.applicator.getProcessedDataType(arg, fixupContext, breakCycle);
            if (argDataType == null) {
                this.applicator.appendLogMsg("PDB Warning: No type conversion for " + argMsType.toString() + " for parameter " + parameterCount + " of " + functionDefinition.getName());
                continue;
            }
            if (this.applicator.isPlaceholderPointer(argDataType)) {
                hasPlaceholder = true;
            }
            try {
                ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, argDataType, "");
                parameterDefinitionList.add(parameterDefinition);
                ++parameterCount;
            }
            catch (IllegalArgumentException e) {
                try {
                    DataType substitute = Undefined.getUndefinedDataType((int)argDataType.getLength());
                    ParameterDefinitionImpl parameterDefinition = new ParameterDefinitionImpl(null, substitute, "");
                    parameterDefinitionList.add(parameterDefinition);
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + argDataType + " for parameter " + ++parameterCount + " of " + functionDefinition.getName() + ". Using undefined type instead.");
                }
                catch (IllegalArgumentException e1) {
                    this.applicator.appendLogMsg("PDB Warning: Could not apply type " + argDataType + " for parameter " + parameterCount + " of " + functionDefinition.getName() + ". Undefined failed: " + e1);
                }
                return false;
            }
        }
        if (hasPlaceholder) {
            return false;
        }
        functionDefinition.setArguments(parameterDefinitionList.toArray(new ParameterDefinition[parameterDefinitionList.size()]));
        return true;
    }

    @Override
    public DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws CancelledException, PdbException {
        DataType existing = this.applicator.getDataType(type);
        if (existing != null) {
            return existing;
        }
        FunctionDefinitionDataType functionDefinition = new FunctionDefinitionDataType(this.applicator.getAnonymousFunctionsCategory(), "_func", this.applicator.getDataTypeManager());
        boolean hasPlaceholder = false;
        this.processContainingType(type);
        if (!this.setReturnType(functionDefinition, type, fixupContext, breakCycle)) {
            hasPlaceholder = true;
        }
        if (!this.setArguments(functionDefinition, type, fixupContext, breakCycle)) {
            hasPlaceholder = true;
        }
        if (hasPlaceholder) {
            return null;
        }
        Pointer thisPointer = this.getThisPointer(type, fixupContext, breakCycle);
        CallingConvention convention = this.getCallingConvention(type);
        this.setCallingConvention(functionDefinition, convention, thisPointer);
        DataTypeNamingUtil.setMangledAnonymousFunctionName((FunctionDefinitionDataType)functionDefinition);
        DataType resolvedType = this.applicator.resolve((DataType)functionDefinition);
        this.applicator.putDataType(type, resolvedType);
        return resolvedType;
    }
}

