/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FixupContext;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.exception.CancelledException;

public class BitfieldTypeApplier
extends MsTypeApplier {
    public BitfieldTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    @Override
    DataType apply(AbstractMsType type, FixupContext fixupContext, boolean breakCycle) throws PdbException, CancelledException {
        Pdb2BitField bitFieldDataType;
        AbstractBitfieldMsType mType = (AbstractBitfieldMsType)type;
        RecordNumber elementRecordNumber = mType.getElementRecordNumber();
        DataType baseDataType = this.applicator.getProcessedDataType(elementRecordNumber, fixupContext, breakCycle);
        try {
            bitFieldDataType = new Pdb2BitField(baseDataType.clone(this.applicator.getDataTypeManager()), mType.getBitLength(), mType.getBitPosition());
        }
        catch (InvalidDataTypeException e) {
            this.applicator.appendLogMsg("Problem creating PdbBitField for " + type.getName() + ", error: " + e.toString());
            return null;
        }
        return bitFieldDataType;
    }

    private class Pdb2BitField
    extends PdbBitField {
        private Pdb2BitField(DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) throws InvalidDataTypeException {
            super(baseDataType, bitSize, bitOffsetWithinBaseType);
        }
    }
}

