/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDataMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class DataSymbolApplier
extends MsSymbolApplier {
    private AbstractDataMsSymbol symbol;

    public DataSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractDataMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.symbol = (AbstractDataMsSymbol)abstractSymbol;
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) throws PdbException, CancelledException {
        if (applyToApplier instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applyToApplier;
            DataType dataType = this.applicator.getCompletedDataType(this.symbol.getTypeRecordNumber());
            if (dataType == null) {
                return;
            }
            Address address = this.applicator.getAddress(this.symbol);
            if (!this.createData(address, dataType)) {
                return;
            }
            functionSymbolApplier.setLocalVariable(address, this.symbol.getName(), dataType);
        }
    }

    @Override
    void apply() throws CancelledException, PdbException {
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, this.symbol.getName())) {
            return;
        }
        RecordNumber typeRecordNumber = this.symbol.getTypeRecordNumber();
        if (!this.createData(symbolAddress, typeRecordNumber)) {
            return;
        }
        this.applicator.createSymbol(symbolAddress, this.symbol.getName(), true);
    }

    MsTypeApplier getTypeApplier() {
        return this.applicator.getTypeApplier(this.symbol.getTypeRecordNumber());
    }

    boolean createData(Address address, RecordNumber typeRecordNumber) throws CancelledException, PdbException {
        DataType dataType = this.applicator.getCompletedDataType(this.symbol.getTypeRecordNumber());
        return this.createData(address, dataType);
    }

    boolean createData(Address address, DataType dataType) {
        if (this.applicator.isInvalidAddress(address, this.symbol.getName())) {
            return false;
        }
        if (this.applicator.getImageBase().equals((Object)address) && !"_IMAGE_DOS_HEADER".equals(dataType.getName())) {
            return false;
        }
        if (!(dataType instanceof FunctionDefinition)) {
            DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.applicator.getProgram().getMemory(), address);
            DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)dataType, (MemBuffer)memBuffer, (boolean)false);
            if (dti == null) {
                this.applicator.appendLogMsg("Error: Failed to apply datatype " + dataType.getName() + " at " + address);
                return false;
            }
            this.createData(address, dti.getDataType(), dti.getLength());
        }
        return true;
    }

    private void createData(Address address, DataType dataType, int dataTypeLength) {
        block18: {
            DataType existingDataType;
            Data existingData = null;
            CodeUnit cu = this.applicator.getProgram().getListing().getCodeUnitContaining(address);
            if (cu != null) {
                if (cu instanceof Instruction || !address.equals((Object)cu.getAddress())) {
                    this.applicator.appendLogMsg("Warning: Did not create data type \"" + dataType.getDisplayName() + "\" at address " + address + " due to conflict");
                    return;
                }
                Data d = (Data)cu;
                if (d.isDefined()) {
                    existingData = d;
                }
            }
            if (dataType == null) {
                return;
            }
            if (dataType.getLength() <= 0 && dataTypeLength <= 0) {
                this.applicator.appendLogMsg("Unknown dataTypeLength specified at address " + address + " for " + dataType.getName());
                return;
            }
            if (existingData != null) {
                existingDataType = existingData.getDataType();
                if (this.isEquivalent(existingData, existingData.getLength(), dataType)) {
                    return;
                }
                if (this.isEquivalent2(existingDataType, dataType)) {
                    return;
                }
                if (existingDataType.isEquivalent(dataType)) {
                    return;
                }
            }
            if (existingData == null) {
                try {
                    this.applicator.getProgram().getListing().clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    if (dataType.getLength() == -1) {
                        this.applicator.getProgram().getListing().createData(address, dataType, dataTypeLength);
                        break block18;
                    }
                    this.applicator.getProgram().getListing().createData(address, dataType);
                }
                catch (CodeUnitInsertionException e) {
                    this.applicator.appendLogMsg("Unable to create " + dataType.getDisplayName() + " at 0x" + address + ": " + e.getMessage());
                }
            } else if (this.isDataReplaceable(existingData)) {
                try {
                    this.applicator.getProgram().getListing().clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    this.applicator.getProgram().getListing().createData(address, dataType, dataTypeLength);
                }
                catch (CodeUnitInsertionException e) {
                    this.applicator.appendLogMsg("Unable to replace " + dataType.getDisplayName() + " at 0x" + address + ": " + e.getMessage());
                }
            } else {
                existingDataType = existingData.getDataType();
                String existingDataTypeString = existingDataType == null ? "null" : existingDataType.getDisplayName();
                this.applicator.appendLogMsg("Warning: Did not create data type \"" + dataType.getDisplayName() + "\" at address " + address + ".  Preferring existing datatype \"" + existingDataTypeString + "\"");
            }
        }
    }

    private boolean isDataReplaceable(Data data) {
        Array array;
        DataType arrayDataType;
        Pointer pointer;
        DataType pointerDataType;
        DataType dataType = data.getDataType();
        if (dataType instanceof Pointer ? (pointerDataType = (pointer = (Pointer)dataType).getDataType()) == null || pointerDataType.isEquivalent(DataType.DEFAULT) : dataType instanceof Array && ((arrayDataType = (array = (Array)dataType).getDataType()) == null || arrayDataType.isEquivalent(DataType.DEFAULT))) {
            return true;
        }
        return Undefined.isUndefined((DataType)dataType);
    }

    private boolean isEquivalent(Data existingData, int existingDataTypeLength, DataType newDataType) {
        Array array;
        DataType arrayDataType;
        return existingData.hasStringValue() && newDataType instanceof ArrayDataType && (arrayDataType = (array = (Array)newDataType).getDataType()) instanceof ArrayStringable && array.getLength() == existingDataTypeLength;
    }

    private boolean isEquivalent2(DataType datatype1, DataType datatype2) {
        if (datatype1 == datatype2) {
            return true;
        }
        if (datatype1 == null || datatype2 == null) {
            return false;
        }
        if (datatype1 instanceof Array) {
            Array array1 = (Array)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(array1.getDataType(), array2.getDataType());
            }
        } else if (datatype1 instanceof Pointer) {
            Pointer pointer1 = (Pointer)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(pointer1.getDataType(), array2.getDataType());
            }
        }
        return datatype1.isEquivalent(datatype2);
    }
}

