/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.EndMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.ProcedureIdEndMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.ManagedProcedureSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SeparatedCodeSymbolApplier;
import ghidra.util.exception.AssertException;

public class EndSymbolApplier
extends MsSymbolApplier {
    public EndSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof EndMsSymbol) && !(abstractSymbol instanceof ProcedureIdEndMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
    }

    @Override
    void apply() throws PdbException {
        this.pdbLogAndInfoMessage(this, String.format("Cannot apply %s directly to program (stream:0X%04X, offset:0X%08X)", this.getClass().getSimpleName(), this.iter.getStreamNumber(), this.iter.getCurrentOffset()));
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
        if (!(applyToApplier instanceof FunctionSymbolApplier)) {
            return;
        }
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        if (applierParam instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applierParam;
            functionSymbolApplier.endBlock();
        } else if (applierParam instanceof SeparatedCodeSymbolApplier) {
            SeparatedCodeSymbolApplier separatedCodeSymbolApplier = (SeparatedCodeSymbolApplier)applierParam;
            separatedCodeSymbolApplier.endBlock();
        } else if (applierParam instanceof ManagedProcedureSymbolApplier) {
            ManagedProcedureSymbolApplier procedureSymbolApplier = (ManagedProcedureSymbolApplier)applierParam;
            procedureSymbolApplier.endBlock();
        }
    }
}

