/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartIa64MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartMipsMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractThunkMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockCommentsManager;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DeferrableFunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionSymbolApplier
extends MsSymbolApplier
implements DeferrableFunctionSymbolApplier {
    private static final String BLOCK_INDENT = "   ";
    private AbstractProcedureMsSymbol procedureSymbol;
    private AbstractThunkMsSymbol thunkSymbol;
    private Address specifiedAddress;
    private Address address;
    private boolean isNonReturning;
    private Function function = null;
    private long specifiedFrameSize = 0L;
    private long currentFrameSize = 0L;
    private BlockCommentsManager comments;
    private int symbolBlockNestingLevel;
    private Address currentBlockAddress;
    private int baseParamOffset = 0;
    private List<MsSymbolApplier> allAppliers = new ArrayList<MsSymbolApplier>();
    private RegisterChangeCalculator registerChangeCalculator;

    public FunctionSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) throws CancelledException {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        this.symbolBlockNestingLevel = 0;
        this.comments = new BlockCommentsManager();
        this.currentBlockAddress = null;
        if (abstractSymbol instanceof AbstractProcedureMsSymbol) {
            this.procedureSymbol = (AbstractProcedureMsSymbol)abstractSymbol;
            this.specifiedAddress = applicator.getRawAddress(this.procedureSymbol);
            this.address = applicator.getAddress(this.procedureSymbol);
            this.isNonReturning = ((AbstractProcedureStartMsSymbol)this.procedureSymbol).getFlags().doesNotReturn();
        } else if (abstractSymbol instanceof AbstractProcedureStartIa64MsSymbol) {
            this.procedureSymbol = (AbstractProcedureStartIa64MsSymbol)abstractSymbol;
            this.specifiedAddress = applicator.getRawAddress(this.procedureSymbol);
            this.address = applicator.getAddress(this.procedureSymbol);
            this.isNonReturning = ((AbstractProcedureStartIa64MsSymbol)this.procedureSymbol).getFlags().doesNotReturn();
        } else if (abstractSymbol instanceof AbstractProcedureStartMipsMsSymbol) {
            this.procedureSymbol = (AbstractProcedureStartMipsMsSymbol)abstractSymbol;
            this.specifiedAddress = applicator.getRawAddress(this.procedureSymbol);
            this.address = applicator.getAddress(this.procedureSymbol);
            this.isNonReturning = false;
        } else if (abstractSymbol instanceof AbstractThunkMsSymbol) {
            this.thunkSymbol = (AbstractThunkMsSymbol)abstractSymbol;
            this.specifiedAddress = applicator.getRawAddress(this.thunkSymbol);
            this.address = applicator.getAddress(this.thunkSymbol);
        } else {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.manageBlockNesting(this);
        while (this.notDone()) {
            applicator.checkCancelled();
            MsSymbolApplier applier = applicator.getSymbolApplier(iter);
            this.allAppliers.add(applier);
            applier.manageBlockNesting(this);
        }
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        if (applierParam instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applierParam;
            if (this.procedureSymbol != null) {
                long start = this.procedureSymbol.getDebugStartOffset();
                long end = this.procedureSymbol.getDebugEndOffset();
                Address blockAddress = this.address.add(start);
                long length = end - start;
                functionSymbolApplier.beginBlock(blockAddress, this.procedureSymbol.getName(), length);
            } else if (this.thunkSymbol != null) {
                functionSymbolApplier.beginBlock(this.address, this.thunkSymbol.getName(), this.thunkSymbol.getLength());
            }
        }
    }

    long getLength() {
        if (this.procedureSymbol != null) {
            return this.procedureSymbol.getProcedureLength();
        }
        if (this.thunkSymbol != null) {
            return this.thunkSymbol.getLength();
        }
        throw new AssertException("Unexpected Symbol type");
    }

    Function getFunction() {
        return this.function;
    }

    long getCurrentFrameSize() {
        return this.currentFrameSize;
    }

    long getSpecifiedFrameSize() {
        return this.specifiedFrameSize;
    }

    void setSpecifiedFrameSize(long specifiedFrameSize) {
        this.specifiedFrameSize = specifiedFrameSize;
        this.currentFrameSize = specifiedFrameSize;
    }

    String getName() {
        if (this.procedureSymbol != null) {
            return this.procedureSymbol.getName();
        }
        if (this.thunkSymbol != null) {
            return this.thunkSymbol.getName();
        }
        return "";
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws PdbException, CancelledException {
        boolean result = this.applyTo(this.applicator.getCancelOnlyWrappingMonitor());
        if (!result) {
            throw new PdbException(this.getClass().getSimpleName() + ": failure at " + this.address + " applying " + this.getName());
        }
    }

    boolean applyTo(TaskMonitor monitor) throws PdbException, CancelledException {
        if (this.applicator.isInvalidAddress(this.address, this.getName())) {
            return false;
        }
        boolean functionSuccess = this.applyFunction(monitor);
        if (!functionSuccess) {
            return false;
        }
        this.registerChangeCalculator = new RegisterChangeCalculator(this.procedureSymbol, this.function, monitor);
        this.baseParamOffset = VariableUtilities.getBaseStackParamOffset((Function)this.function);
        for (MsSymbolApplier applier : this.allAppliers) {
            applier.applyTo(this);
        }
        long addressDelta = this.address.subtract(this.specifiedAddress);
        this.comments.applyTo(this.applicator.getProgram(), addressDelta);
        return true;
    }

    Integer getRegisterPrologChange(Register register) {
        return this.registerChangeCalculator.getRegChange(this.applicator, register);
    }

    int getBaseParamOffset() {
        return this.baseParamOffset;
    }

    void setLocalVariable(Address varAddress, String varName, DataType dataType) {
        if (this.currentBlockAddress == null) {
            return;
        }
        if (varName.isBlank()) {
            return;
        }
        String plateAddition = "PDB: static local for function (" + this.address + "): " + this.getName();
        this.applicator.createSymbol(varAddress, varName, true, plateAddition);
    }

    private boolean applyFunction(TaskMonitor monitor) throws CancelledException, PdbException {
        this.function = this.applicator.getExistingOrCreateOneByteFunction(this.address);
        if (this.function == null) {
            return false;
        }
        this.applicator.scheduleDeferredFunctionWork(this);
        boolean succeededSetFunctionSignature = false;
        if (this.thunkSymbol == null && this.function.getSignatureSource().isLowerPriorityThan(SourceType.IMPORTED)) {
            this.function.setThunkedFunction(null);
            succeededSetFunctionSignature = this.setFunctionDefinition(monitor);
            this.function.setNoReturn(this.isNonReturning);
        }
        this.applicator.createSymbol(this.address, this.getName(), succeededSetFunctionSignature);
        this.currentFrameSize = 0L;
        return true;
    }

    private boolean setFunctionDefinition(TaskMonitor monitor) throws CancelledException, PdbException {
        if (this.procedureSymbol == null) {
            return false;
        }
        RecordNumber typeRecordNumber = this.procedureSymbol.getTypeRecordNumber();
        MsTypeApplier applier = this.applicator.getTypeApplier(typeRecordNumber);
        AbstractMsType fType = this.applicator.getPdb().getTypeRecord(typeRecordNumber);
        if (!(applier instanceof AbstractFunctionTypeApplier)) {
            PrimitiveTypeApplier prim;
            if (!(applier instanceof PrimitiveTypeApplier) || !(prim = (PrimitiveTypeApplier)applier).isNoType(fType)) {
                this.applicator.appendLogMsg("Error: Failed to resolve datatype RecordNumber " + typeRecordNumber + " at " + this.address);
            }
            return false;
        }
        DataType dataType = this.applicator.getCompletedDataType(typeRecordNumber);
        if (!(dataType instanceof FunctionDefinition)) {
            return false;
        }
        FunctionDefinition def = (FunctionDefinition)dataType.copy(this.applicator.getDataTypeManager());
        try {
            def.setName(this.function.getName());
        }
        catch (InvalidNameException | DuplicateNameException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        ApplyFunctionSignatureCmd sigCmd = new ApplyFunctionSignatureCmd(this.address, (FunctionSignature)def, SourceType.IMPORTED);
        if (!sigCmd.applyTo((DomainObject)this.applicator.getProgram(), monitor)) {
            this.applicator.appendLogMsg("PDB Warning: Failed to apply signature to function at address " + this.address + " due to " + sigCmd.getStatusMsg() + "; dataType: " + def.getName());
            return false;
        }
        return true;
    }

    private boolean notDone() {
        return this.symbolBlockNestingLevel > 0 && this.iter.hasNext();
    }

    int endBlock() {
        if (--this.symbolBlockNestingLevel < 0) {
            this.applicator.appendLogMsg("Block Nesting went negative for " + this.getName() + " at " + this.address);
        }
        if (this.symbolBlockNestingLevel == 0) {
            // empty if block
        }
        return this.symbolBlockNestingLevel;
    }

    void beginBlock(Address startAddress, String name, long length) {
        int nestingLevel = this.beginBlock(startAddress);
        if (!this.applicator.getPdbApplicatorOptions().applyCodeScopeBlockComments()) {
            return;
        }
        if (this.applicator.isInvalidAddress(startAddress, name)) {
            return;
        }
        String indent = this.getIndent(nestingLevel);
        String baseComment = "level " + nestingLevel + ", length " + length;
        String preComment = indent + "PDB: Block Beg, " + baseComment;
        if (!name.isEmpty()) {
            preComment = preComment + " (" + name + ")";
        }
        this.comments.addPreComment(startAddress, preComment);
        String postComment = indent + "PDB: Block End, " + baseComment;
        Address endAddress = startAddress.add(length <= 0L ? 0L : length - 1L);
        this.comments.addPostComment(endAddress, postComment);
    }

    private int beginBlock(Address startAddress) {
        this.currentBlockAddress = startAddress;
        ++this.symbolBlockNestingLevel;
        return this.symbolBlockNestingLevel;
    }

    private String getIndent(int indentLevel) {
        Object indent = "";
        for (int i = 1; i < indentLevel; ++i) {
            indent = (String)indent + BLOCK_INDENT;
        }
        return indent;
    }

    private int getFrameBaseOffset(TaskMonitor monitor) throws CancelledException {
        int retAddrSize = this.function.getProgram().getDefaultPointerSize();
        if (retAddrSize != 8) {
            return -retAddrSize;
        }
        Register frameReg = this.function.getProgram().getCompilerSpec().getStackPointer();
        Address entryAddr = this.function.getEntryPoint();
        AddressSet scopeSet = new AddressSet();
        scopeSet.addRange(entryAddr, entryAddr.add(64L));
        CallDepthChangeInfo valueChange = new CallDepthChangeInfo(this.function, (AddressSetView)scopeSet, frameReg, monitor);
        InstructionIterator instructions = this.function.getProgram().getListing().getInstructions((AddressSetView)scopeSet, true);
        int max = 0;
        while (instructions.hasNext()) {
            monitor.checkCancelled();
            Instruction next = instructions.next();
            int newValue = valueChange.getDepth(next.getMinAddress());
            if (newValue < -20480 || newValue > 20480 || Math.abs(newValue) <= Math.abs(max)) continue;
            max = newValue;
        }
        return max;
    }

    @Override
    public void doDeferredProcessing() {
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    private static class RegisterChangeCalculator {
        private Map<Register, Integer> registerChangeByRegisterName = new HashMap<Register, Integer>();
        private CallDepthChangeInfo callDepthChangeInfo;
        private Address debugStart;

        private RegisterChangeCalculator(AbstractProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            this.callDepthChangeInfo = this.createCallDepthChangInfo(procedureSymbol, function, monitor);
        }

        private CallDepthChangeInfo createCallDepthChangInfo(AbstractProcedureMsSymbol procedureSymbol, Function function, TaskMonitor monitor) throws CancelledException {
            if (procedureSymbol == null) {
                return null;
            }
            Register frameReg = function.getProgram().getCompilerSpec().getStackPointer();
            Address entryAddr = function.getEntryPoint();
            this.debugStart = entryAddr.add(procedureSymbol.getDebugStartOffset());
            AddressSet scopeSet = new AddressSet();
            scopeSet.addRange(entryAddr, this.debugStart);
            return new CallDepthChangeInfo(function, (AddressSetView)scopeSet, frameReg, monitor);
        }

        Integer getRegChange(DefaultPdbApplicator applicator, Register register) {
            if (this.callDepthChangeInfo == null || register == null) {
                return null;
            }
            Integer change = this.registerChangeByRegisterName.get(register);
            if (change != null) {
                return change;
            }
            change = this.callDepthChangeInfo.getRegDepth(this.debugStart, register);
            this.registerChangeByRegisterName.put(register, change);
            return change;
        }
    }
}

