/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.ArgumentsListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ArrayTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BaseClassTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BitfieldTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.CompositeTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.EnumTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.EnumerateTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MemberTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ModifierTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NestedTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.NoTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.PrimitiveTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.ProcedureTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.UdtSourceLineTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.VirtualFunctionTablePointerTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.VtShapeTypeApplier;
import java.util.HashMap;
import java.util.Map;

public class TypeApplierFactory {
    private DefaultPdbApplicator applicator;
    private Map<Integer, MsTypeApplier> appliersByPdbId;

    TypeApplierFactory(DefaultPdbApplicator applicator) {
        this.applicator = applicator;
        this.appliersByPdbId = new HashMap<Integer, MsTypeApplier>();
    }

    MsTypeApplier getApplierSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        MsTypeApplier applier = this.getTypeApplier(recordNumber);
        if (!expected.isInstance(applier)) {
            throw new PdbException(applier.getClass().getSimpleName() + " seen where " + expected.getSimpleName() + " expected for record number " + recordNumber);
        }
        return applier;
    }

    MsTypeApplier getApplierOrNoTypeSpec(RecordNumber recordNumber, Class<? extends MsTypeApplier> expected) throws PdbException {
        MsTypeApplier applier = this.getTypeApplier(recordNumber);
        AbstractMsType type = this.applicator.getPdb().getTypeRecord(recordNumber);
        if (!(expected.isInstance(applier) || applier instanceof PrimitiveTypeApplier && ((PrimitiveTypeApplier)applier).isNoType(type))) {
            throw new PdbException(applier.getClass().getSimpleName() + " seen where " + expected.getSimpleName() + " expected for record number " + recordNumber);
        }
        return applier;
    }

    MsTypeApplier getTypeApplier(RecordNumber recordNumber) {
        return this.getTypeApplier(this.applicator.getPdb().getTypeRecord(recordNumber));
    }

    MsTypeApplier getTypeApplier(AbstractMsType type) {
        if (type == null) {
            this.applicator.appendLogMsg("PDB Warning: No AbstractMsType for getTypeApplier");
            return null;
        }
        MsTypeApplier applier = this.getTypeApplier(type.getPdbId());
        if (applier instanceof NoTypeApplier) {
            this.applicator.getPdbApplicatorMetrics().witnessCannotApplyDataType(type);
        }
        return applier;
    }

    MsTypeApplier getTypeApplier(int pdbId) {
        MsTypeApplier applier = this.appliersByPdbId.get(pdbId);
        if (applier != null) {
            return applier;
        }
        try {
            switch (pdbId) {
                case -1: {
                    applier = new PrimitiveTypeApplier(this.applicator);
                    break;
                }
                case 1: {
                    applier = new ModifierTypeApplier(this.applicator);
                    break;
                }
                case 2: {
                    applier = new PointerTypeApplier(this.applicator);
                    break;
                }
                case 3: {
                    applier = new ArrayTypeApplier(this.applicator);
                    break;
                }
                case 4: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 6: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 7: {
                    applier = new EnumTypeApplier(this.applicator);
                    break;
                }
                case 8: {
                    applier = new ProcedureTypeApplier(this.applicator);
                    break;
                }
                case 9: {
                    applier = new MemberFunctionTypeApplier(this.applicator);
                    break;
                }
                case 10: {
                    applier = new VtShapeTypeApplier(this.applicator);
                    break;
                }
                case 513: {
                    applier = new ArgumentsListTypeApplier(this.applicator);
                    break;
                }
                case 516: {
                    applier = new FieldListTypeApplier(this.applicator);
                    break;
                }
                case 518: {
                    applier = new BitfieldTypeApplier(this.applicator);
                    break;
                }
                case 1024: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 1025: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 1026: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 1027: {
                    applier = new EnumerateTypeApplier(this.applicator);
                    break;
                }
                case 1030: {
                    applier = new MemberTypeApplier(this.applicator);
                    break;
                }
                case 1032: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 1033: {
                    applier = new NestedTypeApplier(this.applicator);
                    break;
                }
                case 1034: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator);
                    break;
                }
                case 1036: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 1037: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator);
                    break;
                }
                case 4097: {
                    applier = new ModifierTypeApplier(this.applicator);
                    break;
                }
                case 4098: {
                    applier = new PointerTypeApplier(this.applicator);
                    break;
                }
                case 4099: {
                    applier = new ArrayTypeApplier(this.applicator);
                    break;
                }
                case 4100: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 4101: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 4102: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 4103: {
                    applier = new EnumTypeApplier(this.applicator);
                    break;
                }
                case 4104: {
                    applier = new ProcedureTypeApplier(this.applicator);
                    break;
                }
                case 4105: {
                    applier = new MemberFunctionTypeApplier(this.applicator);
                    break;
                }
                case 4609: {
                    applier = new ArgumentsListTypeApplier(this.applicator);
                    break;
                }
                case 4611: {
                    applier = new FieldListTypeApplier(this.applicator);
                    break;
                }
                case 4613: {
                    applier = new BitfieldTypeApplier(this.applicator);
                    break;
                }
                case 5120: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 5121: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 5122: {
                    applier = new BaseClassTypeApplier(this.applicator);
                    break;
                }
                case 5125: {
                    applier = new MemberTypeApplier(this.applicator);
                    break;
                }
                case 5127: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 5128: {
                    applier = new NestedTypeApplier(this.applicator);
                    break;
                }
                case 5129: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator);
                    break;
                }
                case 5131: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 5132: {
                    applier = new VirtualFunctionTablePointerTypeApplier(this.applicator);
                    break;
                }
                case 5133: {
                    applier = new NestedTypeApplier(this.applicator);
                    break;
                }
                case 5378: {
                    applier = new EnumerateTypeApplier(this.applicator);
                    break;
                }
                case 5379: {
                    applier = new ArrayTypeApplier(this.applicator);
                    break;
                }
                case 5380: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5381: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5382: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5383: {
                    applier = new EnumTypeApplier(this.applicator);
                    break;
                }
                case 5389: {
                    applier = new MemberTypeApplier(this.applicator);
                    break;
                }
                case 5391: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 5392: {
                    applier = new NestedTypeApplier(this.applicator);
                    break;
                }
                case 5393: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
                case 5394: {
                    applier = new NestedTypeApplier(this.applicator);
                    break;
                }
                case 5401: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5638: {
                    applier = new UdtSourceLineTypeApplier(this.applicator);
                    break;
                }
                case 5639: {
                    applier = new UdtSourceLineTypeApplier(this.applicator);
                    break;
                }
                case 5640: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                case 5641: {
                    applier = new CompositeTypeApplier(this.applicator);
                    break;
                }
                default: {
                    applier = new NoTypeApplier(this.applicator);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            String message = "GhidraException on PdbId " + pdbId + ": " + e.getMessage();
            this.applicator.appendLogMsg(message);
            this.applicator.pdbLogAndInfoMessage(this, message);
        }
        this.appliersByPdbId.put(pdbId, applier);
        return applier;
    }
}

