/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractUserDefinedTypeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class TypedefSymbolApplier
extends MsSymbolApplier {
    private DataType resolvedDataType = null;
    private AbstractUserDefinedTypeMsSymbol udtSymbol;

    public TypedefSymbolApplier(DefaultPdbApplicator applicator, MsSymbolIterator iter) {
        super(applicator, iter);
        AbstractMsSymbol abstractSymbol = iter.next();
        if (!(abstractSymbol instanceof AbstractUserDefinedTypeMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        this.udtSymbol = (AbstractUserDefinedTypeMsSymbol)abstractSymbol;
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.resolvedDataType = this.applyUserDefinedTypeMsSymbol(this.udtSymbol);
    }

    String getName() {
        return this.udtSymbol.getName();
    }

    RecordNumber getTypeRecordNumber() {
        return this.udtSymbol.getTypeRecordNumber();
    }

    DataType getResolvedDataType() throws PdbException {
        if (this.resolvedDataType == null) {
            throw new PdbException("Data type not resolved");
        }
        return this.resolvedDataType;
    }

    private DataType applyUserDefinedTypeMsSymbol(AbstractUserDefinedTypeMsSymbol symbol) throws CancelledException, PdbException {
        String name = symbol.getName();
        AbstractMsType mType = this.applicator.getPdb().getTypeRecord(this.getTypeRecordNumber());
        MsTypeApplier applier = this.applicator.getTypeApplier(symbol.getTypeRecordNumber());
        if (applier == null) {
            return null;
        }
        DataType dataType = this.applicator.getCompletedDataType(this.getTypeRecordNumber());
        if (dataType == null) {
            return null;
        }
        if (mType instanceof AbstractComplexMsType && name.equals(mType.getName())) {
            return dataType;
        }
        SymbolPath symbolPath = new SymbolPath(name);
        CategoryPath categoryPath = this.applicator.getTypedefsCategory(this.applicator.getCurrentModuleNumber(), symbolPath);
        TypedefDataType typedef = new TypedefDataType(categoryPath.getParent(), categoryPath.getName(), dataType, this.applicator.getDataTypeManager());
        return this.applicator.resolve((DataType)typedef);
    }
}

