/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Predicate;
import pdb.symbolserver.DisabledSymbolServer;
import pdb.symbolserver.HttpSymbolServer;
import pdb.symbolserver.LocalSymbolStore;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolServerService;

public class SymbolServerInstanceCreatorRegistry {
    private static final SymbolServerInstanceCreatorRegistry instance = new SymbolServerInstanceCreatorRegistry();
    private final TreeMap<Integer, SymbolServerInstanceCreatorInfo> symbolServerInstanceCreatorsByPriority = new TreeMap();

    public static SymbolServerInstanceCreatorRegistry getInstance() {
        return instance;
    }

    private SymbolServerInstanceCreatorRegistry() {
        this.registerDefaultSymbolServerInstanceCreators();
    }

    public void registerSymbolServerInstanceCreator(int priority, Predicate<String> locationStringMatcher, SymbolServerInstanceCreator symbolServerInstanceCreator) {
        SymbolServerInstanceCreatorInfo symbolServerInstanceCreatorInfo = new SymbolServerInstanceCreatorInfo(locationStringMatcher, symbolServerInstanceCreator);
        this.symbolServerInstanceCreatorsByPriority.put(priority, symbolServerInstanceCreatorInfo);
    }

    public List<SymbolServer> createSymbolServersFromPathList(List<String> locationStrings, SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext) {
        ArrayList<SymbolServer> result = new ArrayList<SymbolServer>();
        for (String locationString : locationStrings) {
            SymbolServer symbolServer = this.newSymbolServer(locationString, symbolServerInstanceCreatorContext);
            if (symbolServer == null) continue;
            result.add(symbolServer);
        }
        return result;
    }

    public SymbolServer newSymbolServer(String symbolServerLocationString, SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext) {
        return this.newSymbolServer(symbolServerLocationString, symbolServerInstanceCreatorContext, SymbolServer.class);
    }

    public <T extends SymbolServer> T newSymbolServer(String symbolServerLocationString, SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext, Class<T> expectedSymbolServerClass) {
        if (symbolServerLocationString == null || symbolServerLocationString.isBlank()) {
            return null;
        }
        for (SymbolServerInstanceCreatorInfo symbolServerInstanceCreatorInfo : this.symbolServerInstanceCreatorsByPriority.values()) {
            if (!symbolServerInstanceCreatorInfo.getLocationStringMatcher().test(symbolServerLocationString)) continue;
            SymbolServer result = symbolServerInstanceCreatorInfo.getSymbolServerInstanceCreator().createSymbolServerFromLocationString(symbolServerLocationString, symbolServerInstanceCreatorContext);
            if (result == null) {
                return null;
            }
            if (!expectedSymbolServerClass.isInstance(result)) {
                Msg.debug((Object)this, (Object)("SymbolServer location unexpected class type.  Wanted " + expectedSymbolServerClass.getName() + ", got " + result.getClass().getName()));
                return null;
            }
            return (T)((SymbolServer)expectedSymbolServerClass.cast(result));
        }
        Msg.debug(SymbolServerService.class, (Object)("Symbol server location [" + symbolServerLocationString + "] not valid, skipping."));
        return null;
    }

    public SymbolServerInstanceCreatorContext getContext() {
        return new SymbolServerInstanceCreatorContext(this);
    }

    public SymbolServerInstanceCreatorContext getContext(Program program) {
        return new SymbolServerInstanceCreatorContext(program, this);
    }

    private void registerDefaultSymbolServerInstanceCreators() {
        this.registerSymbolServerInstanceCreator(0, DisabledSymbolServer::isDisabledSymbolServerLocation, DisabledSymbolServer::createInstance);
        this.registerSymbolServerInstanceCreator(100, HttpSymbolServer::isHttpSymbolServerLocation, (loc, context) -> new HttpSymbolServer(URI.create(loc)));
        this.registerSymbolServerInstanceCreator(200, SameDirSymbolStore::isSameDirLocation, SameDirSymbolStore::createInstance);
        this.registerSymbolServerInstanceCreator(300, LocalSymbolStore::isLocalSymbolStoreLocation, (loc, context) -> new LocalSymbolStore(new File(loc)));
    }

    private static class SymbolServerInstanceCreatorInfo {
        private Predicate<String> locationStringMatcher;
        private SymbolServerInstanceCreator symbolServerInstanceCreator;

        SymbolServerInstanceCreatorInfo(Predicate<String> locationStringMatcher, SymbolServerInstanceCreator symbolServerInstanceCreator) {
            this.locationStringMatcher = locationStringMatcher;
            this.symbolServerInstanceCreator = symbolServerInstanceCreator;
        }

        Predicate<String> getLocationStringMatcher() {
            return this.locationStringMatcher;
        }

        SymbolServerInstanceCreator getSymbolServerInstanceCreator() {
            return this.symbolServerInstanceCreator;
        }
    }

    public static interface SymbolServerInstanceCreator {
        public SymbolServer createSymbolServerFromLocationString(String var1, SymbolServerInstanceCreatorContext var2);
    }
}

