/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.dbg.target.TargetMethod;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractScriptTraceRmiLaunchOffer
extends AbstractTraceRmiLaunchOffer {
    protected final File script;
    protected final String configName;
    protected final ScriptAttributesParser.ScriptAttributes attrs;

    public AbstractScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program);
        this.script = script;
        this.configName = configName;
        this.attrs = attrs;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getTitle() {
        return this.attrs.title();
    }

    public String getDescription() {
        return this.attrs.description();
    }

    public List<String> getMenuPath() {
        return this.attrs.menuPath();
    }

    public String getMenuGroup() {
        return this.attrs.menuGroup();
    }

    public String getMenuOrder() {
        return this.attrs.menuOrder();
    }

    @Override
    public Icon getIcon() {
        return this.attrs.icon();
    }

    public HelpLocation getHelpLocation() {
        return this.attrs.helpLocation();
    }

    public Map<String, TargetMethod.ParameterDescription<?>> getParameters() {
        return this.attrs.parameters();
    }

    protected abstract void prepareSubprocess(List<String> var1, Map<String, String> var2, Map<String, ?> var3, SocketAddress var4);

    @Override
    protected void launchBackEnd(TaskMonitor monitor, Map<String, TerminalSession> sessions, Map<String, ?> args, SocketAddress address) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.prepareSubprocess(commandLine, env, args, address);
        for (String tty : this.attrs.extraTtys()) {
            AbstractTraceRmiLaunchOffer.NullPtyTerminalSession ns = this.nullPtyTerminal();
            env.put(tty, ns.name());
            sessions.put(ns.name(), ns);
        }
        sessions.put("Shell", this.runInTerminal(commandLine, env, this.script.getParentFile(), sessions.values()));
    }
}

