/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.AbstractPathsDialog;
import docking.widgets.pathmanager.AbstractTypedPropertyEditor;
import docking.widgets.pathmanager.PathnameTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.text.StringEscapeUtils;
import utility.function.Callback;

public class ScriptPathsPropertyEditor
extends AbstractTypedPropertyEditor<String> {
    protected String fromText(String text) {
        return text;
    }

    public String getJavaInitializationString() {
        return "\"" + StringEscapeUtils.escapeJava((String)((String)this.getValue())) + "\"";
    }

    public Component getCustomEditor() {
        return new ScriptPathsEditor();
    }

    protected class ScriptPathsEditor
    extends JPanel {
        public ScriptPathsEditor() {
            super(new BorderLayout());
            JButton button = new JButton("Edit Paths");
            button.addActionListener(this::showDialog);
            this.add(button);
        }

        protected void showDialog(ActionEvent evt) {
            DockingWindowManager.showDialog((Component)this, (DialogComponentProvider)new ScriptPathsDialog());
        }
    }

    protected class ScriptPathsPanel
    extends PathnameTablePanel {
        public ScriptPathsPanel(Callback resetCallback) {
            super(null, resetCallback, false, false, false);
        }

        protected int promptConfirmReset() {
            String confirmation = "<html><body width=\"200px\">\n  Are you sure you would like to reload the Debugger's launcher script paths?\n  This will reset any changes you've made so far.\n</html>";
            String header = "Reset Script Paths?";
            return OptionDialog.showYesNoDialog((Component)((Object)this), (String)header, (String)confirmation);
        }
    }

    protected class ScriptPathsDialog
    extends AbstractPathsDialog {
        protected ScriptPathsDialog() {
            super("Debugger Launch Script Paths");
        }

        protected String[] loadPaths() {
            return (String[])((String)ScriptPathsPropertyEditor.this.getValue()).lines().filter(d -> !d.isBlank()).toArray(String[]::new);
        }

        protected void savePaths(String[] paths) {
            ScriptPathsPropertyEditor.this.setValue(Stream.of(paths).collect(Collectors.joining("\n")));
        }

        protected PathnameTablePanel newPathnameTablePanel() {
            ScriptPathsPanel tablePanel = new ScriptPathsPanel(() -> this.reset());
            tablePanel.setFileChooserProperties(this.getTitle(), "DebuggerLaunchScriptDirectory", GhidraFileChooserMode.DIRECTORIES_ONLY, true, null);
            return tablePanel;
        }
    }
}

