/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractScriptTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class UnixShellScriptTraceRmiLaunchOffer
extends AbstractScriptTraceRmiLaunchOffer {
    public static final String SHEBANG = "#!";

    public static UnixShellScriptTraceRmiLaunchOffer create(TraceRmiLauncherServicePlugin plugin, Program program, File script) throws FileNotFoundException {
        ScriptAttributesParser parser = new ScriptAttributesParser(){

            @Override
            protected boolean ignoreLine(int lineNo, String line) {
                return line.isBlank() || line.startsWith(UnixShellScriptTraceRmiLaunchOffer.SHEBANG) && lineNo == 1;
            }

            @Override
            protected String removeDelimiter(String line) {
                String stripped = line.stripLeading();
                if (!stripped.startsWith("#")) {
                    return null;
                }
                return stripped.substring(1);
            }
        };
        ScriptAttributesParser.ScriptAttributes attrs = parser.parseFile(script);
        return new UnixShellScriptTraceRmiLaunchOffer(plugin, program, script, "UNIX_SHELL:" + script.getName(), attrs);
    }

    private UnixShellScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program, script, configName, attrs);
    }

    @Override
    protected void prepareSubprocess(List<String> commandLine, Map<String, String> env, Map<String, ?> args, SocketAddress address) {
        ScriptAttributesParser.processArguments(commandLine, env, this.script, this.attrs.parameters(), args, address);
    }
}

