/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.app.plugin.core.debug.service.tracermi.AbstractTraceRmiListener;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiHandler;
import ghidra.app.plugin.core.debug.service.tracermi.TraceRmiPlugin;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiServiceListener;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.net.SocketAddress;

public class DefaultTraceRmiAcceptor
extends AbstractTraceRmiListener
implements TraceRmiAcceptor {
    private boolean cancelled = false;

    public DefaultTraceRmiAcceptor(TraceRmiPlugin plugin, SocketAddress address) {
        super(plugin, address);
    }

    @Override
    protected void startServiceLoop() {
    }

    @Override
    protected void bind() throws IOException {
        this.socket.bind(this.address, 1);
        this.plugin.addAcceptor(this);
    }

    @Override
    protected TraceRmiServiceListener.ConnectMode getConnectMode() {
        return TraceRmiServiceListener.ConnectMode.ACCEPT_ONE;
    }

    public TraceRmiHandler accept() throws IOException, CancelledException {
        try {
            TraceRmiHandler handler = this.doAccept(this);
            this.close();
            return handler;
        }
        catch (Exception e) {
            this.close();
            if (this.cancelled) {
                throw new CancelledException();
            }
            ((TraceRmiServiceListener)this.plugin.listeners.invoke()).acceptFailed((TraceRmiAcceptor)this, e);
            throw e;
        }
    }

    @Override
    public void close() {
        this.plugin.removeAcceptor(this);
        super.close();
    }

    public void cancel() {
        this.cancelled = true;
        this.close();
        ((TraceRmiServiceListener)this.plugin.listeners.invoke()).acceptCancelled((TraceRmiAcceptor)this);
    }
}

