/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import docking.ActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.plugin.core.debug.gui.tracermi.RemoteMethodInvocationDialog;
import ghidra.app.plugin.core.debug.service.target.AbstractTarget;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetFocusScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegister;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.debug.api.tracermi.RemoteMethod;
import ghidra.debug.api.tracermi.RemoteMethodRegistry;
import ghidra.debug.api.tracermi.RemoteParameter;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TraceRmiTarget
extends AbstractTarget {
    private static final String BREAK_HW_EXEC = "breakHwExec";
    private static final String BREAK_SW_EXEC = "breakSwExec";
    private static final String BREAK_READ = "breakRead";
    private static final String BREAK_WRITE = "breakWrite";
    private static final String BREAK_ACCESS = "breakAccess";
    private final TraceRmiConnection connection;
    private final Trace trace;
    private final Matches matches = new Matches();
    private final RequestCaches requestCaches = new RequestCaches();
    private final Set<TraceBreakpointKind> supportedBreakpointKinds;
    protected static final int BLOCK_BITS = 12;
    protected static final int BLOCK_SIZE = 4096;
    protected static final long BLOCK_MASK = -4096L;

    public TraceRmiTarget(PluginTool tool, TraceRmiConnection connection, Trace trace) {
        super(tool);
        this.connection = connection;
        this.trace = trace;
        this.supportedBreakpointKinds = this.computeSupportedBreakpointKinds();
    }

    public boolean isValid() {
        return !this.connection.isClosed() && this.connection.isTarget(this.trace);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public long getSnap() {
        try {
            return this.connection.getLastSnapshot(this.trace);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    public TargetExecutionStateful.TargetExecutionState getThreadExecutionState(TraceThread thread) {
        if (!(thread instanceof TraceObjectThread)) {
            Msg.error((Object)((Object)this), (Object)"Non-object thread with Trace RMI!");
            return TargetExecutionStateful.TargetExecutionState.ALIVE;
        }
        TraceObjectThread tot = (TraceObjectThread)thread;
        return tot.getObject().getExecutionState(this.getSnap());
    }

    public TraceThread getThreadForSuccessor(TraceObjectKeyPath path) {
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        return object.queryCanonicalAncestorsInterface(TraceObjectThread.class).findFirst().orElse(null);
    }

    public TraceStackFrame getStackFrameForSuccessor(TraceObjectKeyPath path) {
        TraceObject object = this.trace.getObjectManager().getObjectByCanonicalPath(path);
        if (object == null) {
            return null;
        }
        return object.queryCanonicalAncestorsInterface(TraceObjectStackFrame.class).findFirst().orElse(null);
    }

    protected TraceObject findObject(ActionContext context, boolean allowContextObject, boolean allowCoordsObject) {
        TraceObjectValue ov;
        DebuggerObjectActionContext ctx;
        List values;
        if (allowContextObject && context instanceof DebuggerObjectActionContext && (values = (ctx = (DebuggerObjectActionContext)context).getObjectValues()).size() == 1 && (ov = (TraceObjectValue)values.get(0)).isObject()) {
            return ov.getChild();
        }
        if (allowCoordsObject) {
            DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
            if (traceManager == null) {
                return null;
            }
            return traceManager.getCurrentFor(this.trace).getObject();
        }
        return null;
    }

    protected Object findArgumentForSchema(ActionContext context, TargetObjectSchema schema, boolean allowContextObject, boolean allowCoordsObject, boolean allowSuitableObject) {
        if (schema instanceof EnumerableTargetObjectSchema) {
            EnumerableTargetObjectSchema prim = (EnumerableTargetObjectSchema)schema;
            return switch (prim) {
                case EnumerableTargetObjectSchema.OBJECT -> this.findObject(context, allowContextObject, allowCoordsObject);
                case EnumerableTargetObjectSchema.ADDRESS -> this.findAddress(context);
                case EnumerableTargetObjectSchema.RANGE -> this.findRange(context);
                default -> null;
            };
        }
        TraceObject object = this.findObject(context, allowContextObject, allowCoordsObject);
        if (object == null) {
            return null;
        }
        if (allowSuitableObject) {
            return object.querySuitableSchema(schema);
        }
        if (object.getTargetSchema() == schema) {
            return object;
        }
        return null;
    }

    protected Object findArgument(RemoteParameter parameter, ActionContext context, boolean allowContextObject, boolean allowCoordsObject, boolean allowSuitableObject) {
        TargetObjectSchema.SchemaName type = parameter.type();
        SchemaContext ctx = this.getSchemaContext();
        if (ctx == null) {
            Msg.trace((Object)((Object)this), (Object)("No root schema, yet: " + this.trace));
            return null;
        }
        TargetObjectSchema schema = ctx.getSchema(type);
        if (schema == null) {
            Msg.error((Object)((Object)this), (Object)("Schema " + type + " not in trace! " + this.trace));
            return null;
        }
        Object arg = this.findArgumentForSchema(context, schema, allowContextObject, allowCoordsObject, allowSuitableObject);
        if (arg != null) {
            return arg;
        }
        if (!parameter.required()) {
            return parameter.getDefaultValue();
        }
        return Missing.MISSING;
    }

    protected Map<String, Object> collectArguments(RemoteMethod method, ActionContext context, boolean allowContextObject, boolean allowCoordsObject, boolean allowSuitableObject) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (RemoteParameter param : method.parameters().values()) {
            Object found = this.findArgument(param, context, allowContextObject, allowCoordsObject, allowSuitableObject);
            if (found == null) continue;
            args.put(param.name(), found);
        }
        return args;
    }

    private TargetExecutionStateful.TargetExecutionState getStateOf(TraceObject object) {
        try {
            return object.getExecutionState(this.getSnap());
        }
        catch (NoSuchElementException e) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
    }

    private boolean whenState(TraceObject object, Predicate<TargetExecutionStateful.TargetExecutionState> predicate) {
        try {
            TargetExecutionStateful.TargetExecutionState state = this.getStateOf(object);
            return state == null || predicate.test(state);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Could not get state: " + e));
            return false;
        }
    }

    protected BooleanSupplier chooseEnabler(RemoteMethod method, Map<String, Object> args) {
        ActionName name = method.action();
        SchemaContext ctx = this.getSchemaContext();
        if (ctx == null) {
            return () -> true;
        }
        RemoteParameter firstParam = method.parameters().values().stream().filter(p -> TargetObject.class.isAssignableFrom(ctx.getSchema(p.type()).getType())).findFirst().orElse(null);
        if (firstParam == null) {
            return () -> true;
        }
        Object firstArg = args.get(firstParam.name());
        if (firstArg == null || firstArg == Missing.MISSING) {
            Msg.trace((Object)((Object)this), (Object)("MISSING first argument for " + method + "(" + firstParam + ")"));
            return () -> false;
        }
        TraceObject obj = (TraceObject)firstArg;
        if (ActionName.RESUME.equals((Object)name) || ActionName.STEP_BACK.equals((Object)name) || ActionName.STEP_EXT.equals((Object)name) || ActionName.STEP_INTO.equals((Object)name) || ActionName.STEP_OUT.equals((Object)name) || ActionName.STEP_OVER.equals((Object)name) || ActionName.STEP_SKIP.equals((Object)name)) {
            return () -> this.whenState(obj, state -> state != null && state.isStopped());
        }
        if (ActionName.INTERRUPT.equals((Object)name)) {
            return () -> this.whenState(obj, state -> state == null || state.isRunning());
        }
        if (ActionName.KILL.equals((Object)name)) {
            return () -> this.whenState(obj, state -> state == null || state.isAlive());
        }
        return () -> true;
    }

    private Map<String, Object> promptArgs(RemoteMethod method, Map<String, Object> defaults) {
        SchemaContext ctx = this.getSchemaContext();
        RemoteMethodInvocationDialog dialog = new RemoteMethodInvocationDialog(this.tool, method.name(), method.name(), null);
        for (RemoteParameter param : method.parameters().values()) {
            Object val = defaults.get(param.name());
            if (val == null) continue;
            Class type = ctx.getSchema(param.type()).getType();
            dialog.setMemorizedArgument(param.name(), type.asSubclass(Object.class), val);
        }
        Map<String, Object> args = dialog.promptArguments(ctx, method.parameters(), defaults);
        if (args == null) {
            return null;
        }
        return args;
    }

    private CompletableFuture<?> invokeMethod(boolean prompt, RemoteMethod method, Map<String, Object> arguments) {
        Map<String, Object> chosenArgs = prompt ? this.promptArgs(method, arguments) : arguments;
        return method.invokeAsync(chosenArgs).thenAccept(result -> {
            DebuggerConsoleService consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
            Class retType = this.getSchemaContext().getSchema(method.retType()).getType();
            if (consoleService != null && retType != Void.class && retType != Object.class) {
                consoleService.log(null, method.name() + " returned " + result);
            }
        }).toCompletableFuture();
    }

    protected Target.ActionEntry createEntry(RemoteMethod method, ActionContext context, boolean allowContextObject, boolean allowCoordsObject, boolean allowSuitableObject) {
        Map<String, Object> args = this.collectArguments(method, context, allowContextObject, allowCoordsObject, allowSuitableObject);
        boolean requiresPrompt = args.values().contains((Object)Missing.MISSING);
        return new Target.ActionEntry(method.name(), method.action(), method.description(), requiresPrompt, this.chooseEnabler(method, args), prompt -> this.invokeMethod((boolean)prompt, method, args));
    }

    protected Map<String, Target.ActionEntry> collectFromMethods(Collection<RemoteMethod> methods, ActionContext context, boolean allowContextObject, boolean allowCoordsObject, boolean allowSuitableObject) {
        HashMap<String, Target.ActionEntry> result = new HashMap<String, Target.ActionEntry>();
        for (RemoteMethod m : methods) {
            result.put(m.name(), this.createEntry(m, context, allowContextObject, allowCoordsObject, allowSuitableObject));
        }
        return result;
    }

    protected boolean isAddressMethod(RemoteMethod method, SchemaContext ctx) {
        return method.parameters().values().stream().filter(p -> {
            TargetObjectSchema schema = ctx.getSchemaOrNull(p.type());
            if (schema == null) {
                Msg.error((Object)((Object)this), (Object)("Method " + method + " refers to invalid schema name: " + p.type()));
                return false;
            }
            return schema.getType() == Address.class;
        }).count() == 1L;
    }

    protected Map<String, Target.ActionEntry> collectAddressActions(ProgramLocationActionContext context) {
        SchemaContext ctx = this.getSchemaContext();
        HashMap<String, Target.ActionEntry> result = new HashMap<String, Target.ActionEntry>();
        for (RemoteMethod m : this.connection.getMethods().all().values()) {
            if (!this.isAddressMethod(m, ctx)) continue;
            result.put(m.name(), this.createEntry(m, (ActionContext)context, true, true, true));
        }
        return result;
    }

    protected Map<String, Target.ActionEntry> collectAllActions(ActionContext context) {
        return this.collectFromMethods(this.connection.getMethods().all().values(), context, true, false, false);
    }

    protected Map<String, Target.ActionEntry> collectByName(ActionName name, ActionContext context) {
        return this.collectFromMethods(this.connection.getMethods().getByAction(name), context, false, true, true);
    }

    protected Map<String, Target.ActionEntry> collectResumeActions(ActionContext context) {
        return this.collectByName(ActionName.RESUME, context);
    }

    protected Map<String, Target.ActionEntry> collectInterruptActions(ActionContext context) {
        return this.collectByName(ActionName.INTERRUPT, context);
    }

    protected Map<String, Target.ActionEntry> collectKillActions(ActionContext context) {
        return this.collectByName(ActionName.KILL, context);
    }

    protected Map<String, Target.ActionEntry> collectStepIntoActions(ActionContext context) {
        return this.collectByName(ActionName.STEP_INTO, context);
    }

    protected Map<String, Target.ActionEntry> collectStepOverActions(ActionContext context) {
        return this.collectByName(ActionName.STEP_OVER, context);
    }

    protected Map<String, Target.ActionEntry> collectStepOutActions(ActionContext context) {
        return this.collectByName(ActionName.STEP_OUT, context);
    }

    protected Map<String, Target.ActionEntry> collectStepExtActions(ActionContext context) {
        return this.collectByName(ActionName.STEP_EXT, context);
    }

    public boolean isSupportsFocus() {
        TargetObjectSchema schema = this.trace.getObjectManager().getRootSchema();
        if (schema == null) {
            Msg.trace((Object)((Object)this), (Object)"Checked for focus support before root schema is available");
            return false;
        }
        return schema.getInterfaces().contains(TargetFocusScope.class) && !this.connection.getMethods().getByAction(ActionName.ACTIVATE).isEmpty();
    }

    public TraceObjectKeyPath getFocus() {
        TraceObjectValue focusVal = this.trace.getObjectManager().getRootObject().getAttribute(this.getSnap(), "_focus");
        if (focusVal == null || !focusVal.isObject()) {
            return null;
        }
        return focusVal.getChild().getCanonicalPath();
    }

    protected static boolean typeMatches(RemoteMethod method, RemoteParameter param, SchemaContext ctx, Class<?> type) {
        TargetObjectSchema sch = ctx.getSchemaOrNull(param.type());
        if (sch == null) {
            throw new RuntimeException("The parameter '%s' of method '%s' refers to a non-existent schema '%s'".formatted(param.name(), method.name(), param.type()));
        }
        if (type == TargetObject.class) {
            return sch == EnumerableTargetObjectSchema.OBJECT;
        }
        if (TargetObject.class.isAssignableFrom(type)) {
            return sch.getInterfaces().contains(type);
        }
        return sch.getType() == type;
    }

    protected static <T extends MethodMatcher> List<T> matchers(List<T> list) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.sort(Comparator.comparing(MethodMatcher::score).reversed());
        if (result.isEmpty()) {
            throw new AssertionError((Object)"empty matchers list?");
        }
        int prevScore = ((MethodMatcher)result.get(0)).score();
        for (int i = 1; i < result.size(); ++i) {
            int curScore = ((MethodMatcher)result.get(i)).score();
            if (prevScore <= curScore) {
                throw new AssertionError((Object)("duplicate scores: " + curScore));
            }
        }
        return List.copyOf(result);
    }

    @SafeVarargs
    protected static <T extends MethodMatcher> List<T> matchers(T ... list) {
        return TraceRmiTarget.matchers(Arrays.asList(list));
    }

    public CompletableFuture<Void> activateAsync(DebuggerCoordinates prev, DebuggerCoordinates coords) {
        RemoteParameter paramSnap;
        TraceObject object;
        if (prev.getSnap() != coords.getSnap()) {
            this.requestCaches.invalidate();
        }
        if ((object = coords.getObject()) == null) {
            return AsyncUtils.nil();
        }
        TargetObjectSchema.SchemaName name = object.getTargetSchema().getName();
        MatchedMethod activate = this.matches.getBest("activate_" + name, ActionName.ACTIVATE, () -> ActivateMatcher.makeBySpecificity(this.trace.getObjectManager().getRootSchema(), object.getCanonicalPath()));
        if (activate == null) {
            return AsyncUtils.nil();
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        RemoteParameter paramFocus = activate.params.get("focus");
        args.put(paramFocus.name(), object.querySuitableSchema(this.getSchemaContext().getSchema(paramFocus.type())));
        RemoteParameter paramTime = activate.params.get("time");
        if (paramTime != null) {
            args.put(paramTime.name(), coords.getTime().toString());
        }
        if ((paramSnap = activate.params.get("snap")) != null) {
            args.put(paramSnap.name(), coords.getSnap());
        }
        return activate.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    public CompletableFuture<Void> invalidateMemoryCachesAsync() {
        return AsyncUtils.nil();
    }

    protected static AddressSetView quantize(AddressSetView set) {
        AddressSet result = new AddressSet();
        for (AddressRange range : set) {
            AddressSpace space = range.getAddressSpace();
            Address min = space.getAddress(range.getMinAddress().getOffset() & 0xFFFFFFFFFFFFF000L);
            Address max = space.getAddress(range.getMaxAddress().getOffset() | 0xFFFL);
            result.add((AddressRange)new AddressRangeImpl(min, max));
        }
        return result;
    }

    protected SchemaContext getSchemaContext() {
        TargetObjectSchema rootSchema = this.trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return null;
        }
        return rootSchema.getContext();
    }

    protected TraceObject getProcessForSpace(AddressSpace space) {
        for (TraceObjectValue objVal : this.trace.getObjectManager().getValuesIntersecting(Lifespan.at((long)this.getSnap()), (AddressRange)new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress()), "_range")) {
            TraceObject obj = objVal.getParent();
            if (!obj.getInterfaces().contains(TraceObjectMemoryRegion.class)) continue;
            return obj.queryCanonicalAncestorsTargetInterface(TargetProcess.class).findFirst().orElse(null);
        }
        return null;
    }

    public CompletableFuture<Void> readMemoryAsync(AddressSetView set, TaskMonitor monitor) {
        MatchedMethod readMem = this.matches.getBest("readMem", ActionName.READ_MEM, ReadMemMatcher.ALL);
        if (readMem == null) {
            return AsyncUtils.nil();
        }
        RemoteParameter paramRange = readMem.params.get("range");
        RemoteParameter paramProcess = readMem.params.get("process");
        HashMap procsBySpace = paramProcess != null ? new HashMap() : null;
        int total = 0;
        AddressSetView quantized = TraceRmiTarget.quantize(set);
        for (AddressRange r2 : quantized) {
            total = (int)((long)total + Long.divideUnsigned(r2.getLength() + 4096L - 1L, 4096L));
        }
        monitor.initialize((long)total);
        monitor.setMessage("Reading memory");
        return AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)quantized.iterator(), (r, loop) -> {
            AddressRangeChunker blocks = new AddressRangeChunker(r, 4096);
            if (r.getAddressSpace().isRegisterSpace()) {
                Msg.warn((Object)((Object)this), (Object)("Request to read registers via readMemory: " + r + ". Ignoring."));
                loop.repeatWhile(!monitor.isCancelled());
                return;
            }
            ((CompletableFuture)AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)blocks.iterator(), (blk, inner) -> {
                Map<String, Object> args;
                monitor.incrementProgress(1L);
                if (paramProcess != null) {
                    TraceObject process = procsBySpace.computeIfAbsent(blk.getAddressSpace(), this::getProcessForSpace);
                    if (process == null) {
                        Msg.warn((Object)((Object)this), (Object)("Cannot find process containing " + blk.getMinAddress()));
                        inner.repeatWhile(!monitor.isCancelled());
                        return;
                    }
                    args = Map.ofEntries(Map.entry(paramProcess.name(), process), Map.entry(paramRange.name(), blk));
                } else {
                    args = Map.ofEntries(Map.entry(paramRange.name(), blk));
                }
                CompletableFuture<Void> future = this.requestCaches.readBlock(blk.getMinAddress(), readMem.method, args);
                ((CompletableFuture)((CompletableFuture)future.exceptionally(e -> {
                    Msg.error((Object)((Object)this), (Object)("Could not read " + blk + ": " + e));
                    return null;
                })).thenApply(__ -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)inner).repeatWhile(arg_0, arg_1));
            }).thenApply(v -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)loop).repeatWhile(arg_0, arg_1));
        });
    }

    public CompletableFuture<Void> writeMemoryAsync(Address address, byte[] data) {
        MatchedMethod writeMem = this.matches.getBest("writeMem", ActionName.WRITE_MEM, WriteMemMatcher.ALL);
        if (writeMem == null) {
            return AsyncUtils.nil();
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(writeMem.params.get("start").name(), address);
        args.put(writeMem.params.get("data").name(), data);
        RemoteParameter paramProcess = writeMem.params.get("process");
        if (paramProcess != null) {
            TraceObject process = this.getProcessForSpace(address.getAddressSpace());
            if (process == null) {
                throw new IllegalStateException("Cannot find process containing " + address);
            }
            args.put(paramProcess.name(), process);
        }
        return writeMem.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    public CompletableFuture<Void> readRegistersAsync(TracePlatform platform, TraceThread thread, int frame, Set<Register> registers) {
        MatchedMethod readRegs = this.matches.getBest("readRegs", ActionName.REFRESH, ReadRegsMatcher.ALL);
        if (readRegs == null) {
            return AsyncUtils.nil();
        }
        if (!(thread instanceof TraceObjectThread)) {
            Msg.error((Object)((Object)this), (Object)"Non-object trace with TraceRmi!");
            return AsyncUtils.nil();
        }
        TraceObjectThread tot = (TraceObjectThread)thread;
        TraceObject container = tot.getObject().queryRegisterContainer(frame);
        if (container == null) {
            Msg.error((Object)((Object)this), (Object)("Cannot find register container for thread,frame: " + thread + "," + frame));
            return AsyncUtils.nil();
        }
        RemoteParameter paramContainer = readRegs.params.get("container");
        if (paramContainer != null) {
            return this.requestCaches.readRegs(container, readRegs.method, Map.of(paramContainer.name(), container));
        }
        HashSet<Object> keys = new HashSet<Object>();
        for (Register r2 : registers) {
            String lower = r2.getName().toLowerCase();
            keys.add(lower);
            keys.add("[" + lower + "]");
        }
        Set regs = container.querySuccessorsTargetInterface(Lifespan.at((long)this.getSnap()), TargetRegister.class, true).filter(p -> keys.contains(p.getLastEntry().getEntryKey().toLowerCase())).map(r -> r.getDestination(null)).collect(Collectors.toSet());
        RemoteParameter paramBank = readRegs.params.get("bank");
        if (paramBank != null) {
            Set banks = regs.stream().flatMap(r -> r.queryCanonicalAncestorsTargetInterface(TargetRegisterBank.class).findFirst().stream()).collect(Collectors.toSet());
            AsyncFence fence = new AsyncFence();
            banks.stream().forEach(b -> fence.include(this.requestCaches.readRegs((TraceObject)b, readRegs.method, (Map<String, Object>)Map.of(paramBank.name(), b))));
            return fence.ready();
        }
        RemoteParameter paramRegister = readRegs.params.get("register");
        if (paramRegister != null) {
            AsyncFence fence = new AsyncFence();
            regs.stream().forEach(r -> fence.include(this.requestCaches.readRegs((TraceObject)r, readRegs.method, (Map<String, Object>)Map.of(paramRegister.name(), r))));
            return fence.ready();
        }
        throw new AssertionError();
    }

    protected TraceObject findRegisterObject(TraceObjectThread thread, int frame, String name) {
        TraceObject container = thread.getObject().queryRegisterContainer(frame);
        if (container == null) {
            Msg.error((Object)((Object)this), (Object)("No register container for thread=" + thread + ",frame=" + frame));
            return null;
        }
        PathMatcher matcher = container.getTargetSchema().searchFor(TargetRegister.class, true);
        PathPredicates pred = matcher.applyKeys(PathPredicates.Align.RIGHT, new String[]{name}).or(matcher.applyKeys(PathPredicates.Align.RIGHT, new String[]{name.toLowerCase()})).or(matcher.applyKeys(PathPredicates.Align.RIGHT, new String[]{name.toUpperCase()}));
        TraceObjectValPath regValPath = container.getCanonicalSuccessors(pred).findFirst().orElse(null);
        if (regValPath == null) {
            Msg.error((Object)((Object)this), (Object)("Cannot find register object for " + name + " in " + container));
            return null;
        }
        return regValPath.getDestination(container);
    }

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform platform, TraceThread thread, int frameLevel, RegisterValue value) {
        MatchedMethod writeReg = this.matches.getBest("writeReg", ActionName.WRITE_REG, WriteRegMatcher.ALL);
        if (writeReg == null) {
            return AsyncUtils.nil();
        }
        if (!(thread instanceof TraceObjectThread)) {
            Msg.error((Object)((Object)this), (Object)"Non-object trace with TraceRmi!");
            return AsyncUtils.nil();
        }
        TraceObjectThread tot = (TraceObjectThread)thread;
        Register register = value.getRegister();
        String regName = register.getName();
        byte[] data = Utils.bigIntegerToBytes((BigInteger)value.getUnsignedValue(), (int)register.getMinimumByteSize(), (boolean)true);
        RemoteParameter paramThread = writeReg.params.get("thread");
        if (paramThread != null) {
            return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(paramThread.name(), tot.getObject()), Map.entry(writeReg.params.get("name").name(), regName), Map.entry(writeReg.params.get("value").name(), data))).toCompletableFuture().thenApply(__ -> null);
        }
        RemoteParameter paramFrame = writeReg.params.get("frame");
        if (paramFrame != null) {
            TraceStack stack = this.trace.getStackManager().getLatestStack(thread, this.getSnap());
            TraceStackFrame frame = stack.getFrame(frameLevel, false);
            if (!(frame instanceof TraceObjectStackFrame)) {
                Msg.error((Object)((Object)this), (Object)"Non-object trace with TraceRmi!");
                return AsyncUtils.nil();
            }
            TraceObjectStackFrame tof = (TraceObjectStackFrame)frame;
            return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(paramFrame.name(), tof.getObject()), Map.entry(writeReg.params.get("name").name(), regName), Map.entry(writeReg.params.get("value").name(), data))).toCompletableFuture().thenApply(__ -> null);
        }
        TraceObject regObj = this.findRegisterObject(tot, frameLevel, regName);
        if (regObj == null) {
            return AsyncUtils.nil();
        }
        return writeReg.method.invokeAsync(Map.ofEntries(Map.entry(writeReg.params.get("frame").name(), regObj), Map.entry(writeReg.params.get("value").name(), data))).toCompletableFuture().thenApply(__ -> null);
    }

    protected boolean isMemorySpaceValid(AddressSpace space) {
        return this.trace.getBaseAddressFactory().getAddressSpace(space.getSpaceID()) == space;
    }

    protected boolean isRegisterValid(TracePlatform platform, TraceThread thread, int frame, Address address, int length) {
        if (!this.isMemorySpaceValid(address.getAddressSpace())) {
            return false;
        }
        Register register = platform.getLanguage().getRegister(address.getPhysicalAddress(), length);
        if (register == null) {
            return false;
        }
        if (!(thread instanceof TraceObjectThread)) {
            return false;
        }
        TraceObjectThread tot = (TraceObjectThread)thread;
        TraceObject regObj = this.findRegisterObject(tot, frame, register.getName());
        return regObj != null;
    }

    public boolean isVariableExists(TracePlatform platform, TraceThread thread, int frame, Address address, int length) {
        if (address.isMemoryAddress()) {
            return this.isMemorySpaceValid(address.getAddressSpace());
        }
        if (address.isRegisterAddress()) {
            return this.isRegisterValid(platform, thread, frame, address, length);
        }
        return false;
    }

    public CompletableFuture<Void> writeVariableAsync(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        if (address.isMemoryAddress()) {
            return this.writeMemoryAsync(address, data);
        }
        if (address.isRegisterAddress()) {
            return this.writeRegisterAsync(platform, thread, frame, address, data);
        }
        Msg.error((Object)((Object)this), (Object)("Address is neither memory nor register: " + address));
        return AsyncUtils.nil();
    }

    protected Address expectSingleAddr(AddressRange range, TraceBreakpointKind kind) {
        Address address = range.getMinAddress();
        if (range.getLength() != 1L) {
            Msg.warn((Object)((Object)this), (Object)("Expected single address for " + kind + " breakpoint. Got " + range + ". Using " + address));
        }
        return address;
    }

    protected void putOptionalBreakArgs(Map<String, Object> args, MatchedMethod brk, String condition, String commands) {
        RemoteParameter paramProc = brk.params.get("process");
        if (paramProc != null) {
            Object proc = this.findArgumentForSchema(null, this.getSchemaContext().getSchema(paramProc.type()), true, true, true);
            if (proc == null) {
                Msg.error((Object)((Object)this), (Object)("Cannot find required process argument for " + brk.method));
            } else {
                args.put(paramProc.name(), proc);
            }
        }
        if (condition != null && !condition.isBlank()) {
            RemoteParameter paramCond = brk.params.get("condition");
            if (paramCond == null) {
                Msg.error((Object)((Object)this), (Object)("No condition parameter  on " + brk.method));
            } else {
                args.put(paramCond.name(), condition);
            }
        }
        if (commands != null && !commands.isBlank()) {
            RemoteParameter paramCmds = brk.params.get("commands");
            if (paramCmds == null) {
                Msg.error((Object)((Object)this), (Object)("No commands parameter on " + brk.method));
            } else {
                args.put(paramCmds.name(), commands);
            }
        }
    }

    protected CompletableFuture<Void> doPlaceExecBreakAsync(MatchedMethod breakExec, Address address, String condition, String commands) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(breakExec.params.get("address").name(), address);
        this.putOptionalBreakArgs(args, breakExec, condition, commands);
        return breakExec.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> placeHwExecBreakAsync(Address address, String condition, String commands) {
        MatchedMethod breakHwExec = this.matches.getBest(BREAK_HW_EXEC, ActionName.BREAK_HW_EXECUTE, BreakExecMatcher.ALL);
        if (breakHwExec == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceExecBreakAsync(breakHwExec, address, condition, commands);
    }

    protected CompletableFuture<Void> placeSwExecBreakAsync(Address address, String condition, String commands) {
        MatchedMethod breakSwExec = this.matches.getBest(BREAK_SW_EXEC, ActionName.BREAK_SW_EXECUTE, BreakExecMatcher.ALL);
        if (breakSwExec == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceExecBreakAsync(breakSwExec, address, condition, commands);
    }

    protected CompletableFuture<Void> doPlaceAccBreakAsync(MatchedMethod breakAcc, AddressRange range, String condition, String commands) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(breakAcc.params.get("range").name(), range);
        this.putOptionalBreakArgs(args, breakAcc, condition, commands);
        return breakAcc.method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> placeReadBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakRead = this.matches.getBest(BREAK_READ, ActionName.BREAK_READ, BreakAccMatcher.ALL);
        if (breakRead == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakRead, range, condition, commands);
    }

    protected CompletableFuture<Void> placeWriteBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakWrite = this.matches.getBest(BREAK_WRITE, ActionName.BREAK_WRITE, BreakAccMatcher.ALL);
        if (breakWrite == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakWrite, range, condition, commands);
    }

    protected CompletableFuture<Void> placeAccessBreakAsync(AddressRange range, String condition, String commands) {
        MatchedMethod breakAccess = this.matches.getBest(BREAK_ACCESS, ActionName.BREAK_ACCESS, BreakAccMatcher.ALL);
        if (breakAccess == null) {
            return AsyncUtils.nil();
        }
        return this.doPlaceAccBreakAsync(breakAccess, range, condition, commands);
    }

    public CompletableFuture<Void> placeBreakpointAsync(AddressRange range, Set<TraceBreakpointKind> kinds, String condition, String commands) {
        Set<TraceBreakpointKind> copyKinds = Set.copyOf(kinds);
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.HW_EXECUTE)) {
            return this.placeHwExecBreakAsync(this.expectSingleAddr(range, TraceBreakpointKind.HW_EXECUTE), condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.SW_EXECUTE)) {
            return this.placeSwExecBreakAsync(this.expectSingleAddr(range, TraceBreakpointKind.SW_EXECUTE), condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.READ)) {
            return this.placeReadBreakAsync(range, condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.WRITE)) {
            return this.placeWriteBreakAsync(range, condition, commands);
        }
        if (copyKinds.equals(TraceBreakpointKind.TraceBreakpointKindSet.ACCESS)) {
            return this.placeAccessBreakAsync(range, condition, commands);
        }
        Msg.error((Object)((Object)this), (Object)("Invalid kinds in combination: " + kinds));
        return AsyncUtils.nil();
    }

    protected Set<TraceBreakpointKind> computeSupportedBreakpointKinds() {
        HashSet<TraceBreakpointKind> result = new HashSet<TraceBreakpointKind>();
        RemoteMethodRegistry methods = this.connection.getMethods();
        if (!methods.getByAction(ActionName.BREAK_HW_EXECUTE).isEmpty()) {
            result.add(TraceBreakpointKind.HW_EXECUTE);
        }
        if (!methods.getByAction(ActionName.BREAK_SW_EXECUTE).isEmpty()) {
            result.add(TraceBreakpointKind.SW_EXECUTE);
        }
        if (!methods.getByAction(ActionName.BREAK_READ).isEmpty()) {
            result.add(TraceBreakpointKind.READ);
        }
        if (!methods.getByAction(ActionName.BREAK_WRITE).isEmpty()) {
            result.add(TraceBreakpointKind.WRITE);
        }
        if (!methods.getByAction(ActionName.BREAK_ACCESS).isEmpty()) {
            result.add(TraceBreakpointKind.READ);
            result.add(TraceBreakpointKind.WRITE);
        }
        return Set.copyOf(result);
    }

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds() {
        return this.supportedBreakpointKinds;
    }

    public boolean isBreakpointValid(TraceBreakpoint breakpoint) {
        if (breakpoint.getName().endsWith("emu-" + breakpoint.getMinAddress())) {
            return false;
        }
        return breakpoint.getLifespan().contains(this.getSnap());
    }

    protected CompletableFuture<Void> deleteBreakpointSpecAsync(TraceObjectBreakpointSpec spec) {
        MatchedMethod delBreak = this.matches.getBest("delBreakSpec", ActionName.DELETE, DelBreakMatcher.SPEC);
        if (delBreak == null) {
            return AsyncUtils.nil();
        }
        return delBreak.method.invokeAsync(Map.of(delBreak.params.get("specification").name(), spec.getObject())).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> deleteBreakpointLocAsync(TraceObjectBreakpointLocation loc) {
        MatchedMethod delBreak = this.matches.getBest("delBreakLoc", ActionName.DELETE, DelBreakMatcher.ALL);
        if (delBreak == null) {
            Msg.debug((Object)((Object)this), (Object)"Falling back to delete spec");
            return this.deleteBreakpointSpecAsync(loc.getSpecification());
        }
        RemoteParameter paramLocation = delBreak.params.get("location");
        if (paramLocation != null) {
            return delBreak.method.invokeAsync(Map.of(paramLocation.name(), loc.getObject())).toCompletableFuture().thenApply(__ -> null);
        }
        return this.deleteBreakpointSpecAsync(loc.getSpecification());
    }

    public CompletableFuture<Void> deleteBreakpointAsync(TraceBreakpoint breakpoint) {
        if (breakpoint instanceof TraceObjectBreakpointLocation) {
            TraceObjectBreakpointLocation loc = (TraceObjectBreakpointLocation)breakpoint;
            return this.deleteBreakpointLocAsync(loc);
        }
        if (breakpoint instanceof TraceObjectBreakpointSpec) {
            TraceObjectBreakpointSpec spec = (TraceObjectBreakpointSpec)breakpoint;
            return this.deleteBreakpointSpecAsync(spec);
        }
        Msg.error((Object)((Object)this), (Object)("Unrecognized TraceBreakpoint: " + breakpoint));
        return AsyncUtils.nil();
    }

    protected CompletableFuture<Void> toggleBreakpointSpecAsync(TraceObjectBreakpointSpec spec, boolean enabled) {
        MatchedMethod delBreak = this.matches.getBest("toggleBreakSpec", ActionName.TOGGLE, ToggleBreakMatcher.SPEC);
        if (delBreak == null) {
            return AsyncUtils.nil();
        }
        return delBreak.method.invokeAsync(Map.ofEntries(Map.entry(delBreak.params.get("specification").name(), spec.getObject()), Map.entry(delBreak.params.get("enabled").name(), enabled))).toCompletableFuture().thenApply(__ -> null);
    }

    protected CompletableFuture<Void> toggleBreakpointLocAsync(TraceObjectBreakpointLocation loc, boolean enabled) {
        MatchedMethod delBreak = this.matches.getBest("toggleBreakLoc", ActionName.TOGGLE, ToggleBreakMatcher.ALL);
        if (delBreak == null) {
            Msg.debug((Object)((Object)this), (Object)"Falling back to toggle spec");
            return this.toggleBreakpointSpecAsync(loc.getSpecification(), enabled);
        }
        RemoteParameter paramLocation = delBreak.params.get("location");
        if (paramLocation != null) {
            return delBreak.method.invokeAsync(Map.ofEntries(Map.entry(paramLocation.name(), loc.getObject()), Map.entry(delBreak.params.get("enabled").name(), enabled))).toCompletableFuture().thenApply(__ -> null);
        }
        return this.toggleBreakpointSpecAsync(loc.getSpecification(), enabled);
    }

    public CompletableFuture<Void> toggleBreakpointAsync(TraceBreakpoint breakpoint, boolean enabled) {
        if (breakpoint instanceof TraceObjectBreakpointLocation) {
            TraceObjectBreakpointLocation loc = (TraceObjectBreakpointLocation)breakpoint;
            return this.toggleBreakpointLocAsync(loc, enabled);
        }
        if (breakpoint instanceof TraceObjectBreakpointSpec) {
            TraceObjectBreakpointSpec spec = (TraceObjectBreakpointSpec)breakpoint;
            return this.toggleBreakpointSpecAsync(spec, enabled);
        }
        Msg.error((Object)((Object)this), (Object)("Unrecognized TraceBreakpoint: " + breakpoint));
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> forceTerminateAsync() {
        Map<String, Target.ActionEntry> kills = this.collectKillActions(null);
        for (Target.ActionEntry kill : kills.values()) {
            if (kill.requiresPrompt()) continue;
            return kill.invokeAsync(false).handle((v, e) -> {
                this.connection.forceCloseTrace(this.trace);
                return null;
            });
        }
        Msg.warn((Object)((Object)this), (Object)"Cannot find way to gracefully kill. Forcing close regardless.");
        this.connection.forceCloseTrace(this.trace);
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> disconnectAsync() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        });
    }

    protected class Matches {
        private final Map<String, MatchedMethod> map = new HashMap<String, MatchedMethod>();

        protected Matches() {
        }

        public MatchedMethod getBest(String name, ActionName action, Supplier<List<? extends MethodMatcher>> preferredSupplier) {
            return this.map.computeIfAbsent(name, n -> this.chooseBest(action, (List)preferredSupplier.get()));
        }

        public MatchedMethod getBest(String name, ActionName action, List<? extends MethodMatcher> preferred) {
            return this.map.computeIfAbsent(name, n -> this.chooseBest(action, preferred));
        }

        private MatchedMethod chooseBest(ActionName name, List<? extends MethodMatcher> preferred) {
            if (preferred.isEmpty()) {
                return null;
            }
            SchemaContext ctx = TraceRmiTarget.this.getSchemaContext();
            MatchedMethod best = TraceRmiTarget.this.connection.getMethods().getByAction(name).stream().map(m -> MethodMatcher.matchPreferredForm(m, ctx, preferred)).filter(f -> f != null).max(MatchedMethod::compareTo).orElse(null);
            if (best == null) {
                Msg.debug((Object)this, (Object)("No suitable " + name + " method"));
            }
            return best;
        }
    }

    protected static class RequestCaches {
        final Map<TraceObject, CompletableFuture<Void>> readRegs = new HashMap<TraceObject, CompletableFuture<Void>>();
        final Map<Address, CompletableFuture<Void>> readBlock = new HashMap<Address, CompletableFuture<Void>>();

        protected RequestCaches() {
        }

        public synchronized void invalidate() {
            this.readRegs.clear();
            this.readBlock.clear();
        }

        public synchronized CompletableFuture<Void> readRegs(TraceObject obj, RemoteMethod method, Map<String, Object> args) {
            return this.readRegs.computeIfAbsent(obj, o -> method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null));
        }

        public synchronized CompletableFuture<Void> readBlock(Address min, RemoteMethod method, Map<String, Object> args) {
            return this.readBlock.computeIfAbsent(min, m -> method.invokeAsync(args).toCompletableFuture().thenApply(__ -> null));
        }
    }

    private static enum Missing {
        MISSING;

    }

    static interface MethodMatcher {
        default public MatchedMethod match(RemoteMethod method, SchemaContext ctx) {
            List<ParamSpec> spec = this.spec();
            if (spec.size() != method.parameters().size()) {
                return null;
            }
            HashMap<String, RemoteParameter> found = new HashMap<String, RemoteParameter>();
            for (ParamSpec ps : spec) {
                RemoteParameter param = ps.find(method, ctx);
                if (param == null) {
                    return null;
                }
                found.put(ps.name(), param);
            }
            return new MatchedMethod(method, Map.copyOf(found), this.score());
        }

        public List<ParamSpec> spec();

        public int score();

        public static MatchedMethod matchPreferredForm(RemoteMethod method, SchemaContext ctx, List<? extends MethodMatcher> preferred) {
            return preferred.stream().map(m -> m.match(method, ctx)).filter(m -> m != null).findFirst().orElse(null);
        }
    }

    record MatchedMethod(RemoteMethod method, Map<String, RemoteParameter> params, int score) implements Comparable<MatchedMethod>
    {
        @Override
        public int compareTo(MatchedMethod that) {
            return Integer.compare(this.score, that.score);
        }
    }

    record ReadMemMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ReadMemMatcher HAS_PROC_RANGE = new ReadMemMatcher(2, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("range", AddressRange.class)));
        static final ReadMemMatcher HAS_RANGE = new ReadMemMatcher(1, List.of(new TypeParamSpec("range", AddressRange.class)));
        static final List<ReadMemMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ReadMemMatcher[]{HAS_PROC_RANGE, HAS_RANGE});
    }

    record WriteMemMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final WriteMemMatcher HAS_PROC_START_DATA = new WriteMemMatcher(2, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("start", Address.class), new TypeParamSpec("data", byte[].class)));
        static final WriteMemMatcher HAS_START_DATA = new WriteMemMatcher(1, List.of(new TypeParamSpec("start", Address.class), new TypeParamSpec("data", byte[].class)));
        static final List<WriteMemMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new WriteMemMatcher[]{HAS_PROC_START_DATA, HAS_START_DATA});
    }

    record ReadRegsMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ReadRegsMatcher HAS_CONTAINER = new ReadRegsMatcher(3, List.of(new TypeParamSpec("container", TargetRegisterContainer.class)));
        static final ReadRegsMatcher HAS_BANK = new ReadRegsMatcher(2, List.of(new TypeParamSpec("bank", TargetRegisterBank.class)));
        static final ReadRegsMatcher HAS_REGISTER = new ReadRegsMatcher(1, List.of(new TypeParamSpec("register", TargetRegister.class)));
        static final List<ReadRegsMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ReadRegsMatcher[]{HAS_CONTAINER, HAS_BANK, HAS_REGISTER});
    }

    record WriteRegMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final WriteRegMatcher HAS_FRAME_NAME_VALUE = new WriteRegMatcher(3, List.of(new TypeParamSpec("frame", TargetStackFrame.class), new TypeParamSpec("name", String.class), new TypeParamSpec("value", byte[].class)));
        static final WriteRegMatcher HAS_THREAD_NAME_VALUE = new WriteRegMatcher(2, List.of(new TypeParamSpec("thread", TargetThread.class), new TypeParamSpec("name", String.class), new TypeParamSpec("value", byte[].class)));
        static final WriteRegMatcher HAS_REG_VALUE = new WriteRegMatcher(1, List.of(new TypeParamSpec("register", TargetRegister.class), new TypeParamSpec("value", byte[].class)));
        static final List<WriteRegMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new WriteRegMatcher[]{HAS_FRAME_NAME_VALUE, HAS_REG_VALUE});
    }

    record BreakExecMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final BreakExecMatcher HAS_PROC_ADDR_COND_CMDS = new BreakExecMatcher(8, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR_COND = new BreakExecMatcher(7, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR_CMDS = new BreakExecMatcher(6, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("address", Address.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_PROC_ADDR = new BreakExecMatcher(5, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("address", Address.class)));
        static final BreakExecMatcher HAS_ADDR_COND_CMDS = new BreakExecMatcher(4, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_ADDR_COND = new BreakExecMatcher(3, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("condition", String.class)));
        static final BreakExecMatcher HAS_ADDR_CMDS = new BreakExecMatcher(2, List.of(new TypeParamSpec("address", Address.class), new NameParamSpec("commands", String.class)));
        static final BreakExecMatcher HAS_ADDR = new BreakExecMatcher(1, List.of(new TypeParamSpec("address", Address.class)));
        static final List<BreakExecMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new BreakExecMatcher[]{HAS_PROC_ADDR_COND_CMDS, HAS_PROC_ADDR_COND, HAS_PROC_ADDR_CMDS, HAS_PROC_ADDR, HAS_ADDR_COND_CMDS, HAS_ADDR_COND, HAS_ADDR_CMDS, HAS_ADDR});
    }

    record BreakAccMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final BreakAccMatcher HAS_PROC_RNG_COND_CMDS = new BreakAccMatcher(8, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG_COND = new BreakAccMatcher(7, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG_CMDS = new BreakAccMatcher(6, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("range", AddressRange.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_PROC_RNG = new BreakAccMatcher(5, List.of(new TypeParamSpec("process", TargetProcess.class), new TypeParamSpec("range", AddressRange.class)));
        static final BreakAccMatcher HAS_RNG_COND_CMDS = new BreakAccMatcher(4, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_RNG_COND = new BreakAccMatcher(3, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("condition", String.class)));
        static final BreakAccMatcher HAS_RNG_CMDS = new BreakAccMatcher(2, List.of(new TypeParamSpec("range", AddressRange.class), new NameParamSpec("commands", String.class)));
        static final BreakAccMatcher HAS_RNG = new BreakAccMatcher(1, List.of(new TypeParamSpec("range", AddressRange.class)));
        static final List<BreakAccMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new BreakAccMatcher[]{HAS_PROC_RNG_COND_CMDS, HAS_PROC_RNG_COND, HAS_PROC_RNG_CMDS, HAS_PROC_RNG, HAS_RNG_COND_CMDS, HAS_RNG_COND, HAS_RNG_CMDS, HAS_RNG});
    }

    record DelBreakMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final DelBreakMatcher HAS_LOC = new DelBreakMatcher(2, List.of(new TypeParamSpec("location", TargetBreakpointLocation.class)));
        static final DelBreakMatcher HAS_SPEC = new DelBreakMatcher(1, List.of(new TypeParamSpec("specification", TargetBreakpointSpec.class)));
        static final List<DelBreakMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new DelBreakMatcher[]{HAS_LOC, HAS_SPEC});
        static final List<DelBreakMatcher> SPEC = TraceRmiTarget.matchers((MethodMatcher[])new DelBreakMatcher[]{HAS_SPEC});
    }

    record ToggleBreakMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static final ToggleBreakMatcher HAS_LOC = new ToggleBreakMatcher(2, List.of(new TypeParamSpec("location", TargetBreakpointLocation.class), new TypeParamSpec("enabled", Boolean.class)));
        static final ToggleBreakMatcher HAS_SPEC = new ToggleBreakMatcher(1, List.of(new TypeParamSpec("specification", TargetBreakpointSpec.class), new TypeParamSpec("enabled", Boolean.class)));
        static final List<ToggleBreakMatcher> ALL = TraceRmiTarget.matchers((MethodMatcher[])new ToggleBreakMatcher[]{HAS_LOC, HAS_SPEC});
        static final List<ToggleBreakMatcher> SPEC = TraceRmiTarget.matchers((MethodMatcher[])new ToggleBreakMatcher[]{HAS_SPEC});
    }

    record ActivateMatcher(int score, List<ParamSpec> spec) implements MethodMatcher
    {
        static List<ActivateMatcher> makeAllFor(int addScore, ParamSpec focusSpec) {
            ActivateMatcher hasFocusTime = new ActivateMatcher(addScore + 3, List.of(focusSpec, new TypeParamSpec("time", String.class)));
            ActivateMatcher hasFocusSnap = new ActivateMatcher(addScore + 2, List.of(focusSpec, new TypeParamSpec("snap", Long.class)));
            ActivateMatcher hasFocus = new ActivateMatcher(addScore + 1, List.of(focusSpec));
            return TraceRmiTarget.matchers((MethodMatcher[])new ActivateMatcher[]{hasFocusTime, hasFocusSnap, hasFocus});
        }

        static List<ActivateMatcher> makeBySpecificity(TargetObjectSchema rootSchema, TraceObjectKeyPath path) {
            ArrayList<ActivateMatcher> result = new ArrayList<ActivateMatcher>();
            List keyList = path.getKeyList();
            result.addAll(ActivateMatcher.makeAllFor((keyList.size() + 1) * 3, new TypeParamSpec("focus", TargetObject.class)));
            List schemas = rootSchema.getSuccessorSchemas(keyList);
            for (int i = keyList.size(); i > 0; --i) {
                result.addAll(ActivateMatcher.makeAllFor(i * 3, new SchemaParamSpec("focus", ((TargetObjectSchema)schemas.get(i)).getName())));
            }
            return TraceRmiTarget.matchers(result);
        }
    }

    record NameParamSpec(String name, Class<?> type) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, SchemaContext ctx) {
            RemoteParameter param = (RemoteParameter)method.parameters().get(this.name);
            if (param != null && TraceRmiTarget.typeMatches(method, param, ctx, this.type)) {
                return param;
            }
            return null;
        }
    }

    record TypeParamSpec(String name, Class<?> type) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, SchemaContext ctx) {
            List<RemoteParameter> withType = method.parameters().values().stream().filter(p -> TraceRmiTarget.typeMatches(method, p, ctx, this.type)).toList();
            if (withType.size() != 1) {
                return null;
            }
            return withType.get(0);
        }
    }

    record SchemaParamSpec(String name, TargetObjectSchema.SchemaName schema) implements ParamSpec
    {
        @Override
        public RemoteParameter find(RemoteMethod method, SchemaContext ctx) {
            List<RemoteParameter> withType = method.parameters().values().stream().filter(p -> this.schema.equals((Object)p.type())).toList();
            if (withType.size() != 1) {
                return null;
            }
            return withType.get(0);
        }
    }

    static interface ParamSpec {
        public String name();

        public RemoteParameter find(RemoteMethod var1, SchemaContext var2);
    }
}

