/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.textfield.HexIntegerFormatter;
import docking.widgets.textfield.IntegerFormatter;
import generic.theme.GColor;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.gui.filters.AncillaryFilter;
import ghidra.feature.vt.gui.filters.BoundedRangeInputVerifier;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterFormattedTextField;
import ghidra.feature.vt.gui.filters.FilterState;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.feature.vt.gui.filters.IntegerFormatterFactory;
import ghidra.feature.vt.gui.filters.StatusLabel;
import ghidra.feature.vt.gui.provider.matchtable.NumberRangeProducer;
import ghidra.feature.vt.gui.provider.matchtable.NumberRangeSubFilterChecker;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.util.ColorUtils;
import ghidra.util.WebColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAddressRangeFilter<T>
extends AncillaryFilter<T>
implements NumberRangeSubFilterChecker,
NumberRangeProducer {
    private static final String DELIMITER = ":";
    private static final String LOWER_RANGE_VALUES_KEY = "lower.range.values.key";
    private static final String UPPER_RANGE_VALUES_KEY = "upper.range.values.key";
    private static final String LOWER_RANGE_SELECTED_VALUE_KEY = "lower.range.selected.value.key";
    private static final String UPPER_RANGE_SELECTED_VALUE_KEY = "upper.range.selected.value.key";
    private static final String IS_ENABLED_VALUE_KEY = "is.enabled.value.key";
    private static final Color FG_TOOLTIP_DEFAULT = new GColor("color.fg.version.tracking.tooltip");
    private static final Integer BASE_COMPONENT_LAYER = 1;
    private static final Integer HOVER_COMPONENT_LAYER = 2;
    private static final Integer DISABLED_COMPONENT_LAYER = 3;
    private static final Long MIN_ADDRESS_VALUE = 0L;
    private static final Long MAX_ADDRESS_VALUE = Long.MAX_VALUE;
    private JComponent component = this.createComponent();
    private FilterFormattedTextField lowerAddressRangeTextField;
    private FilterFormattedTextField upperAddressRangeTextField;
    private JComboBox<String> lowerRangeComboBox;
    private JComboBox<String> upperRangeComboBox;
    private boolean isEnabled;
    private JCheckBox enableCheckBox;
    private JComponent disabledScreen;
    private JPanel lowerRangePanel;
    private JPanel upperRangePanel;

    protected AbstractAddressRangeFilter() {
    }

    private JComponent createComponent() {
        final JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder("Address Range"));
        this.enableCheckBox = new GCheckBox("enable", true);
        this.enableCheckBox.addItemListener(e -> this.enableFilter(this.enableCheckBox.isSelected()));
        this.enableCheckBox.setSelected(true);
        JPanel enablePanel = new JPanel(new BorderLayout());
        enablePanel.add((Component)this.enableCheckBox, "North");
        this.lowerAddressRangeTextField = new FilterFormattedTextField(new IntegerFormatterFactory((IntegerFormatter)new HexIntegerFormatter(), false), MIN_ADDRESS_VALUE);
        this.lowerAddressRangeTextField.setName("Lower Address Range Text Field");
        this.lowerAddressRangeTextField.setColumns(15);
        this.lowerAddressRangeTextField.setMinimumSize(this.lowerAddressRangeTextField.getPreferredSize());
        this.upperAddressRangeTextField = new FilterFormattedTextField(new IntegerFormatterFactory((IntegerFormatter)new HexIntegerFormatter(), false), MAX_ADDRESS_VALUE);
        this.upperAddressRangeTextField.setName("Upper Address Range Text Field");
        this.upperAddressRangeTextField.setColumns(15);
        this.upperAddressRangeTextField.setMinimumSize(this.upperAddressRangeTextField.getPreferredSize());
        this.lowerAddressRangeTextField.setInputVerifier(new BoundedRangeInputVerifier(this.upperAddressRangeTextField, true, MAX_ADDRESS_VALUE, MIN_ADDRESS_VALUE));
        this.upperAddressRangeTextField.setInputVerifier(new BoundedRangeInputVerifier(this.lowerAddressRangeTextField, false, MAX_ADDRESS_VALUE, MIN_ADDRESS_VALUE));
        String prototypeDisplay = "7fffffffffffffff";
        this.lowerRangeComboBox = this.createComboBox(this.lowerAddressRangeTextField, MIN_ADDRESS_VALUE, prototypeDisplay);
        this.upperRangeComboBox = this.createComboBox(this.upperAddressRangeTextField, MAX_ADDRESS_VALUE, prototypeDisplay);
        GDLabel rangeLabel = new GDLabel("<=");
        rangeLabel.setHorizontalAlignment(0);
        String fgColor = WebColors.toString((Color)FG_TOOLTIP_DEFAULT, (boolean)false);
        this.lowerRangePanel = new JPanel(new GridLayout(2, 1));
        GHtmlLabel lowLabel = new GHtmlLabel("<html><font size=\"2\" color=\"" + fgColor + "\">low</font>");
        lowLabel.setHorizontalAlignment(0);
        lowLabel.setVerticalAlignment(3);
        this.lowerRangePanel.add((Component)lowLabel);
        this.lowerRangePanel.add(this.lowerRangeComboBox);
        JPanel labelPanel = new JPanel(new GridLayout(2, 1));
        labelPanel.add(Box.createVerticalStrut(5));
        GDLabel statusLabel = new GDLabel("<=");
        statusLabel.setHorizontalAlignment(0);
        labelPanel.add((Component)statusLabel);
        this.upperRangePanel = new JPanel(new GridLayout(2, 1));
        GHtmlLabel upperLabel = new GHtmlLabel("<html><font size=\"2\" color=\"" + fgColor + "\">high</font>");
        upperLabel.setHorizontalAlignment(0);
        upperLabel.setVerticalAlignment(3);
        this.upperRangePanel.add((Component)upperLabel);
        this.upperRangePanel.add(this.upperRangeComboBox);
        panel.add(enablePanel);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.lowerRangePanel);
        panel.add(labelPanel);
        panel.add(this.upperRangePanel);
        int minHeight = 175;
        JLayeredPane layeredPane = new JLayeredPane(){

            @Override
            public Dimension getMaximumSize() {
                Dimension preferredSize = panel.getPreferredSize();
                preferredSize.height = Math.max(preferredSize.height, 175);
                return preferredSize;
            }
        };
        FilterStatusListener notificationListener = status -> this.fireStatusChanged(status);
        StatusLabel lowerScoreStatusLabel = new StatusLabel(this.lowerAddressRangeTextField, MIN_ADDRESS_VALUE);
        this.lowerAddressRangeTextField.addFilterStatusListener(lowerScoreStatusLabel);
        this.lowerAddressRangeTextField.addFilterStatusListener(notificationListener);
        StatusLabel upperScoreStatusLabel = new StatusLabel(this.upperAddressRangeTextField, MAX_ADDRESS_VALUE);
        this.upperAddressRangeTextField.addFilterStatusListener(upperScoreStatusLabel);
        this.upperAddressRangeTextField.addFilterStatusListener(notificationListener);
        this.disabledScreen = this.createDisabledScreen(layeredPane);
        layeredPane.add((Component)panel, BASE_COMPONENT_LAYER);
        layeredPane.add((Component)((Object)lowerScoreStatusLabel), HOVER_COMPONENT_LAYER);
        layeredPane.add((Component)((Object)upperScoreStatusLabel), HOVER_COMPONENT_LAYER);
        layeredPane.add((Component)this.disabledScreen, DISABLED_COMPONENT_LAYER);
        layeredPane.setPreferredSize(panel.getPreferredSize());
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = panel.getPreferredSize();
                panel.setBounds(0, 0, preferredSize.width, preferredSize.height);
                panel.validate();
            }
        });
        this.enableFilter(this.enableCheckBox.isSelected());
        return layeredPane;
    }

    private JComponent createDisabledScreen(Container parent) {
        JComponent screen = new JComponent(){

            @Override
            protected void paintComponent(Graphics g) {
                Color bg = this.getBackground();
                Color disabledColor = ColorUtils.withAlpha((Color)bg, (int)100);
                g.setColor(disabledColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        };
        parent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractAddressRangeFilter.this.resizeDisabledScreen();
            }
        });
        return screen;
    }

    private void resizeDisabledScreen() {
        Rectangle startBounds = this.lowerRangePanel.getBounds();
        Rectangle endBounds = this.upperRangePanel.getBounds();
        int x = startBounds.x;
        int y = startBounds.y;
        int panelOffset = endBounds.x - x;
        int width = panelOffset + endBounds.width;
        int height = endBounds.height;
        if (width <= 0 || height <= 0) {
            SwingUtilities.invokeLater(() -> this.resizeDisabledScreen());
            return;
        }
        this.disabledScreen.setBounds(x, y, width, height);
        this.component.validate();
    }

    private JComboBox<String> createComboBox(FilterFormattedTextField field, Long defaultValue, String prototypeString) {
        GhidraComboBox<String> comboBox = new GhidraComboBox<String>((ComboBoxModel)new LimitedHistoryComboBoxModel()){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Rectangle bounds = this.getBounds();
                Color oldColor = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, bounds.width, bounds.height);
                g.setColor(oldColor);
            }
        };
        comboBox.setEditor((ComboBoxEditor)new FormattedFieldComboBoxEditor(field));
        comboBox.setEditable(true);
        comboBox.setPrototypeDisplayValue((Object)prototypeString);
        comboBox.addItem((Object)Long.toHexString(defaultValue));
        comboBox.setSelectedIndex(0);
        comboBox.setBackground(field.getBackground());
        field.addPropertyChangeListener(new BackgroundColorChangeListener((JComboBox<?>)comboBox));
        field.setBorder(BorderFactory.createEmptyBorder());
        return comboBox;
    }

    private void enableFilter(boolean enable) {
        this.lowerAddressRangeTextField.setEnabled(enable);
        this.upperAddressRangeTextField.setEnabled(enable);
        this.isEnabled = enable;
        this.disabledScreen.setVisible(!this.isEnabled);
        this.fireStatusChanged(this.getFilterStatus());
    }

    @Override
    public void clearFilter() {
        this.lowerAddressRangeTextField.setText(MIN_ADDRESS_VALUE.toString());
        this.upperAddressRangeTextField.setText(MAX_ADDRESS_VALUE.toString());
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        if (!this.isEnabled) {
            return Filter.FilterEditingStatus.NONE;
        }
        Filter.FilterEditingStatus lowerStatus = this.lowerAddressRangeTextField.getFilterStatus();
        Filter.FilterEditingStatus upperStatus = this.upperAddressRangeTextField.getFilterStatus();
        if (lowerStatus == Filter.FilterEditingStatus.ERROR || upperStatus == Filter.FilterEditingStatus.ERROR) {
            return Filter.FilterEditingStatus.ERROR;
        }
        if (lowerStatus == Filter.FilterEditingStatus.APPLIED || upperStatus == Filter.FilterEditingStatus.APPLIED) {
            return Filter.FilterEditingStatus.APPLIED;
        }
        return Filter.FilterEditingStatus.NONE;
    }

    @Override
    public boolean passesFilter(T t) {
        return this.associationPassesFilter(this.getAssocation(t));
    }

    protected abstract VTAssociation getAssocation(T var1);

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        if (!this.isEnabled) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        String lowerText = this.lowerAddressRangeTextField.getText();
        String upperText = this.upperAddressRangeTextField.getText();
        Long lowerValue = Long.valueOf(lowerText, 16);
        Long upperValue = Long.valueOf(upperText, 16);
        if (lowerValue.compareTo(MIN_ADDRESS_VALUE) == 0 && upperValue.compareTo(MAX_ADDRESS_VALUE) == 0) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    protected boolean associationPassesFilter(VTAssociation association) {
        if (!this.isEnabled) {
            return true;
        }
        if (this.lowerAddressRangeTextField.getFilterStatus() == Filter.FilterEditingStatus.ERROR || this.upperAddressRangeTextField.getFilterStatus() == Filter.FilterEditingStatus.ERROR) {
            return true;
        }
        Address sourceAddress = association.getSourceAddress();
        if (this.isAddressInRange(sourceAddress)) {
            return true;
        }
        Address destinationAddress = association.getDestinationAddress();
        return this.isAddressInRange(destinationAddress);
    }

    private boolean isAddressInRange(Address address) {
        Long lowerAddressFilter;
        String text = this.lowerAddressRangeTextField.getText();
        if (text == null || "".equals(text.trim())) {
            return true;
        }
        Long offset = address.getOffset();
        if (offset.compareTo(lowerAddressFilter = Long.valueOf(text, 16)) < 0) {
            return false;
        }
        text = this.upperAddressRangeTextField.getText();
        if (text == null || "".equals(text)) {
            return true;
        }
        Long upperAddressFilter = Long.valueOf(text, 16);
        return offset.compareTo(upperAddressFilter) <= 0;
    }

    @Override
    public Number getUpperNumber() {
        String text = this.upperAddressRangeTextField.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Long longValue = Long.valueOf(text, 16);
        return longValue;
    }

    @Override
    public Number getLowerNumber() {
        String text = this.lowerAddressRangeTextField.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Long longValue = Long.valueOf(text, 16);
        return longValue;
    }

    @Override
    public FilterState getFilterState() {
        return new AddressRangeFilterState(this);
    }

    @Override
    public void restoreFilterState(FilterState state) {
        ((AddressRangeFilterState)state).restoreState();
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        String[] lowerValues = this.getComboBoxValues(this.lowerRangeComboBox);
        String[] upperValues = this.getComboBoxValues(this.upperRangeComboBox);
        String lowerText = this.lowerAddressRangeTextField.getText();
        String upperText = this.upperAddressRangeTextField.getText();
        boolean enabledState = this.enableCheckBox.isSelected();
        String masterKey = this.getStateKey();
        saveState.putStrings(masterKey + ":lower.range.values.key", lowerValues);
        saveState.putStrings(masterKey + ":upper.range.values.key", upperValues);
        saveState.putString(masterKey + ":lower.range.selected.value.key", lowerText);
        saveState.putString(masterKey + ":upper.range.selected.value.key", upperText);
        saveState.putBoolean(masterKey + ":is.enabled.value.key", enabledState);
    }

    private String getStateKey() {
        return AbstractAddressRangeFilter.class.getSimpleName() + DELIMITER + this.getClass().getName();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        String masterKey = this.getStateKey();
        String[] lowerValues = saveState.getStrings(masterKey + ":lower.range.values.key", null);
        String[] upperValues = saveState.getStrings(masterKey + ":upper.range.values.key", null);
        String lowerText = saveState.getString(masterKey + ":lower.range.selected.value.key", null);
        String upperText = saveState.getString(masterKey + ":upper.range.selected.value.key", null);
        boolean enabledState = saveState.getBoolean(masterKey + ":is.enabled.value.key", false);
        this.setComboBoxValues(this.lowerRangeComboBox, lowerValues);
        this.setComboBoxValues(this.upperRangeComboBox, upperValues);
        if (lowerText != null) {
            this.lowerRangeComboBox.setSelectedItem(lowerText);
        }
        if (upperText != null) {
            this.upperRangeComboBox.setSelectedItem(upperText);
        }
        this.enableCheckBox.setSelected(enabledState);
    }

    private String[] getComboBoxValues(JComboBox<String> comboBox) {
        ComboBoxModel<String> model = comboBox.getModel();
        int size = model.getSize();
        String[] values = new String[size];
        for (int i = 0; i < size; ++i) {
            values[i] = (String)model.getElementAt(i);
        }
        return values;
    }

    private void setComboBoxValues(JComboBox<String> comboBox, String[] values) {
        if (values == null) {
            return;
        }
        comboBox.removeAllItems();
        for (String value : values) {
            comboBox.addItem(value);
        }
    }

    @Override
    public boolean isSubFilterOf(Filter<T> otherFilter) {
        if (!(otherFilter instanceof NumberRangeProducer)) {
            return false;
        }
        return this.isSubFilterOf(this, (NumberRangeProducer)((Object)otherFilter));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.lowerAddressRangeTextField.getText() + " - " + this.upperAddressRangeTextField.getText();
    }

    private static class LimitedHistoryComboBoxModel
    extends DefaultComboBoxModel<String> {
        private static final int MAX_SIZE = 10;

        private LimitedHistoryComboBoxModel() {
        }

        @Override
        public void addElement(String anObject) {
            int index = this.getIndexOf(anObject);
            if (index != -1) {
                super.insertElementAt(anObject, 0);
                this.removeElementAt(index + 1);
                return;
            }
            super.insertElementAt(anObject, 0);
            this.enforceSize();
        }

        @Override
        public void insertElementAt(String anObject, int index) {
            int currentIndex = this.getIndexOf(anObject);
            if (currentIndex != -1) {
                super.insertElementAt(anObject, index);
                this.removeElementAt(currentIndex + 1);
                return;
            }
            super.insertElementAt(anObject, index);
            this.enforceSize();
        }

        private void enforceSize() {
            int size = this.getSize();
            if (size > 10) {
                this.removeElementAt(size - 1);
            }
        }
    }

    private class FormattedFieldComboBoxEditor
    implements ComboBoxEditor {
        private EventListenerList listeners = new EventListenerList();
        private final FilterFormattedTextField textField;
        private final Object defaultValue;

        FormattedFieldComboBoxEditor(FilterFormattedTextField textField) {
            this.textField = textField;
            this.defaultValue = textField.getValue();
        }

        @Override
        public Component getEditorComponent() {
            return this.textField;
        }

        @Override
        public Object getItem() {
            return this.textField.getText();
        }

        @Override
        public void selectAll() {
            this.textField.selectAll();
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject == null) {
                this.textField.setValue(this.defaultValue);
                return;
            }
            this.textField.setText(anObject.toString());
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.listeners.add(ActionListener.class, l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.listeners.remove(ActionListener.class, l);
        }
    }

    private class BackgroundColorChangeListener
    implements PropertyChangeListener {
        private final JComboBox<?> comboBox;

        BackgroundColorChangeListener(JComboBox<?> comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("background".equals(evt.getPropertyName())) {
                Color newColor = (Color)evt.getNewValue();
                this.comboBox.setBackground(newColor);
            }
        }
    }

    private class AddressRangeFilterState
    extends FilterState {
        private final String ENABLED_KEY = "enabled";

        AddressRangeFilterState(Filter<?> filter) {
            super(filter);
            this.ENABLED_KEY = "enabled";
            this.put("enabled", AbstractAddressRangeFilter.this.isEnabled);
            this.put(AbstractAddressRangeFilter.this.lowerAddressRangeTextField.getName(), AbstractAddressRangeFilter.this.lowerAddressRangeTextField.getText());
            this.put(AbstractAddressRangeFilter.this.upperAddressRangeTextField.getName(), AbstractAddressRangeFilter.this.upperAddressRangeTextField.getText());
        }

        void restoreState() {
            AbstractAddressRangeFilter.this.enableCheckBox.setSelected((Boolean)this.get("enabled"));
            String lowerText = (String)this.get(AbstractAddressRangeFilter.this.lowerAddressRangeTextField.getName());
            String upperText = (String)this.get(AbstractAddressRangeFilter.this.upperAddressRangeTextField.getName());
            AbstractAddressRangeFilter.this.lowerAddressRangeTextField.setText(lowerText);
            AbstractAddressRangeFilter.this.upperAddressRangeTextField.setText(upperText);
            AbstractAddressRangeFilter.this.lowerRangeComboBox.addItem(lowerText);
            AbstractAddressRangeFilter.this.upperRangeComboBox.addItem(upperText);
        }

        @Override
        public boolean isSame(FilterState other) {
            Boolean wasEnabled = (Boolean)other.get("enabled");
            if (!wasEnabled.booleanValue() && !AbstractAddressRangeFilter.this.isEnabled) {
                return true;
            }
            if (wasEnabled.booleanValue() && AbstractAddressRangeFilter.this.isEnabled) {
                String oldLowerText = (String)other.get(AbstractAddressRangeFilter.this.lowerAddressRangeTextField.getName());
                String currentLowerText = AbstractAddressRangeFilter.this.lowerAddressRangeTextField.getText();
                if (!currentLowerText.equals(oldLowerText)) {
                    return false;
                }
                String oldUpperText = (String)other.get(AbstractAddressRangeFilter.this.upperAddressRangeTextField.getName());
                String currentUpperText = AbstractAddressRangeFilter.this.upperAddressRangeTextField.getText();
                return currentUpperText.equals(oldUpperText);
            }
            return false;
        }
    }
}

