/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class ApplyBlockedMatchTask
extends VtTask {
    protected final VTController controller;
    private final ToolOptions applyOptions;
    private final VTMatch match;
    private final List<VTAssociation> conflicts;
    private boolean ignoreExcludedItem;
    private boolean ignoreIncompleteItem;

    public ApplyBlockedMatchTask(VTController controller, VTMatch match, List<VTAssociation> conflicts) {
        super("Apply Blocked Match", controller.getSession());
        this.controller = controller;
        this.applyOptions = controller.getOptions();
        this.match = match;
        this.conflicts = conflicts;
        this.ignoreExcludedItem = this.applyOptions.getBoolean("Apply Markup Options.Set Excluded Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_EXCLUDED_MARKUP_ITEMS);
        this.ignoreIncompleteItem = this.applyOptions.getBoolean("Apply Markup Options.Set Incomplete Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_INCOMPLETE_MARKUP_ITEMS);
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        Program destinationProgram = this.controller.getDestinationProgram();
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)destinationProgram);
        return manager.scheduleWorker(new AnalysisWorker(){

            public String getWorkerName() {
                return ApplyBlockedMatchTask.this.getTaskTitle();
            }

            public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor taskMonitor) throws CancelledException, VersionTrackingApplyException {
                ApplyBlockedMatchTask.this.clearAndApplyMatch(taskMonitor);
                return true;
            }
        }, null, false, monitor);
    }

    private void clearAndApplyMatch(TaskMonitor monitor) throws CancelledException, VersionTrackingApplyException {
        monitor.setMessage("Applying a blocked match");
        monitor.initialize(2L);
        monitor.checkCancelled();
        VTAssociation association = this.match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        if (status != VTAssociationStatus.BLOCKED) {
            return;
        }
        monitor.setMessage("Clearing conflicts...");
        this.clearConflicts(monitor);
        monitor.setMessage("Applying match...");
        this.acceptMatch();
        MatchInfo matchInfo = this.controller.getMatchInfo(this.match);
        Collection<VTMarkupItem> markupItems = matchInfo.getAppliableMarkupItems(monitor);
        if (markupItems == null || markupItems.size() == 0) {
            monitor.setProgress(2L);
            return;
        }
        this.applyMarkupItems(monitor, markupItems);
        monitor.setProgress(2L);
    }

    private void clearConflicts(TaskMonitor monitor) throws CancelledException, VersionTrackingApplyException {
        for (VTAssociation association : this.conflicts) {
            monitor.checkCancelled();
            VTAssociationStatus status = association.getStatus();
            if (status != VTAssociationStatus.ACCEPTED) continue;
            Collection<VTMarkupItem> markupItems = association.getMarkupItems(monitor);
            for (VTMarkupItem item : markupItems) {
                monitor.checkCancelled();
                this.maybeUnapply(item);
                this.maybeClearStatus(item);
            }
            this.clearAssociation(association);
            monitor.incrementProgress(1L);
        }
    }

    private void maybeUnapply(VTMarkupItem markupItem) throws VersionTrackingApplyException {
        if (markupItem.canUnapply()) {
            markupItem.unapply();
        }
    }

    private void maybeClearStatus(VTMarkupItem markupItem) {
        VTMarkupItemStatus status = markupItem.getStatus();
        if (!status.isDefault() && !status.isUnappliable()) {
            markupItem.setConsidered(VTMarkupItemConsideredStatus.UNCONSIDERED);
        }
    }

    private void clearAssociation(VTAssociation association) {
        try {
            association.clearStatus();
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Should not have been given an association to clear when it is not already accepted or rejected - current status: " + association.getStatus());
        }
    }

    private void acceptMatch() {
        VTAssociation association = this.match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        if (status == VTAssociationStatus.ACCEPTED) {
            return;
        }
        try {
            association.setAccepted();
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Should have been given an association that is not blocked - current status: " + association.getStatus());
        }
    }

    private void applyMarkupItems(TaskMonitor monitor, Collection<VTMarkupItem> markupItems) throws CancelledException {
        for (VTMarkupItem item : markupItems) {
            monitor.checkCancelled();
            VTMarkupItemStatus status = item.getStatus();
            if (status != VTMarkupItemStatus.UNAPPLIED) continue;
            try {
                this.applyMarkupItem(item);
            }
            catch (VersionTrackingApplyException e) {
                this.reportError(e);
            }
        }
    }

    private void applyMarkupItem(VTMarkupItem item) throws VersionTrackingApplyException {
        if (item.getDestinationAddress() == null) {
            if (this.ignoreIncompleteItem) {
                item.setConsidered(VTMarkupItemConsideredStatus.IGNORE_DONT_CARE);
            }
            return;
        }
        VTMarkupType markupType = item.getMarkupType();
        VTMarkupItemApplyActionType applyAction = markupType.getApplyAction(this.applyOptions);
        if (applyAction == null) {
            return;
        }
        item.apply(applyAction, this.applyOptions);
        if (item.canApply() && this.ignoreExcludedItem) {
            item.setConsidered(VTMarkupItemConsideredStatus.IGNORE_DONT_CARE);
        }
    }
}

