/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.dd;

import ghidra.program.model.data.ISF.IsfObject;
import ghidra.program.model.data.ISF.IsfSetting;
import ghidra.program.model.listing.Data;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.export.dd.ExtComment;
import sarif.managers.CommentsSarifMgr;

public class ExtCommentSet
implements IsfObject {
    List<ExtComment> comment;
    List<IsfSetting> setting;
    Map<Integer, ExtCommentSet> embedded;

    public ExtCommentSet(Data data) {
        this.exportComments(data);
        int n = data.getNumComponents();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Data component = data.getComponent(i);
                ExtCommentSet cs = new ExtCommentSet(component);
                if (cs.comment == null && cs.setting == null && cs.embedded == null) continue;
                if (this.embedded == null) {
                    this.embedded = new HashMap<Integer, ExtCommentSet>();
                }
                this.embedded.put(i, cs);
            }
        }
    }

    private void exportComments(Data data) {
        for (int i = 0; i < CommentsSarifMgr.COMMENT_TYPES.length; ++i) {
            int type = CommentsSarifMgr.COMMENT_TYPES[i];
            String cval = data.getComment(type);
            if (cval == null) continue;
            if (this.comment == null) {
                this.comment = new ArrayList<ExtComment>();
            }
            ExtComment isf = new ExtComment(data, type);
            this.comment.add(isf);
        }
        for (String n : data.getNames()) {
            Object value = data.getValue(n);
            if (value == null) continue;
            if (this.setting == null) {
                this.setting = new ArrayList<IsfSetting>();
            }
            IsfSetting isf = new IsfSetting(n, value);
            this.setting.add(isf);
        }
    }
}

