/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result;

import com.contrastsecurity.sarif.CodeFlow;
import com.contrastsecurity.sarif.ThreadFlow;
import com.contrastsecurity.sarif.ThreadFlowLocation;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.handlers.SarifResultHandler;

public class SarifCodeFlowResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "CodeFlows";
    }

    @Override
    public List<Map<String, List<Address>>> parse() {
        ArrayList<Map<String, List<Address>>> res = new ArrayList<Map<String, List<Address>>>();
        List codeFlows = this.result.getCodeFlows();
        if (codeFlows != null) {
            for (CodeFlow f : codeFlows) {
                HashMap<String, List<Address>> map = new HashMap<String, List<Address>>();
                this.parseCodeFlow(f, map);
                res.add(map);
            }
        }
        return res;
    }

    private void parseCodeFlow(CodeFlow f, Map<String, List<Address>> map) {
        for (ThreadFlow t : f.getThreadFlows()) {
            ArrayList<Address> addrs = new ArrayList<Address>();
            for (ThreadFlowLocation loc : t.getLocations()) {
                addrs.add(this.controller.locationToAddress(loc.getLocation()));
            }
            map.put(t.getId(), addrs);
        }
    }
}

