/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.relocs.SarifRelocationWriter;
import sarif.managers.SarifMgr;

public class RelocationTableSarifMgr
extends SarifMgr {
    public static String KEY = "RELOCATIONS";
    public static String SUBKEY = "Relocation";

    RelocationTableSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        RelocationTable relocTable = this.program.getRelocationTable();
        try {
            Address addr = this.getLocation(result);
            int type = Integer.parseInt((String)result.get("kind"));
            long[] values = this.unpackLongs((String)result.get("value"));
            byte[] bytes = this.unpackBytes((String)result.get("bytes"));
            String symbolName = (String)result.get("name");
            Relocation.Status status = Relocation.Status.UNKNOWN;
            if (bytes == null) {
                if (status != null && status.hasBytes()) {
                    this.log.appendMsg("Relocation at " + addr + " missing required bytes - forced UNKNOWN status.");
                    status = Relocation.Status.UNKNOWN;
                }
            } else if (status == null) {
                status = type == 0 ? Relocation.Status.APPLIED_OTHER : Relocation.Status.APPLIED;
            }
            relocTable.add(addr, status, type, values, bytes, symbolName);
        }
        catch (AddressOverflowException e) {
            this.log.appendException((Throwable)e);
        }
        return true;
    }

    private long[] unpackLongs(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(attrValue, ",");
        long[] values = new long[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = RelocationTableSarifMgr.parseLong(st.nextToken());
        }
        return values;
    }

    private byte[] unpackBytes(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(attrValue, ",");
        byte[] values = new byte[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            values[index++] = (byte)RelocationTableSarifMgr.parseLong(st.nextToken());
        }
        return values;
    }

    void write(JsonArray results, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing RELOCATION TABLE ...");
        ArrayList<Relocation> request = new ArrayList<Relocation>();
        Iterator iter = this.program.getRelocationTable().getRelocations();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            request.add((Relocation)iter.next());
        }
        RelocationTableSarifMgr.writeAsSARIF(request, results);
    }

    public static void writeAsSARIF(List<Relocation> request, JsonArray results) throws IOException {
        SarifRelocationWriter writer = new SarifRelocationWriter(request, null);
        new TaskLauncher((Task)new SarifWriterTask(SUBKEY, writer, results), null);
    }
}

