/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.contrastsecurity.sarif.ArtifactLocation;
import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.PhysicalLocation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sarif.SarifProgramOptions;

public abstract class SarifMgr {
    protected static final Boolean USE_SARIF = true;
    protected String key;
    protected static Map<String, Boolean> columnKeys = new HashMap<String, Boolean>();
    protected Program program;
    protected Listing listing;
    protected AddressFactory factory;
    protected static Map<String, ExternalLocation> externalMap;
    protected boolean firstPass = true;
    protected MessageLog log = new MessageLog(){

        public void appendException(Throwable t) {
            this.appendMsg(t.toString());
        }
    };
    private static final String LESS_THAN = "&lt;";
    private static final String GREATER_THAN = "&gt;";
    private static final String APOSTROPHE = "&apos;";
    private static final String QUOTE = "&quot;";
    private static final String AMPERSAND = "&amp;";
    private static final Pattern HEX_DIGIT_PATTERN;

    public SarifMgr(String key, Program program, MessageLog log) {
        this.key = key;
        this.program = program;
        this.listing = program.getListing();
        this.factory = program.getAddressFactory();
        this.log = log;
        columnKeys.put("name", false);
        columnKeys.put("location", true);
        columnKeys.put("kind", false);
        columnKeys.put("type", true);
        columnKeys.put("value", false);
        columnKeys.put("size", true);
        columnKeys.put("comment", true);
        columnKeys.put("typeName", true);
        columnKeys.put("typeLocation", true);
    }

    protected void writeLocation(JsonObject result, Address start, Address end) {
        JsonArray locs = new JsonArray();
        result.add("locations", (JsonElement)locs);
        JsonObject element = new JsonObject();
        locs.add((JsonElement)element);
        JsonObject ploc = new JsonObject();
        element.add("physicalLocation", (JsonElement)ploc);
        JsonObject address = new JsonObject();
        ploc.add("address", (JsonElement)address);
        address.addProperty("absoluteAddress", (Number)start.getOffset());
        if (end != null) {
            address.addProperty("length", (Number)(end.subtract(start) + 1L));
            if (!start.getAddressSpace().equals(this.program.getAddressFactory().getDefaultAddressSpace())) {
                JsonObject artifact = new JsonObject();
                ploc.add("artifactLocation", (JsonElement)artifact);
                artifact.addProperty("uri", start.toString());
            }
        }
    }

    protected void writeLocations(JsonObject result, AddressSetView set) {
        JsonArray locs = new JsonArray();
        result.add("locations", (JsonElement)locs);
        AddressRangeIterator addressRanges = set.getAddressRanges();
        while (addressRanges.hasNext()) {
            JsonObject element = new JsonObject();
            locs.add((JsonElement)element);
            AddressRange next = (AddressRange)addressRanges.next();
            JsonObject ploc = new JsonObject();
            element.add("physicalLocation", (JsonElement)ploc);
            JsonObject address = new JsonObject();
            ploc.add("address", (JsonElement)address);
            address.addProperty("absoluteAddress", (Number)next.getMinAddress().getOffset());
            address.addProperty("length", (Number)next.getLength());
            Address minAddress = next.getMinAddress();
            if (minAddress.getAddressSpace().equals(this.program.getAddressFactory().getDefaultAddressSpace())) continue;
            JsonObject artifact = new JsonObject();
            ploc.add("artifactLocation", (JsonElement)artifact);
            artifact.addProperty("uri", minAddress.toString());
        }
    }

    protected AddressSet getLocations(Map<String, Object> result, AddressSet set) throws AddressOverflowException {
        List locations;
        String ospace;
        boolean isExternal;
        if (set == null) {
            set = new AddressSet();
        }
        AddressFactory af = this.program.getAddressFactory();
        AddressSpace space = af.getDefaultAddressSpace();
        String namespace = (String)result.get("location");
        if (namespace != null && (isExternal = namespace.contains("<EXTERNAL>"))) {
            space = af.getAddressSpace("EXTERNAL");
        }
        if ((ospace = (String)result.get("overlayedSpace")) != null) {
            space = af.getAddressSpace(ospace);
        }
        if ((locations = (List)result.get("Locations")) == null) {
            return set;
        }
        for (Location location : locations) {
            Address test;
            String uri;
            PhysicalLocation physicalLocation = location.getPhysicalLocation();
            Long addr = physicalLocation.getAddress().getAbsoluteAddress();
            Address address = this.longToAddress(space, addr);
            long len = physicalLocation.getAddress().getLength();
            ArtifactLocation artifact = physicalLocation.getArtifactLocation();
            if (artifact != null && (uri = artifact.getUri()) != null && (test = this.program.getAddressFactory().getAddress(uri)) != null) {
                address = test;
            }
            set.add((AddressRange)new AddressRangeImpl(address, len));
        }
        return set;
    }

    protected Address getLocation(Map<String, Object> result) throws AddressOverflowException {
        AddressSet set = new AddressSet();
        this.getLocations(result, set);
        return set.getMinAddress();
    }

    protected void readResults(List<Map<String, Object>> list, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        if (list != null) {
            monitor.setMessage("Processing " + this.key + "...");
            monitor.setMaximum((long)list.size());
            for (Map<String, Object> result : list) {
                this.read(result, options, monitor);
                monitor.increment();
            }
        } else {
            monitor.setMessage("Skipping over " + this.key + " ...");
        }
    }

    public abstract boolean read(Map<String, Object> var1, SarifProgramOptions var2, TaskMonitor var3) throws AddressFormatException, CancelledException;

    public String getKey() {
        return this.key;
    }

    protected Namespace walkNamespace(Namespace parent, String namespace, Address addr, SourceType sourceType, Boolean isClass) throws IOException {
        Object child;
        int sep = namespace.indexOf("::");
        if (sep <= 0) {
            return parent;
        }
        String tag = namespace.substring(0, sep);
        if (addr != null) {
            Function func = this.program.getFunctionManager().getFunctionContaining(addr);
            if (func != null) {
                if (func.getName(true).equals(tag)) {
                    return this.walkNamespace((Namespace)func, namespace.substring(sep + 2), addr, sourceType, isClass);
                }
            } else if (tag.startsWith("FUN_")) {
                return null;
            }
        }
        if ((child = this.program.getSymbolTable().getNamespace(tag, parent)) == null) {
            try {
                child = isClass != null && isClass.booleanValue() ? this.program.getSymbolTable().createClass(parent, tag, sourceType) : NamespaceUtils.createNamespaceHierarchy((String)tag, (Namespace)parent, (Program)this.program, (SourceType)sourceType);
            }
            catch (DuplicateNameException | InvalidInputException e) {
                throw new IOException("Error creating namespace for " + tag);
            }
        }
        return this.walkNamespace((Namespace)child, namespace.substring(sep + 2), addr, sourceType, isClass);
    }

    protected SourceType getSourceType(String signatureSource) {
        SourceType sourceType = SourceType.IMPORTED;
        if (signatureSource == null) {
            return sourceType;
        }
        try {
            if (signatureSource != null) {
                sourceType = SourceType.valueOf((String)signatureSource);
            }
        }
        catch (IllegalArgumentException iae) {
            this.log.appendMsg("Unknown SourceType: " + signatureSource);
        }
        return sourceType;
    }

    public static Map<String, Boolean> getColumnKeys() {
        return columnKeys;
    }

    public static Address parseAddress(AddressFactory factory, String addrString) {
        int index;
        if (addrString == null) {
            return null;
        }
        Address addr = factory.getAddress(addrString);
        if (addr == null && (index = addrString.indexOf("::")) > 0) {
            addr = factory.getAddress(addrString.substring(index + 2));
        }
        return addr;
    }

    public static long parseLong(String longStr) {
        long val;
        boolean isNegative = longStr.startsWith("-");
        if (isNegative) {
            longStr = longStr.substring(1);
        }
        int radix = 10;
        if (longStr.startsWith("0x")) {
            longStr = longStr.substring(2);
            radix = 16;
        }
        long l = val = radix == 10 ? NumericUtilities.parseLong((String)longStr) : NumericUtilities.parseHexLong((String)longStr);
        if (isNegative) {
            val *= -1L;
        }
        return val;
    }

    public static String unEscapeElementEntities(String escapedSARIFString) {
        Matcher matcher = HEX_DIGIT_PATTERN.matcher(escapedSARIFString);
        StringBuilder buffy = new StringBuilder();
        while (matcher.find()) {
            int codePoint = Integer.parseInt(matcher.group(1), 16);
            matcher.appendReplacement(buffy, Character.toString(codePoint));
        }
        matcher.appendTail(buffy);
        String unescapedStr = buffy.toString();
        unescapedStr = unescapedStr.replaceAll(LESS_THAN, "<");
        unescapedStr = unescapedStr.replaceAll(GREATER_THAN, ">");
        unescapedStr = unescapedStr.replaceAll(APOSTROPHE, "'");
        unescapedStr = unescapedStr.replaceAll(QUOTE, "\"");
        unescapedStr = unescapedStr.replaceAll(AMPERSAND, "&");
        return unescapedStr;
    }

    public Address longToAddress(AddressSpace space, Object addr) {
        if (addr instanceof Long) {
            return space.getAddress(((Long)addr).longValue());
        }
        return space.getAddress((long)((Integer)addr).intValue());
    }

    static {
        HEX_DIGIT_PATTERN = Pattern.compile("[&][#][x]([\\da-fA-F]+)[;]");
    }
}

