/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.linux;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import ghidra.pty.linux.PosixC;
import java.io.IOException;
import java.io.OutputStream;

public class FdOutputStream
extends OutputStream {
    private static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final int fd;
    private boolean closed = false;

    FdOutputStream(int fd) {
        this.fd = fd;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        Memory buf = new Memory((long)len);
        buf.write(0L, b, off, len);
        try {
            int ret;
            int total = 0;
            while ((total += (ret = LIB_POSIX.write(this.fd, (Pointer)buf, len - total))) < len) {
            }
        }
        catch (LastErrorException e) {
            if (e.getErrorCode() == 5 || e.getErrorCode() == 9) {
                throw new IOException(e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }
}

