/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.linux;

import ghidra.pty.PtyChild;
import ghidra.pty.PtySession;
import ghidra.pty.linux.LinuxPtyEndpoint;
import ghidra.pty.linux.LinuxPtySessionLeader;
import ghidra.pty.linux.PosixC;
import ghidra.pty.local.LocalProcessPtySession;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class LinuxPtyChild
extends LinuxPtyEndpoint
implements PtyChild {
    static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final String name;

    LinuxPtyChild(int fd, String name) {
        super(fd);
        this.name = name;
    }

    @Override
    public String nullSession(Collection<PtyChild.TermMode> mode) {
        this.applyMode(mode);
        return this.name;
    }

    @Override
    public PtySession session(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        return this.sessionUsingJavaLeader(args, env, workingDirectory, mode);
    }

    protected PtySession sessionUsingJavaLeader(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>();
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        argsList.add(javaCommand);
        argsList.add("-cp");
        argsList.add(System.getProperty("java.class.path"));
        argsList.add(LinuxPtySessionLeader.class.getCanonicalName());
        argsList.add(this.name);
        argsList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argsList);
        if (env != null) {
            builder.environment().putAll(env);
        }
        if (workingDirectory != null) {
            builder.directory(workingDirectory);
        }
        builder.inheritIO();
        this.applyMode(mode);
        try {
            return new LocalProcessPtySession(builder.start(), this.name);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Could not start process with args " + Arrays.toString(args)), (Throwable)e);
            throw e;
        }
    }

    private void applyMode(Collection<PtyChild.TermMode> mode) {
        if (mode.contains(PtyChild.Echo.OFF)) {
            this.disableEcho();
        }
    }

    private void disableEcho() {
        PosixC.Termios.ByReference tmios = new PosixC.Termios.ByReference();
        LIB_POSIX.tcgetattr(this.fd, tmios);
        tmios.c_lflag &= 0xFFFFFFF7;
        LIB_POSIX.tcsetattr(this.fd, 0, tmios);
    }
}

