/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import ghidra.pty.PtySession;

public class SshPtySession
implements PtySession {
    private final Channel channel;

    public SshPtySession(Channel channel) {
        this.channel = channel;
    }

    @Override
    public int waitExited() throws InterruptedException {
        while (!this.channel.isEOF()) {
            Thread.sleep(1000L);
        }
        return this.channel.getExitStatus();
    }

    @Override
    public void destroyForcibly() {
        this.channel.disconnect();
    }

    @Override
    public String description() {
        Session session;
        try {
            session = this.channel.getSession();
        }
        catch (JSchException e) {
            return "ssh";
        }
        return "ssh " + session.getUserName() + "@" + session.getHost() + ":" + session.getPort();
    }
}

