/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.analyzers;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.refs.AssociateSymbolCmd;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.javaclass.analyzers.AbstractJavaAnalyzer;
import ghidra.javaclass.flags.MethodsInfoAccessFlags;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.FieldInfoJava;
import ghidra.javaclass.format.JavaClassUtil;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.BootstrapMethods;
import ghidra.javaclass.format.attributes.BootstrapMethodsAttribute;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.attributes.LocalVariableJava;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.attributes.MethodParameters;
import ghidra.javaclass.format.attributes.MethodParametersAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolClassInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolDoubleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFloatInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolIntegerInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInterfaceMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInvokeDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolLongInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodHandleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolStringInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.database.ProgramCompilerSpec;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JavaAnalyzer
extends AbstractJavaAnalyzer
implements AnalysisWorker {
    private MessageLog log;

    public String getName() {
        return "Java Class Analyzer";
    }

    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        try {
            return JavaClassUtil.isClassFile(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDescription() {
        return "Analyzes Java .class files.";
    }

    public AnalysisPriority getPriority() {
        return AnalysisPriority.FORMAT_ANALYSIS;
    }

    public boolean canAnalyze(Program program) {
        try {
            return JavaClassUtil.isClassFile(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog messageLog) throws Exception {
        this.log = messageLog;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, true, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception {
        MemoryByteProvider provider;
        BinaryReader reader;
        ClassFileJava classFile;
        DataType classFileDataType;
        Address address = program.getAddressFactory().getAddressSpace("constantPool").getMinAddress();
        Data cpClassFileData = this.createData(program, address, classFileDataType = (classFile = new ClassFileJava(reader = new BinaryReader((ByteProvider)(provider = new MemoryByteProvider(program.getMemory(), address)), !program.getLanguage().isBigEndian()))).toDataType());
        if (cpClassFileData == null) {
            this.log.appendMsg("Unable to create header data.");
        }
        Data constantPoolData = cpClassFileData.getComponent(4);
        this.markupConstantPoolAndReferences(program, classFile, constantPoolData, monitor);
        this.createProgramDataTypes(program, classFile, monitor, this.log);
        this.markupFields(program, classFile, monitor);
        this.markupMethods(program, classFile, monitor);
        this.disassembleMethods(program, classFile, monitor);
        this.processInstructions(program, constantPoolData, classFile, monitor);
        this.recordJavaVersionInfo(program, classFile);
        ProgramCompilerSpec.enableJavaLanguageDecompilation((Program)program);
        return true;
    }

    private void disassembleMethods(Program program, ClassFileJava classFile, TaskMonitor monitor) throws MemoryAccessException, DuplicateNameException, InvalidInputException {
        MethodInfoJava[] methods = classFile.getMethods();
        int max = methods.length;
        for (int i = 0; i < max; ++i) {
            Address index = JavaClassUtil.toLookupAddress(program, i);
            int offset = program.getMemory().getInt(index);
            Address blockStart = program.getAddressFactory().getDefaultAddressSpace().getAddress((long)offset);
            DisassembleCommand cmd = new DisassembleCommand(blockStart, null, true);
            cmd.applyTo((DomainObject)program, monitor);
            Function function = this.createFunction(program, blockStart);
            if (function == null) continue;
            this.setFunctionInfo(function, methods[i], classFile, (DataTypeManager)program.getDataTypeManager());
        }
    }

    private void createProgramDataTypes(Program program, ClassFileJava classFile, TaskMonitor monitor, MessageLog messageLog) {
        monitor.setMessage("JVM: processing class definitions");
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        int length = constantPool.length;
        for (int i = 0; i < length; ++i) {
            if (constantPool[i] instanceof ConstantPoolClassInfo) {
                this.addTypeForClassInfoElement(constantPool, i, (DataTypeManager)dtm);
                continue;
            }
            if (!(constantPool[i] instanceof ConstantPoolNameAndTypeInfo)) continue;
            this.addTypesForNameAndTypeInfo(constantPool, i, (DataTypeManager)dtm);
        }
    }

    private void addTypesForNameAndTypeInfo(AbstractConstantPoolInfoJava[] constantPool, int i, DataTypeManager dtm) {
        ConstantPoolNameAndTypeInfo nameAndType = (ConstantPoolNameAndTypeInfo)constantPool[i];
        ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[nameAndType.getDescriptorIndex()];
        String descriptor = utf8.getString();
        if (descriptor.contains("(")) {
            List<String> classNames = DescriptorDecoder.getTypeNameList(descriptor, true, false);
            for (String className : classNames) {
                if (this.isPrimitiveType(className)) continue;
                DescriptorDecoder.resolveClassForString(className, dtm, (DataType)DWordDataType.dataType);
            }
        } else {
            String className = DescriptorDecoder.getTypeNameFromDescriptor(descriptor, true, false);
            if (this.isPrimitiveType(className)) {
                return;
            }
            DescriptorDecoder.resolveClassForString(className, dtm, (DataType)DWordDataType.dataType);
        }
    }

    private boolean isPrimitiveType(String type) {
        switch (type) {
            case "boolean": 
            case "byte": 
            case "short": 
            case "char": 
            case "int": 
            case "float": 
            case "long": 
            case "double": 
            case "void": {
                return true;
            }
        }
        return false;
    }

    private void addTypeForClassInfoElement(AbstractConstantPoolInfoJava[] constantPool, int index, DataTypeManager dtm) {
        ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[index];
        int nameIndex = classInfo.getNameIndex();
        ConstantPoolUtf8Info utf8Info = (ConstantPoolUtf8Info)constantPool[nameIndex];
        DescriptorDecoder.resolveClassForString(utf8Info.getString(), dtm, (DataType)DWordDataType.dataType);
    }

    private void recordJavaVersionInfo(Program program, ClassFileJava classFile) {
        Options programInfo = program.getOptions("Program Information");
        programInfo.setInt("Major Version", (int)classFile.getMajorVersion());
        programInfo.setInt("Minor Version", (int)classFile.getMinorVersion());
        programInfo.setString("Java Version", switch (classFile.getMajorVersion()) {
            case 45 -> "1.1";
            case 46 -> "1.2";
            case 47 -> "1.3";
            case 48 -> "1.4";
            case 49 -> "1.5";
            case 50 -> "1.6";
            case 51 -> "1.7";
            case 52 -> "1.8";
            case 53 -> "9";
            case 54 -> "10";
            case 55 -> "11";
            case 56 -> "12";
            case 57 -> "13";
            default -> "Unknown";
        });
    }

    private void markupConstantPoolAndReferences(Program program, ClassFileJava classFile, Data constantPoolData, TaskMonitor monitor) {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        Map<Integer, Integer> indexMap = this.getIndexMap(constantPool);
        for (int i = 1; i < constantPool.length; ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            AbstractConstantPoolInfoJava constantPoolInfo = constantPool[i];
            BootstrapMethods[] bootstrapMethods = this.getBootStrapMethodAttribute(classFile, constantPool, indexMap);
            this.createConstantPoolReference(constantPoolData, constantPoolInfo, bootstrapMethods, indexMap, i);
        }
    }

    private BootstrapMethods[] getBootStrapMethodAttribute(ClassFileJava classFile, AbstractConstantPoolInfoJava[] constantPool, Map<Integer, Integer> indexMap) {
        AbstractAttributeInfo[] attributes;
        for (AbstractAttributeInfo attribute : attributes = classFile.getAttributes()) {
            String name;
            int nameIndex = attribute.getAttributeNameIndex();
            AbstractConstantPoolInfoJava poolEntry = classFile.getConstantPool()[nameIndex];
            if (!(poolEntry instanceof ConstantPoolUtf8Info) || !(name = ((ConstantPoolUtf8Info)poolEntry).getString()).equals("BootstrapMethods")) continue;
            return ((BootstrapMethodsAttribute)attribute).getBootstrapMethods();
        }
        return null;
    }

    private void createConstantPoolReference(Data constantPoolData, AbstractConstantPoolInfoJava constantPoolInfo, BootstrapMethods[] bootstrapMethods, Map<Integer, Integer> indexMap, int i) {
        Data data;
        Data indexData;
        Object indexValue;
        if (constantPoolInfo instanceof ConstantPoolClassInfo || constantPoolInfo instanceof ConstantPoolStringInfo || constantPoolInfo instanceof ConstantPoolMethodTypeInfo) {
            Data data2 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData2 = data2.getComponent(1);
            Object indexValue2 = indexData2.getValue();
            if (indexValue2 instanceof Scalar) {
                int index = (int)(((Scalar)indexValue2).getValue() & 0xFFFFL);
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData2.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolFieldReferenceInfo || constantPoolInfo instanceof ConstantPoolMethodReferenceInfo || constantPoolInfo instanceof ConstantPoolInterfaceMethodReferenceInfo || constantPoolInfo instanceof ConstantPoolNameAndTypeInfo) {
            Data referredData;
            int index;
            Data data3 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData3 = data3.getComponent(1);
            Object indexValue3 = indexData3.getValue();
            if (indexValue3 instanceof Scalar) {
                index = (int)(((Scalar)indexValue3).getValue() & 0xFFFFL);
                referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData3.addValueReference(referredData.getAddress(), RefType.DATA);
            }
            if ((indexValue3 = (indexData3 = data3.getComponent(2)).getValue()) instanceof Scalar) {
                index = (int)(((Scalar)indexValue3).getValue() & 0xFFFFL);
                referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData3.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolInvokeDynamicInfo) {
            int index;
            Data data4 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData4 = data4.getComponent(1);
            Object indexValue4 = indexData4.getValue();
            if (indexValue4 instanceof Scalar) {
                index = (int)(((Scalar)indexValue4).getValue() & 0xFFFFL);
                BootstrapMethods bootstrapMethod = bootstrapMethods[index];
                index = bootstrapMethod.getBootstrapMethodsReference() & 0xFFFF;
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData4.addValueReference(referredData.getAddress(), RefType.DATA);
            }
            if ((indexValue4 = (indexData4 = data4.getComponent(2)).getValue()) instanceof Scalar) {
                index = (int)(((Scalar)indexValue4).getValue() & 0xFFFFL);
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData4.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolMethodHandleInfo && (indexValue = (indexData = (data = constantPoolData.getComponent(indexMap.get(i).intValue())).getComponent(2)).getValue()) instanceof Scalar) {
            int index = (int)(((Scalar)indexValue).getValue() & 0xFFFFL);
            Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
            indexData.addValueReference(referredData.getAddress(), RefType.DATA);
        }
    }

    private Map<Integer, Integer> getIndexMap(AbstractConstantPoolInfoJava[] constantPool) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        int offset = 1;
        for (int i = 1; i < constantPool.length; ++i) {
            indexMap.put(i, i - offset);
            if (!(constantPool[i] instanceof ConstantPoolLongInfo) && !(constantPool[i] instanceof ConstantPoolDoubleInfo)) continue;
            ++offset;
        }
        return indexMap;
    }

    private void processInstructions(Program program, Data constantPoolData, ClassFileJava classFile, TaskMonitor monitor) throws CancelledException {
        InstructionIterator instructionIt = program.getListing().getInstructions(this.toAddr(program, 65536L), true);
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        Map<Integer, Integer> indexMap = this.getIndexMap(constantPool);
        BootstrapMethods[] bootstrapMethods = this.getBootStrapMethodAttribute(classFile, constantPool, indexMap);
        for (Instruction instruction : instructionIt) {
            monitor.checkCancelled();
            if (!this.hasConstantPoolReference(instruction.getMnemonicString())) continue;
            if (instruction.getMnemonicString().equals("invokedynamic")) {
                this.addInvokeDynamicComments(program, constantPool, indexMap, bootstrapMethods, instruction);
            }
            int index = (int)(instruction.getScalar(0).getValue() & 0xFFFFFFFFFFFFFFFFL);
            Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
            instruction.addOperandReference(0, referredData.getAddress(), RefType.DATA, SourceType.ANALYSIS);
            CompoundCmd cmd = new CompoundCmd("Add constant pool reference");
            String constantPoolLabel = "CPOOL[" + index + "]";
            cmd.add((Command)new AddLabelCmd(referredData.getAddress(), constantPoolLabel, SourceType.ANALYSIS));
            Reference ref = instruction.getOperandReferences(0)[0];
            cmd.add((Command)new AssociateSymbolCmd(ref, constantPoolLabel));
            cmd.applyTo((DomainObject)program);
        }
    }

    private void addInvokeDynamicComments(Program program, AbstractConstantPoolInfoJava[] constantPool, Map<Integer, Integer> indexMap, BootstrapMethods[] bootstrapMethods, Instruction instruction) {
        StringBuffer sb = new StringBuffer("Bootstrap Method: \n");
        Address addr = instruction.getAddress();
        int index = (int)(instruction.getScalar(0).getValue() & 0xFFFFFFFFFFFFFFFFL);
        ConstantPoolInvokeDynamicInfo dynamicInfo = (ConstantPoolInvokeDynamicInfo)constantPool[index];
        int bootstrapIndex = dynamicInfo.getBootstrapMethodAttrIndex();
        this.appendMethodHandleInfo(sb, constantPool, bootstrapMethods[bootstrapIndex].getBootstrapMethodsReference());
        sb.append("\n");
        int argNum = 0;
        for (int i = 0; i < bootstrapMethods[bootstrapIndex].getNumberOfBootstrapArguments(); ++i) {
            sb.append("  static arg " + argNum++ + ": ");
            this.appendLoadableInfo(sb, constantPool, bootstrapMethods[bootstrapIndex].getBootstrapArgumentsEntry(i));
            if (argNum >= bootstrapMethods[bootstrapIndex].getNumberOfBootstrapArguments()) continue;
            sb.append("\n");
        }
        program.getListing().setComment(addr, 3, sb.toString());
    }

    private void appendMethodHandleInfo(StringBuffer sb, AbstractConstantPoolInfoJava[] constantPool, int argIndex) {
        ConstantPoolNameAndTypeInfo nameAndType;
        ConstantPoolClassInfo classRef;
        ConstantPoolUtf8Info utf8;
        ConstantPoolMethodHandleInfo methodHandle = (ConstantPoolMethodHandleInfo)constantPool[argIndex];
        AbstractConstantPoolInfoJava handleRef = constantPool[methodHandle.getReferenceIndex()];
        if (handleRef instanceof ConstantPoolFieldReferenceInfo) {
            ConstantPoolFieldReferenceInfo fieldRef = (ConstantPoolFieldReferenceInfo)handleRef;
            ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[fieldRef.getClassIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
            sb.append(utf8.getString());
            sb.append(".");
            ConstantPoolNameAndTypeInfo ntInfo = (ConstantPoolNameAndTypeInfo)constantPool[fieldRef.getNameAndTypeIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[ntInfo.getNameIndex()];
            sb.append(utf8.getString());
        }
        if (handleRef instanceof ConstantPoolMethodReferenceInfo) {
            ConstantPoolMethodReferenceInfo methodRef = (ConstantPoolMethodReferenceInfo)handleRef;
            classRef = (ConstantPoolClassInfo)constantPool[methodRef.getClassIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[classRef.getNameIndex()];
            sb.append(utf8.getString() + ".");
            nameAndType = (ConstantPoolNameAndTypeInfo)constantPool[methodRef.getNameAndTypeIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[nameAndType.getNameIndex()];
            sb.append(utf8.getString());
        }
        if (handleRef instanceof ConstantPoolInterfaceMethodReferenceInfo) {
            ConstantPoolInterfaceMethodReferenceInfo mrInfo = (ConstantPoolInterfaceMethodReferenceInfo)handleRef;
            classRef = (ConstantPoolClassInfo)constantPool[mrInfo.getClassIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[classRef.getNameIndex()];
            sb.append(utf8.getString() + ".");
            nameAndType = (ConstantPoolNameAndTypeInfo)constantPool[mrInfo.getNameAndTypeIndex()];
            utf8 = (ConstantPoolUtf8Info)constantPool[nameAndType.getNameIndex()];
            sb.append(utf8.getString());
        }
    }

    private void appendLoadableInfo(StringBuffer sb, AbstractConstantPoolInfoJava[] constantPool, int argIndex) {
        AbstractConstantPoolInfoJava cpoolInfo = constantPool[argIndex];
        if (cpoolInfo instanceof ConstantPoolIntegerInfo) {
            ConstantPoolIntegerInfo intInfo = (ConstantPoolIntegerInfo)cpoolInfo;
            sb.append(intInfo.getValue());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolFloatInfo) {
            ConstantPoolFloatInfo floatInfo = (ConstantPoolFloatInfo)cpoolInfo;
            sb.append(floatInfo.getValue());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolLongInfo) {
            ConstantPoolLongInfo longInfo = (ConstantPoolLongInfo)cpoolInfo;
            sb.append(longInfo.getValue());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolDoubleInfo) {
            ConstantPoolDoubleInfo doubleInfo = (ConstantPoolDoubleInfo)cpoolInfo;
            sb.append(doubleInfo.getValue());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolClassInfo) {
            ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)cpoolInfo;
            ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
            sb.append(className.getString());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolStringInfo) {
            ConstantPoolStringInfo stringInfo = (ConstantPoolStringInfo)cpoolInfo;
            ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[stringInfo.getStringIndex()];
            sb.append("\"");
            sb.append(utf8.getString());
            sb.append("\"");
            return;
        }
        if (cpoolInfo instanceof ConstantPoolMethodHandleInfo) {
            this.appendMethodHandleInfo(sb, constantPool, argIndex);
            return;
        }
        if (cpoolInfo instanceof ConstantPoolMethodTypeInfo) {
            ConstantPoolMethodTypeInfo mtInfo = (ConstantPoolMethodTypeInfo)cpoolInfo;
            ConstantPoolUtf8Info descriptor = (ConstantPoolUtf8Info)constantPool[mtInfo.getDescriptorIndex()];
            sb.append(descriptor.getString());
            return;
        }
        if (cpoolInfo instanceof ConstantPoolDynamicInfo) {
            ConstantPoolDynamicInfo dynamicInfo = (ConstantPoolDynamicInfo)cpoolInfo;
            ConstantPoolNameAndTypeInfo ntInfo = (ConstantPoolNameAndTypeInfo)constantPool[dynamicInfo.getNameAndTypeIndex()];
            ConstantPoolUtf8Info name = (ConstantPoolUtf8Info)constantPool[ntInfo.getNameIndex()];
            sb.append(name.getString());
            return;
        }
        Msg.showWarn((Object)this, null, (String)"Unsupported Constant Pool Type", (Object)cpoolInfo.getClass().getName());
    }

    private void markupFields(Program program, ClassFileJava classFile, TaskMonitor monitor) {
        FieldInfoJava[] fields;
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        for (FieldInfoJava fieldInfo : fields = classFile.getFields()) {
            if (monitor.isCancelled()) break;
            ConstantPoolUtf8Info fieldName = (ConstantPoolUtf8Info)constantPool[fieldInfo.getNameIndex()];
            ConstantPoolUtf8Info fieldDescriptor = (ConstantPoolUtf8Info)constantPool[fieldInfo.getDescriptorIndex()];
            Address fieldAddress = this.toCpAddr(program, fieldInfo.getOffset());
            String comment = "FieldName = " + fieldName.getString() + "\nFieldDescriptor = " + fieldDescriptor.getString() + "\n";
            this.setEolComment(program, fieldAddress, comment);
        }
    }

    private void markupMethods(Program program, ClassFileJava classFile, TaskMonitor monitor) {
        MethodInfoJava[] methods;
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        for (MethodInfoJava methodInfo : methods = classFile.getMethods()) {
            LocalVariableTableAttribute localVariableTableAttribute;
            if (monitor.isCancelled()) break;
            ConstantPoolUtf8Info methodName = (ConstantPoolUtf8Info)constantPool[methodInfo.getNameIndex()];
            ConstantPoolUtf8Info methodDescriptor = (ConstantPoolUtf8Info)constantPool[methodInfo.getDescriptorIndex()];
            Address methodAddress = this.toCpAddr(program, methodInfo.getOffset());
            StringBuffer buffer = new StringBuffer();
            buffer.append("MethodName = " + methodName.getString() + "\n");
            buffer.append("MethodDescriptor = " + methodDescriptor.getString() + "\n");
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute != null && (localVariableTableAttribute = codeAttribute.getLocalVariableTableAttribute()) != null) {
                LocalVariableJava[] localVariables = localVariableTableAttribute.getLocalVariables();
                long localVariableTableOffset = localVariableTableAttribute.getOffset();
                int offsetInTable = 8;
                for (LocalVariableJava localVariable : localVariables) {
                    ConstantPoolUtf8Info descriptor = (ConstantPoolUtf8Info)constantPool[localVariable.getDescriptorIndex()];
                    ConstantPoolUtf8Info name = (ConstantPoolUtf8Info)constantPool[localVariable.getNameIndex()];
                    String comment = "local: name = " + name + " type = " + descriptor;
                    buffer.append("\t" + comment + "\n");
                    Address localVariableAddress = this.toCpAddr(program, localVariableTableOffset + (long)offsetInTable);
                    this.setEolComment(program, localVariableAddress, comment);
                    offsetInTable += 10;
                }
            }
            this.setEolComment(program, methodAddress, buffer.toString());
        }
    }

    public String getWorkerName() {
        return this.getName();
    }

    private boolean setEolComment(Program program, Address address, String comment) {
        if (address.getAddressSpace() != program.getAddressFactory().getDefaultAddressSpace()) {
            return false;
        }
        SetCommentCmd cmd = new SetCommentCmd(address, 0, comment);
        return cmd.applyTo((DomainObject)program);
    }

    private void setFunctionInfo(Function function, MethodInfoJava methodInfo, ClassFileJava classFile, DataTypeManager dtManager) throws DuplicateNameException, InvalidInputException {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        String functionName = ((ConstantPoolUtf8Info)constantPool[methodInfo.getNameIndex()]).getString();
        String descriptor = ((ConstantPoolUtf8Info)constantPool[methodInfo.getDescriptorIndex()]).getString();
        List<String> typeNames = DescriptorDecoder.getTypeNameList(descriptor, true, true);
        StringBuilder sb = new StringBuilder();
        sb.append(functionName);
        for (String name : typeNames) {
            sb.append("_");
            sb.append(name);
        }
        function.setName(sb.toString(), SourceType.ANALYSIS);
        function.setCallingConvention("default");
        DataType returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, dtManager);
        function.setReturnType(returnType, SourceType.ANALYSIS);
        ArrayList<ParameterImpl> params = new ArrayList<ParameterImpl>();
        if (!methodInfo.isStatic()) {
            int thisIndex = classFile.getThisClass();
            ConstantPoolClassInfo thisClass = (ConstantPoolClassInfo)constantPool[thisIndex];
            int nameIndex = thisClass.getNameIndex();
            ConstantPoolUtf8Info thisNameInfo = (ConstantPoolUtf8Info)constantPool[nameIndex];
            DataType thisType = DescriptorDecoder.resolveClassForString(thisNameInfo.getString(), dtManager, (DataType)DWordDataType.dataType);
            ParameterImpl thisParam = new ParameterImpl("this", thisType, function.getProgram());
            params.add(thisParam);
        }
        List<DataType> explicitParams = DescriptorDecoder.getDataTypeList(descriptor, dtManager);
        int max = explicitParams.size();
        for (int i = 0; i < max; ++i) {
            ParameterImpl currentParam = new ParameterImpl("param" + Integer.toString(i + 1), explicitParams.get(i), function.getProgram());
            params.add(currentParam);
        }
        MethodParametersAttribute methodParamsAttr = methodInfo.getMethodParameters();
        if (methodParamsAttr != null) {
            int indexAdjust;
            MethodParameters[] methodParams = methodParamsAttr.getMethodParameters();
            int n = indexAdjust = methodInfo.isStatic() ? 0 : 1;
            if (methodParams.length == params.size() - indexAdjust) {
                for (int i = 0; i < methodParams.length; ++i) {
                    int nameIndex = methodParams[i].getNameIndex();
                    if (nameIndex == 0) continue;
                    String name = ((ConstantPoolUtf8Info)constantPool[nameIndex]).getString();
                    ((Variable)params.get(i + indexAdjust)).setName(name, SourceType.ANALYSIS);
                }
            } else {
                Msg.warn((Object)this, (Object)("methodParams/params size mismatch for " + function.getName()));
                Msg.warn((Object)this, (Object)("methodParams: " + methodParams.length + "; params: " + params.size()));
            }
        }
        function.replaceParameters(params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
        this.createAccessFlagComments(function, methodInfo, classFile);
    }

    private void createAccessFlagComments(Function function, MethodInfoJava methodInfo, ClassFileJava classFile) {
        short flags = methodInfo.getAccessFlags();
        StringBuffer sb = new StringBuffer();
        for (MethodsInfoAccessFlags f : MethodsInfoAccessFlags.values()) {
            if ((flags & f.getValue()) == 0) continue;
            sb.append("  " + f.name() + "\n");
        }
        if (!StringUtils.isEmpty((CharSequence)sb)) {
            sb.insert(0, "Flags:\n");
        }
        sb.append("\n");
        sb.append(methodInfo.getMethodSignature(classFile));
        Listing listing = function.getProgram().getListing();
        Address entryPoint = function.getEntryPoint();
        listing.setComment(entryPoint, 3, sb.toString());
    }

    private boolean hasConstantPoolReference(String mnemonic) {
        switch (mnemonic) {
            case "anewarray": 
            case "checkcast": 
            case "getfield": 
            case "getstatic": 
            case "instanceof": 
            case "invokedynamic": 
            case "invokeinterface": 
            case "invokespecial": 
            case "invokestatic": 
            case "invokevirtual": 
            case "multianewarray": 
            case "ldc": 
            case "ldc_w": 
            case "ldc2_w": 
            case "new": 
            case "putfield": 
            case "putstatic": {
                return true;
            }
        }
        return false;
    }
}

