/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class NestMembersAttribute
extends AbstractAttributeInfo {
    private short number_of_classes;
    private short[] classes;

    protected NestMembersAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.number_of_classes = reader.readNextShort();
        this.classes = new short[this.getNumberOfClasses()];
        for (int i = 0; i < this.getNumberOfClasses(); i = (int)((short)(i + 1))) {
            this.classes[i] = reader.readNextShort();
        }
    }

    public int getNumberOfClasses() {
        return this.number_of_classes & 0xFFFF;
    }

    public int getClassesEntry(int i) {
        return this.classes[i] & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("NestMembers_attribute");
        structure.add(WORD, "number_of_classes", null);
        for (int i = 0; i < this.classes.length; ++i) {
            structure.add(WORD, "classes" + i, null);
        }
        return structure;
    }
}

