/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolMethodHandleInfo
extends AbstractConstantPoolInfoJava {
    private byte referenceKind;
    private short referenceIndex;

    public ConstantPoolMethodHandleInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.referenceKind = reader.readNextByte();
        this.referenceIndex = reader.readNextShort();
    }

    public byte getReferenceKind() {
        return this.referenceKind;
    }

    public int getReferenceIndex() {
        return this.referenceIndex & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_MethodHandle_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(BYTE, "reference_kind", null);
        structure.add(WORD, "reference_index", null);
        return structure;
    }
}

