/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.util.PeekableIterator;
import ghidra.util.PeekableIterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class MergeSortingIterator<T>
implements PeekableIterator<T> {
    protected final Comparator<? super T> comparator;
    protected final PriorityQueue<PeekableIterator<? extends T>> queue;

    public static <L, T> MergeSortingIterator<Map.Entry<L, T>> withLabels(Map<L, ? extends Iterator<? extends T>> iterMap, Comparator<T> comparator) {
        List<LabeledIterator> iterators = iterMap.entrySet().stream().map(LabeledIterator::create).toList();
        Comparator<Map.Entry> comp = Comparator.comparing(Map.Entry::getValue, comparator);
        return new MergeSortingIterator<Map.Entry<L, T>>(iterators, comp);
    }

    public MergeSortingIterator(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> comparator) {
        this.comparator = comparator;
        this.queue = new PriorityQueue<PeekableIterator>(Comparator.comparing(PeekableIterator::peek, comparator));
        for (Iterator<T> it : iterators) {
            if (!it.hasNext()) continue;
            this.queue.add(PeekableIterators.castOrWrap(it));
        }
    }

    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    public T next() {
        PeekableIterator<? extends T> it = this.queue.poll();
        if (it == null) {
            return null;
        }
        Object result = it.next();
        if (it.hasNext()) {
            this.queue.add(it);
        }
        return (T)result;
    }

    public T peek() throws NoSuchElementException {
        return (T)this.queue.peek().peek();
    }

    protected static class MyEntry<L, T>
    implements Map.Entry<L, T> {
        final L label;
        T value;

        public MyEntry(L label) {
            this.label = label;
        }

        @Override
        public L getKey() {
            return this.label;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException();
        }
    }

    protected static class LabeledIterator<L, T>
    implements PeekableIterator<Map.Entry<L, T>> {
        protected final PeekableIterator<? extends T> it;
        protected final MyEntry<L, T> entryNext;
        protected final MyEntry<L, T> entryPeek;

        protected static <L, T> LabeledIterator<L, T> create(Map.Entry<L, ? extends Iterator<? extends T>> entry) {
            return new LabeledIterator<L, T>(entry.getKey(), PeekableIterators.castOrWrap(entry.getValue()));
        }

        public LabeledIterator(L label, PeekableIterator<? extends T> it) {
            this.it = it;
            this.entryNext = new MyEntry(label);
            this.entryPeek = new MyEntry(label);
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Map.Entry<L, T> next() {
            this.entryNext.value = this.it.next();
            return this.entryNext;
        }

        public Map.Entry<L, T> peek() throws NoSuchElementException {
            this.entryPeek.value = this.it.peek();
            return this.entryPeek;
        }
    }
}

