/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.CollectionChangeListener;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.datastruct.ObservableCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.collection.AbstractCollectionDecorator;

public class DefaultObservableCollection<E, L extends CollectionChangeListener<? super E>>
extends AbstractCollectionDecorator<E>
implements ObservableCollection<E, L> {
    protected final Object lock = new Object();
    protected final ListenerSet<L> listeners;
    protected final Collection<E> wrapped;
    protected int aggregatorCount = 0;
    protected final ChangeSet changes = new ChangeSet();
    protected CollectionChangeListener<? super E> l;

    protected DefaultObservableCollection(Collection<E> wrapped, Class<L> listenerClass) {
        this.wrapped = wrapped;
        this.listeners = new ListenerSet(listenerClass, true);
        this.l = (CollectionChangeListener)this.listeners.getProxy();
    }

    protected Collection<E> decorated() {
        return this.wrapped;
    }

    @Override
    public void addChangeListener(L listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(L listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> wit;
            E last;
            {
                this.wit = DefaultObservableCollection.this.wrapped.iterator();
                this.last = null;
            }

            @Override
            public boolean hasNext() {
                return this.wit.hasNext();
            }

            @Override
            public E next() {
                this.last = this.wit.next();
                return this.last;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = DefaultObservableCollection.this.lock;
                synchronized (object) {
                    this.wit.remove();
                    DefaultObservableCollection.this.notifyRemoved(this.last);
                }
            }
        };
    }

    @Override
    public boolean add(E e) {
        boolean result = this.wrapped.add(e);
        if (result) {
            this.notifyAdded(e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.wrapped.remove(o);
        if (result) {
            this.notifyRemoved(o);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E e : c) {
            result |= this.add(e);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            result = true;
        }
        return result;
    }

    @Override
    public void clear() {
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    protected void notifyAdded(E e) {
        this.l.elementAdded(e);
    }

    @Override
    public void notifyModified(E e) {
        assert (this.contains(e));
        this.l.elementModified(e);
    }

    protected void notifyRemoved(E e) {
        this.l.elementRemoved(e);
    }

    @Override
    public ObservableCollection.ChangeAggregator aggregateChanges() {
        return new DefaultChangeAggregator();
    }

    protected class ChangeSet
    implements CollectionChangeListener<E> {
        protected final Map<E, Change> changes = new LinkedHashMap();

        protected ChangeSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementAdded(E e) {
            Object object = DefaultObservableCollection.this.lock;
            synchronized (object) {
                this.changes.compute(e, (b, c) -> Change.then(c, Change.ADDED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementModified(E e) {
            Object object = DefaultObservableCollection.this.lock;
            synchronized (object) {
                this.changes.compute(e, (b, c) -> Change.then(c, Change.MODIFIED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementRemoved(E e) {
            Object object = DefaultObservableCollection.this.lock;
            synchronized (object) {
                this.changes.compute(e, (b, c) -> Change.then(c, Change.REMOVED));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fire() {
            Object object = DefaultObservableCollection.this.lock;
            synchronized (object) {
                for (Map.Entry ent : this.changes.entrySet()) {
                    switch (ent.getValue()) {
                        case ADDED: {
                            ((CollectionChangeListener)DefaultObservableCollection.this.listeners.invoke()).elementAdded(ent.getKey());
                            break;
                        }
                        case REMOVED: {
                            ((CollectionChangeListener)DefaultObservableCollection.this.listeners.invoke()).elementRemoved(ent.getKey());
                            break;
                        }
                        case MODIFIED: {
                            ((CollectionChangeListener)DefaultObservableCollection.this.listeners.invoke()).elementModified(ent.getKey());
                        }
                    }
                }
                this.changes.clear();
            }
        }
    }

    protected class DefaultChangeAggregator
    implements ObservableCollection.ChangeAggregator {
        public DefaultChangeAggregator() {
            ++DefaultObservableCollection.this.aggregatorCount;
            DefaultObservableCollection.this.l = DefaultObservableCollection.this.changes;
        }

        @Override
        public void close() {
            if (--DefaultObservableCollection.this.aggregatorCount == 0) {
                DefaultObservableCollection.this.l = (CollectionChangeListener)DefaultObservableCollection.this.listeners.getProxy();
                DefaultObservableCollection.this.changes.fire();
            }
        }
    }

    protected static final class Change
    extends Enum<Change> {
        public static final /* enum */ Change ADDED = new Change();
        public static final /* enum */ Change REMOVED = new Change();
        public static final /* enum */ Change MODIFIED = new Change();
        private static final /* synthetic */ Change[] $VALUES;

        public static Change[] values() {
            return (Change[])$VALUES.clone();
        }

        public static Change valueOf(String name) {
            return Enum.valueOf(Change.class, name);
        }

        /*
         * Enabled aggressive block sorting
         */
        static Change then(Change one, Change two) {
            if (one == null) {
                return two;
            }
            assert (two != null);
            switch (one) {
                case ADDED: {
                    switch (two) {
                        case ADDED: {
                            assert (false);
                            return ADDED;
                        }
                        case MODIFIED: {
                            return ADDED;
                        }
                        case REMOVED: {
                            return null;
                        }
                    }
                }
                case MODIFIED: {
                    switch (two) {
                        case ADDED: {
                            assert (false);
                            return MODIFIED;
                        }
                        case MODIFIED: {
                            return MODIFIED;
                        }
                        case REMOVED: {
                            return REMOVED;
                        }
                    }
                }
                case REMOVED: {
                    switch (two) {
                        case ADDED: {
                            return MODIFIED;
                        }
                        case MODIFIED: {
                            assert (false);
                        }
                        case REMOVED: {
                            if ($assertionsDisabled) throw new AssertionError((Object)"Unreachable");
                            throw new AssertionError();
                        }
                    }
                    throw new AssertionError((Object)"Unreachable");
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }

        private static /* synthetic */ Change[] $values() {
            return new Change[]{ADDED, REMOVED, MODIFIED};
        }

        static {
            $VALUES = Change.$values();
        }
    }
}

