/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.error.DebuggerIllegalArgumentException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.util.CollectionUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import utilities.util.reflection.ReflectionUtilities;

@DebuggerTargetObjectIface(value="Method")
public interface TargetMethod
extends TargetObject {
    public static final String PARAMETERS_ATTRIBUTE_NAME = "_parameters";
    public static final String RETURN_TYPE_ATTRIBUTE_NAME = "_return_type";
    public static final String REDIRECT = "<=";

    public static TargetParameterMap makeParameters(Stream<ParameterDescription<?>> params) {
        return TargetParameterMap.copyOf(params.collect(Collectors.toMap(p -> p.name, p -> p, (a, b) -> {
            throw new IllegalArgumentException("duplicate parameters: " + a + " and " + b);
        }, LinkedHashMap::new)));
    }

    public static TargetParameterMap makeParameters(Collection<ParameterDescription<?>> params) {
        return TargetMethod.makeParameters(params.stream());
    }

    public static TargetParameterMap makeParameters(ParameterDescription<?> ... params) {
        return TargetMethod.makeParameters(Stream.of(params));
    }

    public static Map<String, Object> validateArguments(Map<String, ParameterDescription<?>> parameters, Map<String, ?> arguments, boolean permitExtras) {
        if (!permitExtras && !parameters.keySet().containsAll(arguments.keySet())) {
            TreeSet<String> extraneous = new TreeSet<String>(arguments.keySet());
            extraneous.removeAll(parameters.keySet());
            throw new DebuggerIllegalArgumentException("Extraneous parameters: " + extraneous);
        }
        LinkedHashMap<String, Object> valid = new LinkedHashMap<String, Object>();
        TreeMap<String, CallSite> typeErrors = null;
        TreeSet<String> extraneous = null;
        for (Map.Entry<String, ?> ent : arguments.entrySet()) {
            String name = ent.getKey();
            Object val = ent.getValue();
            ParameterDescription<?> d = parameters.get(name);
            if (d == null && !permitExtras) {
                if (extraneous == null) {
                    extraneous = new TreeSet<String>();
                }
                extraneous.add(name);
                continue;
            }
            if (val != null && !d.type.isAssignableFrom(val.getClass())) {
                if (typeErrors == null) {
                    typeErrors = new TreeMap<String, CallSite>();
                }
                typeErrors.put(name, (CallSite)((Object)("val '" + val + "' is not a " + d.type)));
                continue;
            }
            valid.put(name, val);
        }
        if (typeErrors != null || extraneous != null) {
            StringBuilder sb = new StringBuilder();
            if (typeErrors != null) {
                sb.append("Type mismatches: ");
                sb.append(typeErrors);
            }
            if (extraneous != null) {
                sb.append("Extraneous parameters: ");
                sb.append(extraneous);
            }
            throw new DebuggerIllegalArgumentException(sb.toString());
        }
        return valid;
    }

    public static TargetParameterMap getParameters(TargetObject obj) {
        return obj.getTypedAttributeNowByName(PARAMETERS_ATTRIBUTE_NAME, TargetParameterMap.class, TargetParameterMap.of());
    }

    @TargetAttributeType(name="_parameters", required=true, fixed=true, hidden=true)
    default public TargetParameterMap getParameters() {
        return TargetMethod.getParameters(this);
    }

    @TargetAttributeType(name="_return_type", required=true, fixed=true, hidden=true)
    default public Class<?> getReturnType() {
        return this.getTypedAttributeNowByName(RETURN_TYPE_ATTRIBUTE_NAME, Class.class, Object.class);
    }

    public CompletableFuture<Object> invoke(Map<String, ?> var1);

    public static interface TargetParameterMap
    extends Map<String, ParameterDescription<?>> {
        public static final TargetParameterMap EMPTY = new EmptyTargetParameterMap();

        public static TargetParameterMap of() {
            return EMPTY;
        }

        public static TargetParameterMap copyOf(Map<String, ParameterDescription<?>> map) {
            return new ImmutableTargetParameterMap(map);
        }

        @SafeVarargs
        public static TargetParameterMap ofEntries(Map.Entry<String, ParameterDescription<?>> ... entries) {
            LinkedHashMap ordered = new LinkedHashMap();
            for (Map.Entry<String, ParameterDescription<?>> ent : entries) {
                ordered.put(ent.getKey(), ent.getValue());
            }
            return new ImmutableTargetParameterMap(ordered);
        }

        public static class ImmutableTargetParameterMap
        extends CollectionUtils.AbstractNMap<String, ParameterDescription<?>>
        implements TargetParameterMap {
            public ImmutableTargetParameterMap(Map<String, ParameterDescription<?>> map) {
                super(map);
            }
        }

        public static class EmptyTargetParameterMap
        extends CollectionUtils.AbstractEmptyMap<String, ParameterDescription<?>>
        implements TargetParameterMap {
        }
    }

    public static class ParameterDescription<T> {
        public final Class<T> type;
        public final String name;
        public final T defaultValue;
        public final boolean required;
        public final String display;
        public final String description;
        public final Set<T> choices;

        public static <T> ParameterDescription<T> create(Class<T> type, String name, boolean required, T defaultValue, String display, String description) {
            return new ParameterDescription<T>(type, name, required, defaultValue, display, description, List.of());
        }

        public static <T> ParameterDescription<T> choices(Class<T> type, String name, Collection<T> choices, String display, String description) {
            T defaultValue = choices.iterator().next();
            return new ParameterDescription<T>(type, name, false, defaultValue, display, description, choices);
        }

        public static <T> ParameterDescription<T> choices(Class<T> type, String name, Collection<T> choices, T defaultValue, String display, String description) {
            if (!choices.contains(defaultValue)) {
                throw new IllegalArgumentException("Default must be one of the choices.");
            }
            return new ParameterDescription<T>(type, name, false, defaultValue, display, description, choices);
        }

        protected static boolean isRequired(Class<?> type, Param param) {
            if (!type.isPrimitive()) {
                return param.required();
            }
            if (type == Boolean.TYPE) {
                return !param.defaultBool().specified();
            }
            if (type == Integer.TYPE) {
                return !param.defaultInt().specified();
            }
            if (type == Long.TYPE) {
                return !param.defaultLong().specified();
            }
            if (type == Float.TYPE) {
                return !param.defaultFloat().specified();
            }
            if (type == Double.TYPE) {
                return !param.defaultDouble().specified();
            }
            throw new IllegalArgumentException("Parameter type not allowed: " + type);
        }

        protected static Object getDefault(Param annot) {
            ArrayList defaults = new ArrayList();
            for (Function<Param, Value<?>> df : Param.DEFAULTS) {
                Value<?> value = df.apply(annot);
                if (!value.specified()) continue;
                defaults.add(value.value());
            }
            if (defaults.isEmpty()) {
                return null;
            }
            if (defaults.size() > 1) {
                throw new IllegalArgumentException("Can only specify one default value. Got " + defaults);
            }
            return defaults.get(0);
        }

        protected static <T> T getDefault(Class<T> type, Param annot) {
            Object dv = ParameterDescription.getDefault(annot);
            if (dv == null) {
                return null;
            }
            if (!type.isInstance(dv)) {
                throw new IllegalArgumentException("Type of default does not match that of parameter. Expected type " + type + ". Got (" + dv.getClass() + ")" + dv);
            }
            return type.cast(dv);
        }

        protected static <T> ParameterDescription<T> annotated(Class<T> type, Param annot) {
            boolean required = ParameterDescription.isRequired(type, annot);
            T defaultValue = ParameterDescription.getDefault(type, annot);
            return ParameterDescription.create(type, annot.name(), required, defaultValue, annot.display(), annot.description());
        }

        public static ParameterDescription<?> annotated(Parameter parameter) {
            Param annot = parameter.getAnnotation(Param.class);
            if (annot == null) {
                throw new IllegalArgumentException("Missing @" + Param.class.getSimpleName() + " on " + parameter);
            }
            if (annot.choicesString().specified()) {
                if (parameter.getType() != String.class) {
                    throw new IllegalArgumentException("Can only specify choices for String parameter");
                }
                return ParameterDescription.choices(String.class, annot.name(), List.of(annot.choicesString().value()), annot.display(), annot.description());
            }
            return ParameterDescription.annotated(MethodType.methodType(parameter.getType()).wrap().returnType(), annot);
        }

        private ParameterDescription(Class<T> type, String name, boolean required, T defaultValue, String display, String description, Collection<T> choices) {
            this.type = type;
            this.name = name;
            this.defaultValue = defaultValue;
            this.required = required;
            this.display = display;
            this.description = description;
            this.choices = Set.copyOf(choices);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name, this.defaultValue, this.required, this.display, this.description, this.choices);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParameterDescription)) {
                return false;
            }
            ParameterDescription that = (ParameterDescription)obj;
            if (this.type != that.type) {
                return false;
            }
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.defaultValue, that.defaultValue)) {
                return false;
            }
            if (this.required != that.required) {
                return false;
            }
            if (!Objects.equals(this.display, that.display)) {
                return false;
            }
            if (!Objects.equals(this.description, that.description)) {
                return false;
            }
            return Objects.equals(this.choices, that.choices);
        }

        public T get(Map<String, ?> arguments) {
            if (arguments.containsKey(this.name)) {
                return (T)arguments.get(this.name);
            }
            if (this.required) {
                throw new DebuggerIllegalArgumentException("Missing required parameter '" + this.display + "' (" + this.name + ")");
            }
            return this.defaultValue;
        }

        public void set(Map<String, ? super T> arguments, T value) {
            arguments.put(this.name, value);
        }

        public void adjust(Map<String, ? super T> arguments, Function<T, T> adjuster) {
            arguments.put(this.name, adjuster.apply(arguments.get(this.name)));
        }

        public String toString() {
            return String.format("<ParameterDescription name=%s type=%s default=%s required=%s display='%s' description='%s' choices=%s", this.name, this.type, this.defaultValue, this.required, this.display, this.description, this.choices);
        }
    }

    public static class AnnotatedTargetMethod
    extends DefaultTargetObject<TargetObject, TargetObject>
    implements TargetMethod {
        private final MethodHandle handle;
        private final TargetParameterMap params;

        public static Map<String, AnnotatedTargetMethod> collectExports(MethodHandles.Lookup lookup, AbstractDebuggerObjectModel model, TargetObject parent) {
            HashMap<String, AnnotatedTargetMethod> result = new HashMap<String, AnnotatedTargetMethod>();
            LinkedHashSet allClasses = new LinkedHashSet();
            allClasses.add(parent.getClass());
            allClasses.addAll(ReflectionUtilities.getAllParents(parent.getClass()));
            for (Class clazz : allClasses) {
                for (Method method : clazz.getDeclaredMethods()) {
                    Export annot = method.getAnnotation(Export.class);
                    if (annot == null || result.containsKey(annot.value())) continue;
                    result.put(annot.value(), new AnnotatedTargetMethod(lookup, model, parent, method, annot));
                }
            }
            return result;
        }

        public AnnotatedTargetMethod(MethodHandles.Lookup lookup, AbstractDebuggerObjectModel model, TargetObject parent, Method method, Export annot) {
            super(model, parent, annot.value(), "Method");
            try {
                this.handle = lookup.unreflect(method).bindTo(parent);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Method " + method + " is not accessible");
            }
            this.params = TargetMethod.makeParameters(Stream.of(method.getParameters()).map(ParameterDescription::annotated));
            Map argsCf = TypeUtils.getTypeArguments((Type)method.getGenericReturnType(), CompletableFuture.class);
            Type typeCfT = (Type)argsCf.get(CompletableFuture.class.getTypeParameters()[0]);
            Class returnType = TypeUtils.getRawType((Type)typeCfT, (Type)typeCfT);
            this.changeAttributes(List.of(), Map.ofEntries(Map.entry(TargetMethod.RETURN_TYPE_ATTRIBUTE_NAME, returnType), Map.entry(TargetMethod.PARAMETERS_ATTRIBUTE_NAME, this.params)), "Initialize");
        }

        @Override
        public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
            Map<String, Object> valid = TargetMethod.validateArguments(this.params, arguments, false);
            ArrayList args = new ArrayList(this.params.size());
            for (ParameterDescription p : this.params.values()) {
                args.add(p.get(valid));
            }
            try {
                return (CompletableFuture)this.handle.invokeWithArguments(args);
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        }
    }

    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Param {
        public static final List<Function<Param, Value<?>>> DEFAULTS = List.of(p -> new BoolValue.Val(p.defaultBool()), p -> new IntValue.Val(p.defaultInt()), p -> new LongValue.Val(p.defaultLong()), p -> new FloatValue.Val(p.defaultFloat()), p -> new DoubleValue.Val(p.defaultDouble()), p -> new BytesValue.Val(p.defaultBytes()), p -> new StringValue.Val(p.defaultString()));

        public String name();

        public String display();

        public String description();

        public boolean required() default true;

        public BoolValue defaultBool() default @BoolValue(specified=false, value=false);

        public IntValue defaultInt() default @IntValue(specified=false, value=0);

        public LongValue defaultLong() default @LongValue(specified=false, value=0L);

        public FloatValue defaultFloat() default @FloatValue(specified=false, value=0.0f);

        public DoubleValue defaultDouble() default @DoubleValue(specified=false, value=0.0);

        public BytesValue defaultBytes() default @BytesValue(specified=false, value={});

        public StringValue defaultString() default @StringValue(specified=false, value="");

        public StringsValue choicesString() default @StringsValue(specified=false, value={});
    }

    public static @interface StringsValue {
        public boolean specified() default true;

        public String[] value();

        public record Val(StringsValue v) implements Value<List<String>>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public List<String> value() {
                return List.of(this.v.value());
            }
        }
    }

    public static @interface StringValue {
        public boolean specified() default true;

        public String value();

        public record Val(StringValue v) implements Value<String>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public String value() {
                return this.v.value();
            }
        }
    }

    public static @interface BytesValue {
        public boolean specified() default true;

        public byte[] value();

        public record Val(BytesValue v) implements Value<byte[]>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public byte[] value() {
                return this.v.value();
            }
        }
    }

    public static @interface DoubleValue {
        public boolean specified() default true;

        public double value();

        public record Val(DoubleValue v) implements Value<Double>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public Double value() {
                return this.v.value();
            }
        }
    }

    public static @interface FloatValue {
        public boolean specified() default true;

        public float value();

        public record Val(FloatValue v) implements Value<Float>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public Float value() {
                return Float.valueOf(this.v.value());
            }
        }
    }

    public static @interface LongValue {
        public boolean specified() default true;

        public long value();

        public record Val(LongValue v) implements Value<Long>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public Long value() {
                return this.v.value();
            }
        }
    }

    public static @interface IntValue {
        public boolean specified() default true;

        public int value();

        public record Val(IntValue v) implements Value<Integer>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public Integer value() {
                return this.v.value();
            }
        }
    }

    public static @interface BoolValue {
        public boolean specified() default true;

        public boolean value();

        public record Val(BoolValue v) implements Value<Boolean>
        {
            @Override
            public boolean specified() {
                return this.v.specified();
            }

            @Override
            public Boolean value() {
                return this.v.value();
            }
        }
    }

    public static interface Value<T> {
        public boolean specified();

        public T value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Export {
        public String value();
    }
}

