/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.remote;

import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import java.io.IOException;

public abstract class RemoteFolderItem
implements FolderItem {
    protected final String parentPath;
    protected final String itemName;
    protected final String contentType;
    protected final String fileID;
    protected int version;
    protected long versionTime;
    protected RepositoryAdapter repository;

    RemoteFolderItem(RepositoryAdapter repository, RepositoryItem item) {
        this.repository = repository;
        this.parentPath = item.getParentPath();
        this.itemName = item.getName();
        this.contentType = item.getContentType();
        this.fileID = item.getFileID();
        this.version = item.getVersion();
        this.versionTime = item.getVersionTime();
    }

    abstract int getItemType();

    @Override
    public String getName() {
        return this.itemName;
    }

    @Override
    public RemoteFolderItem refresh() throws IOException {
        RepositoryItem item = this.repository.getItem(this.parentPath, this.itemName);
        if (item == null) {
            return null;
        }
        this.version = item.getVersion();
        this.versionTime = item.getVersionTime();
        return this;
    }

    @Override
    public String getFileID() {
        return this.fileID;
    }

    @Override
    public String resetFileID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public String getPathName() {
        Object path = this.parentPath;
        if (((String)path).length() != 1) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        return (String)path + this.itemName;
    }

    @Override
    public boolean isReadOnly() {
        throw new UnsupportedOperationException("isReadOnly is not applicable to versioned item");
    }

    @Override
    public void setReadOnly(boolean state) {
        throw new UnsupportedOperationException("setReadOnly is not applicable to versioned item");
    }

    @Override
    public int getContentTypeVersion() {
        throw new UnsupportedOperationException("getContentTypeVersion is not applicable to versioned item");
    }

    @Override
    public void setContentTypeVersion(int version) throws IOException {
        throw new UnsupportedOperationException("setContentTypeVersion is not applicable to versioned item");
    }

    @Override
    public long lastModified() {
        return this.versionTime;
    }

    @Override
    public int getCurrentVersion() {
        return this.version;
    }

    @Override
    public boolean isVersioned() {
        return this.version != -1;
    }

    @Override
    public Version[] getVersions() throws IOException {
        return this.repository.getVersions(this.parentPath, this.itemName);
    }

    @Override
    public void delete(int ver, String user) throws IOException {
        this.repository.deleteItem(this.parentPath, this.itemName, ver);
    }

    @Override
    public boolean isCheckedOut() {
        throw new UnsupportedOperationException("isCheckedOut is not applicable to versioned item");
    }

    @Override
    public boolean isCheckedOutExclusive() {
        throw new UnsupportedOperationException("isCheckedOutExclusive is not applicable to versioned item");
    }

    @Override
    public ItemCheckoutStatus checkout(CheckoutType checkoutType, String user, String projectPath) throws IOException {
        return this.repository.checkout(this.parentPath, this.itemName, checkoutType, projectPath);
    }

    @Override
    public void terminateCheckout(long checkoutId, boolean notify) throws IOException {
        this.repository.terminateCheckout(this.parentPath, this.itemName, checkoutId, notify);
    }

    @Override
    public ItemCheckoutStatus getCheckout(long checkoutId) throws IOException {
        return this.repository.getCheckout(this.parentPath, this.itemName, checkoutId);
    }

    @Override
    public ItemCheckoutStatus[] getCheckouts() throws IOException {
        return this.repository.getCheckouts(this.parentPath, this.itemName);
    }

    @Override
    public void clearCheckout() throws IOException {
        throw new UnsupportedOperationException("clearCheckout is not applicable to versioned item");
    }

    @Override
    public long getCheckoutId() throws IOException {
        throw new UnsupportedOperationException("getCheckoutId is not applicable to versioned item");
    }

    @Override
    public int getCheckoutVersion() throws IOException {
        throw new UnsupportedOperationException("getCheckoutVersion is not applicable to versioned item");
    }

    @Override
    public int getLocalCheckoutVersion() {
        throw new UnsupportedOperationException("getLocalCheckoutVersion is not applicable to versioned item");
    }

    @Override
    public void setCheckout(long checkoutId, boolean exclusive, int checkoutVersion, int localVersion) throws IOException {
        throw new UnsupportedOperationException("setCheckout is not applicable to versioned item");
    }
}

