/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.random.SecureRandomFactory;
import ghidra.util.NumericUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public class HashUtilities {
    public static String MD5_ALGORITHM = "MD5";
    public static String SHA256_ALGORITHM = "SHA-256";
    public static final int SALT_LENGTH = 4;
    public static final int MD5_UNSALTED_HASH_LENGTH = 32;
    public static final int MD5_SALTED_HASH_LENGTH = 36;
    public static final int SHA256_UNSALTED_HASH_LENGTH = 64;
    public static final int SHA256_SALTED_HASH_LENGTH = 68;

    static char getRandomLetterOrDigit() {
        int c;
        int val = SecureRandomFactory.getSecureRandom().nextInt() % 62;
        if (val < 0) {
            val = -val;
        }
        if ((c = 48 + val) > 57) {
            c = 65 + (val - 10);
        }
        if (c > 90) {
            c = 97 + (val - 36);
        }
        return (char)c;
    }

    public static char[] getHash(String algorithm, char[] msg) {
        return HashUtilities.getSaltedHash(algorithm, new char[0], msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getSaltedHash(String algorithm, char[] salt, char[] msg) {
        MessageDigest messageDigest = HashUtilities.getMessageDigest(algorithm);
        byte[] msgBytes = new byte[msg.length + salt.length];
        try {
            int i;
            for (i = 0; i < salt.length; ++i) {
                msgBytes[i] = (byte)salt[i];
            }
            for (i = 0; i < msg.length; ++i) {
                msgBytes[i + salt.length] = (byte)msg[i];
            }
            char[] hash = HashUtilities.hexDump(messageDigest.digest(msgBytes));
            char[] saltedHash = new char[hash.length + 4];
            System.arraycopy(salt, 0, saltedHash, 0, salt.length);
            System.arraycopy(hash, 0, saltedHash, salt.length, hash.length);
            char[] cArray = saltedHash;
            return cArray;
        }
        finally {
            Arrays.fill(msgBytes, (byte)0);
        }
    }

    public static char[] getSaltedHash(String algorithm, char[] msg) {
        char[] salt = new char[4];
        for (int i = 0; i < 4; ++i) {
            salt[i] = HashUtilities.getRandomLetterOrDigit();
        }
        return HashUtilities.getSaltedHash(algorithm, salt, msg);
    }

    public static String getHash(String algorithm, InputStream in) throws IOException {
        int cnt;
        MessageDigest messageDigest = HashUtilities.getMessageDigest(algorithm);
        byte[] buf = new byte[16384];
        while ((cnt = in.read(buf)) >= 0) {
            messageDigest.update(buf, 0, cnt);
        }
        return NumericUtilities.convertBytesToString((byte[])messageDigest.digest());
    }

    public static String getHash(String algorithm, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = HashUtilities.getHash(algorithm, in);
            return string;
        }
    }

    public static String getHash(String algorithm, List<String> values) {
        MessageDigest messageDigest = HashUtilities.getMessageDigest(algorithm);
        for (String value : values) {
            if (value == null) continue;
            messageDigest.update(value.getBytes());
        }
        return NumericUtilities.convertBytesToString((byte[])messageDigest.digest());
    }

    public static String getHash(String algorithm, byte[] values) {
        MessageDigest messageDigest = HashUtilities.getMessageDigest(algorithm);
        messageDigest.update(values);
        return NumericUtilities.convertBytesToString((byte[])messageDigest.digest());
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Algorithm not supported: " + algorithm);
        }
    }

    public static char[] hexDump(byte[] data) {
        char[] buf = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            String b = Integer.toHexString(data[i] & 0xFF);
            if (b.length() < 2) {
                buf[i * 2 + 0] = 48;
                buf[i * 2 + 1] = b.charAt(0);
                continue;
            }
            buf[i * 2 + 0] = b.charAt(0);
            buf[i * 2 + 1] = b.charAt(1);
        }
        return buf;
    }
}

