/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.listing.VariousChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.merge.util.MergeUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.ProgramProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotYetImplementedException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class CodeUnitMerger
extends AbstractListingMerger {
    static final String CODE_UNITS_PHASE = "Bytes & Code Units";
    private Address min;
    private Address max;
    private VariousChoicesPanel conflictPanel;
    private int conflictChoice = 0;
    AddressSetView latestCUSet;
    AddressSetView myCUSet;
    AddressSetView bothChangedCUSet;
    AddressSetView latestByteSet;
    AddressSetView myByteSet;
    AddressSet resultUninitSet;
    AddressSet conflictBytes;
    AddressSet conflictCodeUnits;
    AddressSet conflictByteCU;
    AddressSet conflictCUByte;
    AddressSet conflictByteEquate;
    AddressSet conflictEquateByte;
    AddressSet conflictEquateCU;
    AddressSet conflictCUEquate;
    AddressSet conflictRefCU;
    AddressSet conflictCURef;
    AddressSet conflictAll;
    AddressRange[] ranges;
    AddressSet manualSet;
    AddressSet autoBytes;
    AddressSet autoCodeUnits;
    private AddressSet mergedCodeUnits;
    AddressSet pickedLatestCodeUnits;
    AddressSet pickedMyCodeUnits;
    AddressSet pickedOriginalCodeUnits;
    ProgramMerge mergeMy;
    ProgramMerge mergeLatest;
    ProgramMerge mergeOriginal;
    private Map<Long, DataType> myResolvedDts;
    private Map<Long, DataType> origResolvedDts;

    CodeUnitMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.autoBytes = new AddressSet();
        this.autoCodeUnits = new AddressSet();
        this.pickedLatestCodeUnits = new AddressSet();
        this.pickedMyCodeUnits = new AddressSet();
        this.pickedOriginalCodeUnits = new AddressSet();
        this.conflictBytes = new AddressSet();
        this.conflictCodeUnits = new AddressSet();
        this.conflictByteCU = new AddressSet();
        this.conflictCUByte = new AddressSet();
        this.conflictByteEquate = new AddressSet();
        this.conflictEquateByte = new AddressSet();
        this.conflictEquateCU = new AddressSet();
        this.conflictCUEquate = new AddressSet();
        this.conflictRefCU = new AddressSet();
        this.conflictCURef = new AddressSet();
        this.resultUninitSet = ProgramMemoryUtil.getAddressSet(this.resultPgm, false);
        this.conflictAll = new AddressSet();
        this.ranges = new AddressRange[0];
        this.manualSet = new AddressSet();
        this.mergeMy = this.listingMergeMgr.mergeMy;
        this.mergeLatest = this.listingMergeMgr.mergeLatest;
        this.mergeOriginal = this.listingMergeMgr.mergeOriginal;
        this.myResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedMyDataTypes");
        this.origResolvedDts = (Map)this.mergeManager.getResolveInformation("ResolvedOriginalDataTypes");
        this.mergedCodeUnits = new AddressSet();
        if (this.mergeManager != null) {
            this.mergeManager.setResolveInformation("ResolvedCodeUnits", this.mergedCodeUnits);
            this.mergeManager.setResolveInformation("PickedLatestCodeUnits", this.pickedLatestCodeUnits);
            this.mergeManager.setResolveInformation("PickedMyCodeUnits", this.pickedMyCodeUnits);
            this.mergeManager.setResolveInformation("PickedOriginalCodeUnits", this.pickedOriginalCodeUnits);
        }
    }

    @Override
    public boolean apply() {
        int selectedChoice = this.getSelectedOption(this.conflictPanel);
        if (this.conflictPanel.getUseForAll()) {
            this.conflictChoice = selectedChoice;
        }
        return super.apply();
    }

    @Override
    public String getConflictType() {
        return "Byte / Code Unit";
    }

    void setConflictDecision(int decision) {
        switch (decision) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                this.conflictOption = decision;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void autoMerge(int progressMin, int progressMax, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging Bytes and Code Units and determining conflicts.", progressMin, progressMax, monitor);
        monitor.setMessage("Setting up Code Unit merge.");
        this.updateProgress(0, "Finding conflicting byte changes...");
        this.getByteSets(monitor);
        this.updateProgress(15, "Finding conflicting code unit changes...");
        this.getCodeUnitSets(monitor);
        this.updateProgress(30, "Finding conflicts between bytes, code units, equates and references...");
        this.getIndirectConflicts(monitor);
        this.conflictAll = new AddressSet((AddressSetView)this.conflictCodeUnits);
        this.conflictAll.add((AddressSetView)this.conflictBytes);
        this.conflictAll.add((AddressSetView)this.conflictByteCU);
        this.conflictAll.add((AddressSetView)this.conflictCUByte);
        this.conflictAll.add((AddressSetView)this.conflictByteEquate);
        this.conflictAll.add((AddressSetView)this.conflictEquateByte);
        this.conflictAll.add((AddressSetView)this.conflictEquateCU);
        this.conflictAll.add((AddressSetView)this.conflictCUEquate);
        this.conflictAll.add((AddressSetView)this.conflictRefCU);
        this.conflictAll.add((AddressSetView)this.conflictCURef);
        this.updateProgress(45, "Aligning conflict ranges...");
        this.ranges = this.getManualMergeRanges(this.conflictAll);
        AddressSet sameCodeUnitChanges = this.bothChangedCUSet.subtract((AddressSetView)this.conflictCodeUnits);
        this.autoCodeUnits = this.myCUSet.subtract((AddressSetView)sameCodeUnitChanges).subtract((AddressSetView)this.manualSet);
        this.autoBytes = this.myByteSet.subtract((AddressSetView)this.manualSet);
        if (monitor.isCancelled()) {
            throw new CancelledException();
        }
        this.updateProgress(60, "Auto-merging byte, code unit, and equate changes...");
        this.performAutoMerge(monitor);
        this.updateProgress(100, "Done auto-merging Bytes and Code Units and determining conflicts.");
    }

    private void getCodeUnitSets(TaskMonitor monitor) throws ProgramConflictException, CancelledException {
        monitor.setMessage("Getting Code Unit change sets.");
        ProgramDiffFilter cuFilter = new ProgramDiffFilter(4);
        this.myCUSet = this.diffOriginalMy.getDifferences(cuFilter, monitor);
        this.myCUSet = SimpleDiffUtility.expandAddressSetToIncludeFullDelaySlots((Program)this.myPgm, (AddressSetView)this.myCUSet);
        this.updateProgress(20);
        this.latestCUSet = this.diffOriginalLatest.getDifferences(cuFilter, monitor);
        this.latestCUSet = SimpleDiffUtility.expandAddressSetToIncludeFullDelaySlots((Program)this.latestPgm, (AddressSetView)this.latestCUSet);
        this.updateProgress(25);
        this.bothChangedCUSet = this.myCUSet.intersect(this.latestCUSet);
        AddressSetView latestMyCUSet = this.diffLatestMy.getTypeDiffs(4, this.bothChangedCUSet, monitor);
        this.conflictCodeUnits = new AddressSet(latestMyCUSet);
    }

    private void getByteSets(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Getting Byte change sets.");
        ProgramDiffFilter byteFilter = new ProgramDiffFilter(2);
        this.myByteSet = this.diffOriginalMy.getDifferences(byteFilter, monitor);
        this.latestByteSet = this.diffOriginalLatest.getDifferences(byteFilter, monitor);
        MergeUtilities.adjustSets(this.latestByteSet, this.myByteSet, this.autoBytes, this.conflictBytes);
        this.conflictBytes = new AddressSet(this.diffLatestMy.getDifferences(byteFilter, monitor));
    }

    private AddressRange[] getManualMergeRanges(AddressSet conflictSet) {
        ArrayList<AddressRangeImpl> list = new ArrayList<AddressRangeImpl>();
        Listing latestListing = this.latestPgm.getListing();
        Listing myListing = this.myPgm.getListing();
        Listing originalListing = this.originalPgm.getListing();
        Listing[] listings = new Listing[]{latestListing, myListing, originalListing};
        AddressRangeIterator iter = conflictSet.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            if (this.manualSet.contains(range.getMinAddress(), range.getMaxAddress())) continue;
            Address nextRangeMin = range.getMinAddress();
            Address finalMax = range.getMaxAddress();
            while (nextRangeMin.compareTo((Object)finalMax) <= 0) {
                Address rangeMin = this.backwardToCommon(listings, nextRangeMin);
                Address rangeMax = this.forwardToCommon(listings, nextRangeMin);
                if (rangeMin == null || rangeMax == null) {
                    throw new RuntimeException("Null rangeMin or rangeMax getting manual merge ranges.");
                }
                nextRangeMin = rangeMax.add(1L);
                AddressRangeImpl addRange = new AddressRangeImpl(rangeMin, rangeMax);
                list.add(addRange);
                this.manualSet.add((AddressRange)addRange);
            }
        }
        return list.toArray(new AddressRange[list.size()]);
    }

    private Address backwardToCommon(Listing[] listings, Address start) {
        CodeUnitIterator iter = listings[0].getCodeUnits(start, false);
        while (iter.hasNext()) {
            boolean matches = true;
            CodeUnit cu = iter.next();
            if (cu instanceof Instruction) {
                Instruction checkInstr = (Instruction)cu;
                while (checkInstr != null && checkInstr.isInDelaySlot() && iter.hasNext()) {
                    cu = iter.next();
                    if (cu instanceof Instruction) {
                        checkInstr = (Instruction)cu;
                        continue;
                    }
                    checkInstr = null;
                }
            }
            Address addr = cu.getMinAddress();
            for (int i = 1; i < listings.length; ++i) {
                Instruction checkInstr;
                CodeUnit checkCU = listings[i].getCodeUnitAt(addr);
                if (checkCU == null) {
                    matches = false;
                    break;
                }
                if (!(checkCU instanceof Instruction) || !(checkInstr = (Instruction)checkCU).isInDelaySlot()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return addr;
        }
        return null;
    }

    private Address forwardToCommon(Listing[] listings, Address start) {
        CodeUnit realCU = listings[0].getCodeUnitContaining(start);
        if (realCU == null) {
            return null;
        }
        Address realStart = realCU.getMinAddress();
        CodeUnitIterator iter = listings[0].getCodeUnits(realStart, true);
        while (iter.hasNext()) {
            CodeUnit checkCU;
            boolean matches = true;
            CodeUnit cu = iter.next();
            Address addr = cu.getMaxAddress();
            if (cu instanceof Instruction) {
                for (int delaySlotDepth = (checkInstr = (Instruction)cu).isInDelaySlot() ? this.computeRemainingDelaySlots(checkInstr) : checkInstr.getDelaySlotDepth(); delaySlotDepth != 0 && iter.hasNext(); --delaySlotDepth) {
                    cu = iter.next();
                    addr = cu.getMaxAddress();
                }
            }
            for (int i = 1; i < listings.length && (checkCU = listings[i].getCodeUnitContaining(addr)) != null; ++i) {
                Instruction checkInstr;
                if (checkCU instanceof Instruction && ((checkInstr = (Instruction)checkCU).isInDelaySlot() || checkInstr.getDelaySlotDepth() != 0)) {
                    checkCU = this.findLastDelaySlot(checkInstr);
                }
                if (checkCU.getMaxAddress().equals((Object)addr)) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return addr;
        }
        return null;
    }

    private int computeRemainingDelaySlots(Instruction instr) {
        if (!instr.isInDelaySlot()) {
            return instr.getDelaySlotDepth();
        }
        int count = 0;
        InstructionIterator iter = instr.getProgram().getListing().getInstructions(instr.getAddress(), false);
        iter.next();
        try {
            while (instr.isInDelaySlot() && iter.hasNext()) {
                Address prevAddr = instr.getMinAddress().subtractNoWrap(1L);
                if (prevAddr.equals((Object)(instr = iter.next()).getMaxAddress())) continue;
                Msg.error((Object)this, (Object)("Missing delay-slotted instruction at " + prevAddr));
                return 0;
            }
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)("Invalid delay-slot instruction at " + instr.getAddress()));
            return 0;
        }
        return instr.getDelaySlotDepth() - count;
    }

    private Instruction findLastDelaySlot(Instruction instr) {
        Instruction lastInstr = instr;
        try {
            while (true) {
                Address nextAddr = lastInstr.getMaxAddress().addNoWrap(1L);
                Instruction checkInstr = instr.getProgram().getListing().getInstructionAt(nextAddr);
                if (checkInstr != null && checkInstr.isInDelaySlot()) {
                    lastInstr = checkInstr;
                    continue;
                }
                break;
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        return lastInstr;
    }

    public void mergeConflicts(ListingMergePanel listingPanel, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        monitor.setMessage("Resolving Code Unit conflicts.");
        boolean askUser = chosenConflictOption == 0;
        int totalConflicts = this.ranges.length;
        monitor.initialize((long)totalConflicts);
        for (int conflictIndex = 0; conflictIndex < totalConflicts; ++conflictIndex) {
            AddressRange range = this.ranges[conflictIndex];
            Address rangeMin = range.getMinAddress();
            Address rangeMax = range.getMaxAddress();
            if (this.conflictChoice != 0) {
                this.merge(rangeMin, rangeMax, chosenConflictOption, monitor);
                continue;
            }
            if (askUser && this.mergeManager != null) {
                this.conflictInfoPanel.setCodeUnitInfo(range, conflictIndex + 1, totalConflicts);
                this.conflictInfoPanel.setConflictInfo(1, 1);
                this.showMergePanel(listingPanel, rangeMin, rangeMax, monitor);
                monitor.checkCancelled();
                chosenConflictOption = this.getSelectedOption(this.conflictPanel);
                monitor.setMaximum((long)totalConflicts);
                monitor.setProgress((long)(conflictIndex + 1));
                continue;
            }
            this.merge(rangeMin, rangeMax, chosenConflictOption, monitor);
        }
    }

    private int getSelectedOption(ConflictPanel conflictPanel2) {
        int option = 0;
        int choice = conflictPanel2.getUseForAllChoice();
        switch (choice) {
            case 1: {
                option = 2;
                break;
            }
            case 2: {
                option = 4;
                break;
            }
            case 4: {
                option = 1;
                break;
            }
            default: {
                option = 0;
            }
        }
        return option;
    }

    private void showMergePanel(final ListingMergePanel listingPanel, final Address minAddress, final Address maxAddress, TaskMonitor monitor) {
        this.min = minAddress;
        this.currentAddress = minAddress;
        this.max = maxAddress;
        this.currentMonitor = monitor;
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ResolveConflictChangeEvent re = (ResolveConflictChangeEvent)e;
                    int choice = re.getChoice();
                    switch (choice) {
                        case 1: {
                            CodeUnitMerger.this.conflictOption = 2;
                            break;
                        }
                        case 2: {
                            CodeUnitMerger.this.conflictOption = 4;
                            break;
                        }
                        case 4: {
                            CodeUnitMerger.this.conflictOption = 1;
                            break;
                        }
                        default: {
                            CodeUnitMerger.this.conflictOption = 0;
                        }
                    }
                    if (CodeUnitMerger.this.conflictOption == 0 || CodeUnitMerger.this.conflictOption == -1) {
                        if (CodeUnitMerger.this.mergeManager != null) {
                            CodeUnitMerger.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (CodeUnitMerger.this.mergeManager != null) {
                        CodeUnitMerger.this.mergeManager.clearStatusText();
                    }
                    try {
                        CodeUnitMerger.this.merge(CodeUnitMerger.this.min, CodeUnitMerger.this.max, CodeUnitMerger.this.conflictOption, CodeUnitMerger.this.currentMonitor);
                    }
                    catch (CancelledException cancelledException) {
                    }
                    catch (MemoryAccessException e1) {
                        Msg.error((Object)this, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
                    }
                    if (CodeUnitMerger.this.mergeManager != null) {
                        CodeUnitMerger.this.mergeManager.setApplyEnabled(true);
                    }
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (CodeUnitMerger.this.conflictPanel != null) {
                        CodeUnitMerger.this.conflictPanel.clear();
                    } else {
                        CodeUnitMerger.this.conflictPanel = new VariousChoicesPanel();
                        CodeUnitMerger.this.currentConflictPanel = CodeUnitMerger.this.conflictPanel;
                        CodeUnitMerger.this.conflictPanel.setTitle("Code Unit");
                    }
                    String text = CodeUnitMerger.this.getConflictString(minAddress, maxAddress);
                    CodeUnitMerger.this.conflictPanel.setHeader(text);
                    String latest = "'Latest' version";
                    String my = "'Checked Out' version";
                    String original = "'Original' version";
                    CodeUnitMerger.this.conflictPanel.addSingleChoice("Use Code Unit From: ", new String[]{latest, my, original}, changeListener);
                    boolean useForAll = CodeUnitMerger.this.conflictChoice != 0;
                    CodeUnitMerger.this.conflictPanel.setUseForAll(useForAll);
                    CodeUnitMerger.this.conflictPanel.setConflictType("Byte / Code Unit");
                    listingPanel.setBottomComponent(CodeUnitMerger.this.conflictPanel);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listingPanel.clearAllBackgrounds();
                    listingPanel.paintAllBackgrounds((AddressSetView)CodeUnitMerger.this.resultAddressFactory.getAddressSet(minAddress, maxAddress));
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (this.mergeManager != null) {
            this.mergeManager.setApplyEnabled(false);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
    }

    protected String getConflictString(Address min2, Address max2) {
        StringBuffer buf = new StringBuffer();
        buf.append("Conflicting code units are defined in 'Latest' and 'Checked Out' from ");
        ConflictUtility.addAddress(buf, min2);
        buf.append(" to ");
        ConflictUtility.addAddress(buf, max2);
        buf.append(".");
        buf.append("<br>");
        StringBuffer conflictBuf = new StringBuffer();
        int count = 0;
        if (this.conflictBytes.intersects(min2, max2)) {
            conflictBuf.append("bytes");
            ++count;
        }
        if (this.conflictCodeUnits.intersects(min2, max2)) {
            conflictBuf.append(this.getConflictPrefix(conflictBuf) + "code units (including any overrides)");
            ++count;
        }
        if (this.conflictByteCU.intersects(min2, max2) || this.conflictCUByte.intersects(min2, max2)) {
            conflictBuf.append(this.getConflictPrefix(conflictBuf) + "byte versus code unit (including any overrides)");
            ++count;
        }
        if (this.conflictByteEquate.intersects(min2, max2) || this.conflictEquateByte.intersects(min2, max2)) {
            conflictBuf.append(this.getConflictPrefix(conflictBuf) + "byte versus equate");
            ++count;
        }
        if (this.conflictEquateCU.intersects(min2, max2) || this.conflictCUEquate.intersects(min2, max2)) {
            conflictBuf.append(this.getConflictPrefix(conflictBuf) + "equate versus code unit (including any overrides)");
            ++count;
        }
        if (this.conflictRefCU.intersects(min2, max2) || this.conflictCURef.intersects(min2, max2)) {
            conflictBuf.append(this.getConflictPrefix(conflictBuf) + "reference versus code unit (including any overrides)");
            ++count;
        }
        if (conflictBuf.length() > 0) {
            buf.append("Conflicting change" + (count > 1 ? "s are" : " is") + ": ");
            buf.append(conflictBuf);
            buf.append(".");
        }
        return buf.toString();
    }

    private String getConflictPrefix(StringBuffer conflictBuffer) {
        return conflictBuffer.length() > 0 ? ", " : "";
    }

    private void performAutoMerge(TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        monitor.setMessage("Merging Code Unit bytes.");
        this.mergeMy.mergeBytes((AddressSetView)this.autoBytes.subtract((AddressSetView)this.resultUninitSet), false, monitor);
        this.mergeManager.updateProgress(70);
        this.totalChanges = 500L;
        this.changeNum = 350L;
        monitor.setMessage("Auto merging Code Units...");
        this.mergeCodeUnits(this.myPgm, (AddressSetView)this.autoCodeUnits, true, monitor);
        this.mergeManager.updateProgress(90);
        monitor.setMessage("Merging Code Unit equates.");
        this.mergeMy.mergeEquates((AddressSetView)this.autoCodeUnits, monitor);
        this.mergeManager.updateProgress(100);
    }

    private void merge(Address minAddress, Address maxAddress, int chosenConflictOption, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        ProgramMerge pm = null;
        switch (chosenConflictOption) {
            case 2: {
                pm = this.mergeLatest;
                break;
            }
            case 4: {
                pm = this.mergeMy;
                break;
            }
            case 1: {
                pm = this.mergeOriginal;
                break;
            }
            default: {
                return;
            }
        }
        this.merge(pm, this.resultAddressFactory.getAddressSet(minAddress, maxAddress), monitor);
    }

    private void merge(ProgramMerge pm, AddressSet addrSet, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        this.mergeCodeUnits(pm.getOriginProgram(), (AddressSetView)addrSet, true, monitor);
        pm.mergeEquates((AddressSetView)addrSet, monitor);
        pm.replaceReferences((AddressSetView)addrSet, monitor);
        monitor.setMessage("Resolving Code Unit conflicts.");
    }

    private void mergeProgramContext(ProgramContext resultContext, ProgramContext originContext, Register register, AddressRange addrRange, TaskMonitor monitor) throws CancelledException {
        try {
            AddressRangeIterator origValueIter = originContext.getRegisterValueAddressRanges(register, addrRange.getMinAddress(), addrRange.getMaxAddress());
            resultContext.remove(addrRange.getMinAddress(), addrRange.getMaxAddress(), register);
            while (origValueIter.hasNext()) {
                monitor.checkCancelled();
                AddressRange valueRange = (AddressRange)origValueIter.next();
                RegisterValue value = originContext.getRegisterValue(register, valueRange.getMinAddress());
                if (value == null || !value.hasAnyValue()) continue;
                resultContext.setRegisterValue(valueRange.getMinAddress(), valueRange.getMaxAddress(), value);
            }
        }
        catch (ContextChangeException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private void mergeCodeUnits(Program fromPgm, AddressSetView addrSet, boolean copyBytes, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        if (addrSet.isEmpty()) {
            return;
        }
        this.adjustCodeUnitPicked(fromPgm, addrSet);
        Listing resultListing = this.resultPgm.getListing();
        ProgramContext originContext = fromPgm.getProgramContext();
        ProgramContext resultContext = this.resultPgm.getProgramContext();
        Register contextReg = originContext.getBaseContextRegister();
        for (AddressRange range : addrSet) {
            resultListing.clearCodeUnits(range.getMinAddress(), range.getMaxAddress(), false);
            if (contextReg == Register.NO_CONTEXT) continue;
            this.mergeProgramContext(resultContext, originContext, originContext.getBaseContextRegister(), range, monitor);
        }
        CodeUnitIterator sourceCodeUnits = fromPgm.getListing().getCodeUnits(addrSet, true);
        long totalAddresses = addrSet.getNumAddresses();
        long granularity = totalAddresses / 100L + 1L;
        int mergeProgress = 0;
        int mergeCount = 0;
        monitor.initialize(totalAddresses);
        while (sourceCodeUnits.hasNext()) {
            monitor.checkCancelled();
            CodeUnit cu = sourceCodeUnits.next();
            if ((long)mergeCount > granularity) {
                monitor.setProgress((long)mergeProgress);
                this.incrementProgress(1);
                mergeCount = 0;
            }
            try {
                if (cu instanceof Instruction) {
                    this.performMergeInstruction((Instruction)cu, true);
                } else if (cu instanceof Data) {
                    this.performMergeData((Data)cu, copyBytes);
                }
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
            int increment = (int)(cu.getMaxAddress().getOffset() - cu.getMinAddress().getOffset() + 1L);
            mergeProgress += increment;
            mergeCount += increment;
        }
    }

    private void adjustCodeUnitPicked(Program fromPgm, AddressSetView addrSet) {
        this.mergedCodeUnits.add(addrSet);
        if (fromPgm == this.latestPgm) {
            this.pickedLatestCodeUnits.add(addrSet);
            this.pickedMyCodeUnits.delete(addrSet);
            this.pickedOriginalCodeUnits.delete(addrSet);
        } else if (fromPgm == this.myPgm) {
            this.pickedLatestCodeUnits.delete(addrSet);
            this.pickedMyCodeUnits.add(addrSet);
            this.pickedOriginalCodeUnits.delete(addrSet);
        } else if (fromPgm == this.originalPgm) {
            this.pickedLatestCodeUnits.delete(addrSet);
            this.pickedMyCodeUnits.delete(addrSet);
            this.pickedOriginalCodeUnits.add(addrSet);
        }
    }

    private void performMergeInstruction(Instruction instruction, boolean copyBytes) throws CodeUnitInsertionException, MemoryAccessException {
        Address minAddress = instruction.getMinAddress();
        Address maxAddress = instruction.isLengthOverridden() ? minAddress.add((long)(instruction.getParsedLength() - 1)) : instruction.getMaxAddress();
        Program fromPgm = instruction.getProgram();
        Listing resultListing = this.resultPgm.getListing();
        if (copyBytes && !this.resultUninitSet.intersects(minAddress, maxAddress)) {
            ProgramMemoryUtil.copyBytesInRanges(this.resultPgm, fromPgm, minAddress, maxAddress);
        }
        int lengthOverride = instruction.isLengthOverridden() ? instruction.getLength() : 0;
        Instruction inst = resultListing.createInstruction(minAddress, instruction.getPrototype(), (MemBuffer)new DumbMemBufferImpl(this.resultPgm.getMemory(), minAddress), (ProcessorContextView)new ProgramProcessorContext(this.resultPgm.getProgramContext(), minAddress), lengthOverride);
        if (instruction.isFallThroughOverridden()) {
            inst.setFallThrough(instruction.getFallThrough());
        }
        if (instruction.getFlowOverride() != FlowOverride.NONE) {
            inst.setFlowOverride(instruction.getFlowOverride());
        }
    }

    private void performMergeData(Data data, boolean copyBytes) throws CodeUnitInsertionException, MemoryAccessException {
        Address minAddress = data.getMinAddress();
        Address maxAddress = data.getMaxAddress();
        Program fromPgm = data.getProgram();
        DataType dt = data.getDataType();
        ProgramBasedDataTypeManager fromDTM = fromPgm.getDataTypeManager();
        long dtID = fromDTM.getID(dt);
        if (!(dt instanceof BuiltInDataType)) {
            dt = dt != DataType.DEFAULT ? this.getResultDataType(dtID, fromPgm) : DataType.DEFAULT;
        }
        boolean hasNewData = false;
        Listing resultListing = this.resultPgm.getListing();
        if (copyBytes && !this.resultUninitSet.intersects(minAddress, maxAddress)) {
            ProgramMemoryUtil.copyBytesInRanges(this.resultPgm, fromPgm, minAddress, maxAddress);
        }
        if (!dt.equals(DataType.DEFAULT)) {
            DataType tmpDt = dt;
            resultListing.createData(minAddress, tmpDt, data.getLength());
            hasNewData = true;
        }
        if (hasNewData) {
            String[] settingNames;
            Data newData = resultListing.getDataAt(minAddress);
            for (String settingName : settingNames = data.getNames()) {
                Object obj = data.getValue(settingName);
                if (obj == null) continue;
                newData.setValue(settingName, obj);
            }
        }
    }

    private DataType getResultDataType(long dtID, Program fromPgm) {
        DataType dt = null;
        if (fromPgm == this.myPgm) {
            DataType origDt;
            dt = this.myResolvedDts.get(dtID);
            if (dt == null && (origDt = this.originalPgm.getDataTypeManager().getDataType(dtID)) != null) {
                dt = this.resultPgm.getDataTypeManager().getDataType(dtID);
            }
        } else if (fromPgm == this.latestPgm) {
            dt = this.resultPgm.getDataTypeManager().getDataType(dtID);
        } else if (fromPgm == this.originalPgm) {
            dt = this.origResolvedDts.get(dtID);
        } else if (fromPgm == this.resultPgm) {
            dt = this.resultPgm.getDataTypeManager().getDataType(dtID);
        }
        if (dt == null) {
            dt = fromPgm.getDataTypeManager().getDataType(dtID);
        }
        return dt;
    }

    private void getIndirectConflicts(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Getting Byte changes.");
        AddressSet onlyMyBytesChanged = this.myByteSet.subtract((AddressSetView)this.conflictBytes);
        AddressSet onlyLatestBytesChanged = this.latestByteSet.subtract((AddressSetView)this.conflictBytes);
        monitor.setMessage("Getting Code Unit changes.");
        AddressSet onlyMyCUsChanged = this.myCUSet.subtract(this.bothChangedCUSet);
        AddressSet onlyLatestCUsChanged = this.latestCUSet.subtract(this.bothChangedCUSet);
        monitor.setMessage("Checking for conflicts between Byte & Code Unit changes.");
        this.conflictCUByte = onlyMyBytesChanged.intersect((AddressSetView)onlyLatestCUsChanged);
        this.conflictCUByte = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictCUByte, this.latestPgm);
        this.conflictByteCU = onlyLatestBytesChanged.intersect((AddressSetView)onlyMyCUsChanged);
        this.conflictByteCU = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictByteCU, this.myPgm);
        this.determineEquateConflicts(monitor, onlyMyBytesChanged, onlyLatestBytesChanged, onlyMyCUsChanged, onlyLatestCUsChanged);
        this.determineReferenceConflicts(monitor, onlyMyCUsChanged, onlyLatestCUsChanged);
    }

    private void determineEquateConflicts(TaskMonitor monitor, AddressSet onlyMyBytesChanged, AddressSet onlyLatestBytesChanged, AddressSet onlyMyCUsChanged, AddressSet onlyLatestCUsChanged) throws CancelledException {
        monitor.setMessage("Getting Equate changes.");
        ProgramDiffFilter equateFilter = new ProgramDiffFilter(512);
        AddressSetView latestEquateDiffs = this.diffOriginalLatest.getDifferences(equateFilter, monitor);
        AddressSetView myEquateDiffs = this.diffOriginalMy.getDifferences(equateFilter, monitor);
        monitor.setMessage("Checking for conflicts between Byte & Equate changes.");
        this.conflictEquateByte = onlyMyBytesChanged.intersect(latestEquateDiffs);
        this.conflictEquateByte = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictEquateByte, this.latestPgm);
        this.conflictByteEquate = onlyLatestBytesChanged.intersect(myEquateDiffs);
        this.conflictByteEquate = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictByteEquate, this.myPgm);
        monitor.setMessage("Checking for conflicts between Code Unit & Equate changes.");
        this.conflictEquateCU = onlyMyCUsChanged.intersect(latestEquateDiffs);
        this.conflictEquateCU = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictEquateCU, this.myPgm);
        this.conflictCUEquate = onlyLatestCUsChanged.intersect(myEquateDiffs);
        this.conflictCUEquate = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictCUEquate, this.latestPgm);
    }

    private void determineReferenceConflicts(TaskMonitor monitor, AddressSet onlyMyCUsChanged, AddressSet onlyLatestCUsChanged) throws CancelledException {
        monitor.setMessage("Getting Reference changes.");
        ProgramDiffFilter referenceFilter = new ProgramDiffFilter(256);
        AddressSetView latestRefDiffs = this.diffOriginalLatest.getDifferences(referenceFilter, monitor);
        AddressSetView myRefDiffs = this.diffOriginalMy.getDifferences(referenceFilter, monitor);
        monitor.setMessage("Checking for conflicts between Code Unit & Reference changes.");
        this.conflictRefCU = onlyMyCUsChanged.intersect(latestRefDiffs);
        this.conflictRefCU = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictRefCU, this.myPgm);
        this.conflictCURef = onlyLatestCUsChanged.intersect(myRefDiffs);
        this.conflictCURef = DiffUtility.getCodeUnitSet((AddressSetView)this.conflictCURef, this.latestPgm);
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.conflictAll.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        return this.hasConflict(addr) ? 1 : 0;
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        throw new NotYetImplementedException("CodeUnitMerger.mergeConflicts(ListingMergePanel listingPanel, Address addr, int conflictOption, TaskMonitor monitor) isn't implemented.");
    }

    @Override
    public AddressSetView getConflicts() {
        return this.conflictAll;
    }
}

