/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AnalysisOptionsUpdater;
import ghidra.app.plugin.core.analysis.rust.RustUtilities;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.DWARFPreconditionException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunctionImporter;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFParser;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProviderFactory;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DWARFAnalyzer
extends AbstractAnalyzer {
    private static final String DWARF_LOADED_OPTION_NAME = "DWARF Loaded";
    private static final String DWARF_ANALYZER_NAME = "DWARF";
    private static final String DWARF_ANALYZER_DESCRIPTION = "Automatically extracts DWARF info from ELF/MachO/PE files.";
    private DWARFImportOptions importOptions = new DWARFImportOptions();
    private long lastTxId = -1L;

    public static boolean isAlreadyImported(Program program) {
        Options options = program.getOptions("Program Information");
        return options.getBoolean(DWARF_LOADED_OPTION_NAME, false) || DWARFAnalyzer.oldCheckIfDWARFImported(program);
    }

    public DWARFAnalyzer() {
        super(DWARF_ANALYZER_NAME, DWARF_ANALYZER_DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        Language language = program.getLanguage();
        return language.getDefaultSpace() == language.getDefaultDataSpace();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        long txId = program.getCurrentTransactionInfo().getID();
        if (txId == this.lastTxId) {
            return true;
        }
        this.lastTxId = txId;
        if (DWARFAnalyzer.isAlreadyImported(program)) {
            Msg.info((Object)this, (Object)"DWARF already imported, skipping.");
            return false;
        }
        DWARFSectionProvider dsp = DWARFSectionProviderFactory.createSectionProviderFor(program, monitor);
        if (dsp == null) {
            Msg.info((Object)this, (Object)"Unable to find DWARF information, skipping DWARF analysis");
            return false;
        }
        if (GoRttiMapper.isGolangProgram(program)) {
            Msg.info((Object)this, (Object)"DWARF: Enabling DIE preload for golang binary");
            this.importOptions.setPreloadAllDIEs(true);
        }
        if (RustUtilities.isRustProgram(program)) {
            Msg.info((Object)this, (Object)"DWARF: Enabling DIE preload for Rust binary");
            this.importOptions.setPreloadAllDIEs(true);
        }
        try {
            try (DWARFProgram prog = new DWARFProgram(program, this.importOptions, monitor, dsp);){
                if (prog.getRegisterMappings() == null && this.importOptions.isImportFuncs()) {
                    log.appendMsg("No DWARF to Ghidra register mappings found for this program's language [" + program.getLanguageID().getIdAsString() + "], function information may be incorrect / incomplete.");
                }
                DWARFParser dp = new DWARFParser(prog, monitor);
                DWARFImportSummary parseResults = dp.parse();
                parseResults.logSummaryResults();
            }
            Options propList = program.getOptions("Program Information");
            propList.setBoolean(DWARF_LOADED_OPTION_NAME, true);
            dsp.updateProgramInfo(program);
            return true;
        }
        catch (CancelledException ce) {
            throw ce;
        }
        catch (DWARFPreconditionException e) {
            log.appendMsg("Skipping DWARF import because a precondition was not met:");
            log.appendMsg(e.getMessage());
            log.appendMsg("Manually re-run the DWARF analyzer after adjusting the options or start it via Dwarf_ExtractorScript");
        }
        catch (DWARFException | IOException e) {
            log.appendMsg("Error during DWARFAnalyzer import: " + e);
            Msg.error((Object)this, (Object)"Error during DWARFAnalyzer import: ", (Throwable)e);
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="10.0")
    private static boolean oldCheckIfDWARFImported(Program prog) {
        return DWARFFunctionImporter.hasDWARFProgModule(prog, DWARF_ANALYZER_NAME);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return DWARFProgram.isDWARF(program);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        this.importOptions.registerOptions(options);
    }

    @Override
    public AnalysisOptionsUpdater getOptionsUpdater() {
        return this.importOptions.getOptionsUpdater();
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.importOptions.optionsChanged(options);
    }
}

