/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.Loaded;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ExternalSymbolResolver;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class ExternalSymbolResolverAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "External Symbol Resolver";
    private static final String DESCRIPTION = "Links unresolved external symbols to the first symbol found in the program's required libraries list (found in program properties).";

    public ExternalSymbolResolverAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before().before());
    }

    @Override
    public boolean canAnalyze(Program program) {
        if (program.getDomainFile().getParent() == null) {
            return false;
        }
        Options options = program.getOptions("Program Information");
        String format = options.getString("Executable Format", null);
        return "Executable and Linking Format (ELF)".equals(format) || "Mac OS X Mach-O".equals(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Object consumer = new Object();
        log = new MessageLog();
        ProjectData projectData = program.getDomainFile().getParent().getProjectData();
        ArrayList<Loaded<Program>> loadedPrograms = new ArrayList<Loaded<Program>>();
        loadedPrograms.add(new Loaded<Program>(program, program.getName(), program.getDomainFile().getParent().getPathname()));
        for (Library extLibrary : ExternalSymbolResolver.getLibrarySearchList(program)) {
            monitor.checkCancelled();
            String libPath = extLibrary.getAssociatedProgramPath();
            if (libPath == null) continue;
            DomainFile libDomainFile = projectData.getFile(libPath);
            if (libDomainFile == null) {
                log.appendMsg("Referenced external program not found: " + libPath);
                continue;
            }
            try {
                DomainObject libDomainObject = libDomainFile.getDomainObject(consumer, false, false, monitor);
                if (libDomainObject instanceof Program) {
                    Program p = (Program)libDomainObject;
                    loadedPrograms.add(new Loaded<Program>(p, libDomainFile.getName(), libDomainFile.getParent().getPathname()));
                    continue;
                }
                libDomainObject.release(consumer);
                log.appendMsg("Referenced external program is not a program: " + libPath);
            }
            catch (IOException e) {
                log.appendMsg("Failed to open library dependency project file: " + libDomainFile.getPathname());
            }
            catch (VersionException e) {
                log.appendMsg("Referenced external program requires updgrade, unable to consider symbols: " + libPath);
            }
        }
        try {
            ExternalSymbolResolver.fixUnresolvedExternalSymbols(loadedPrograms, false, log, monitor);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            for (int i = 1; i < loadedPrograms.size(); ++i) {
                ((Loaded)loadedPrograms.get(i)).release(consumer);
            }
        }
    }
}

