/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.MinGWPseudoRelocationHandler;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.InvalidDataException;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import org.apache.commons.lang3.StringUtils;

public class MingwRelocationAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "MinGW Relocations";
    private static final String DESCRIPTION = "Identify, markup and apply MinGW pseudo-relocations (must be done immediately after import).";

    public MingwRelocationAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.before().before().before().before().before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean canAnalyze(Program program) {
        if (!MinGWPseudoRelocationHandler.isSupportedProgram(program)) {
            return false;
        }
        if (!program.hasExclusiveAccess()) {
            if (!MingwRelocationAnalyzer.alreadyProcessed(program)) {
                Msg.error((Object)this, (Object)("MinGW Relocations analyzer disabled; requires exclusive access to " + program.getDomainFile()));
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        if (MingwRelocationAnalyzer.alreadyProcessed(program)) {
            return true;
        }
        try {
            MinGWPseudoRelocationHandler handler = new MinGWPseudoRelocationHandler(program);
            boolean success = handler.processRelocations(log, monitor);
            MingwRelocationAnalyzer.markAsProcessed(program, handler.listLabelsFound(), success);
        }
        catch (InvalidDataException e) {
            MingwRelocationAnalyzer.markAsNotFound(program);
            log.appendMsg("MinGW Relocations: " + e.getMessage());
            Msg.error((Object)this, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean alreadyProcessed(Program program) {
        Options propList = program.getOptions("Program Information");
        String status = propList.getString(NAME, null);
        return !StringUtils.isBlank((CharSequence)status);
    }

    private static void markAsProcessed(Program program, boolean listLabelsFound, boolean success) {
        Object text;
        Options propList = program.getOptions("Program Information");
        Object object = text = success ? "Applied" : "Failed";
        if (listLabelsFound) {
            text = (String)text + " using labels";
        }
        propList.setString(NAME, (String)text);
    }

    private static void markAsNotFound(Program program) {
        Options propList = program.getOptions("Program Information");
        propList.setString(NAME, "Unsupported");
    }
}

