/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustBackref;
import ghidra.app.plugin.core.analysis.rust.demangler.RustConst;
import ghidra.app.plugin.core.analysis.rust.demangler.RustIdentifier;
import ghidra.app.plugin.core.analysis.rust.demangler.RustLifetime;
import ghidra.app.plugin.core.analysis.rust.demangler.RustPath;
import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;
import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;
import java.util.ArrayList;

class RustType
implements SymbolNode {
    String typeName;
    RustPath path;

    public RustType(String typeName) {
        this.typeName = typeName;
    }

    public RustType(RustPath path) {
        this.path = path;
    }

    public static RustType parse(Symbol s) {
        char c = s.popChar();
        switch (c) {
            case 'a': {
                return new RustType("i8");
            }
            case 'b': {
                return new RustType("bool");
            }
            case 'c': {
                return new RustType("char");
            }
            case 'd': {
                return new RustType("f64");
            }
            case 'e': {
                return new RustType("str");
            }
            case 'f': {
                return new RustType("f32");
            }
            case 'h': {
                return new RustType("u8");
            }
            case 'i': {
                return new RustType("isize");
            }
            case 'j': {
                return new RustType("usize");
            }
            case 'l': {
                return new RustType("i32");
            }
            case 'm': {
                return new RustType("u32");
            }
            case 'n': {
                return new RustType("i128");
            }
            case 'o': {
                return new RustType("u128");
            }
            case 's': {
                return new RustType("i16");
            }
            case 't': {
                return new RustType("u16");
            }
            case 'u': {
                return new RustType("()");
            }
            case 'v': {
                return new RustType("...");
            }
            case 'x': {
                return new RustType("i64");
            }
            case 'y': {
                return new RustType("u64");
            }
            case 'z': {
                return new RustType("!");
            }
            case 'p': {
                return new RustType("_");
            }
        }
        switch (c) {
            case 'A': {
                RustType rustType = RustType.parse(s);
                RustConst constant = RustConst.parse(s);
                return new RustType("[" + rustType.toString() + "; " + constant.toString() + "]");
            }
            case 'S': {
                RustType symbolType = RustType.parse(s);
                return new RustType("[" + ((Object)symbolType).toString() + "]");
            }
            case 'T': {
                ArrayList<String> types = new ArrayList<String>();
                while (s.nextChar() != 'E') {
                    RustType symbolNode = RustType.parse(s);
                    if (symbolNode != null) {
                        types.add(((Object)symbolNode).toString());
                        continue;
                    }
                    return null;
                }
                s.popChar();
                String type = "(" + String.join((CharSequence)", ", types) + ")";
                return new RustType(type);
            }
            case 'R': {
                RustLifetime.parse(s);
                RustType type1 = RustType.parse(s);
                return new RustType("&" + type1);
            }
            case 'Q': {
                RustLifetime.parse(s);
                RustType type2 = RustType.parse(s);
                return new RustType("&mut " + type2);
            }
            case 'P': {
                RustType type3 = RustType.parse(s);
                return new RustType("*const " + type3);
            }
            case 'O': {
                RustType type4 = RustType.parse(s);
                return new RustType("*mut " + type4);
            }
            case 'D': 
            case 'F': {
                String bounds = RustType.parseDynBounds(s);
                RustLifetime.parse(s);
                Object data = "dyn Trait<Assoc = X>";
                if (bounds != null) {
                    data = (String)data + bounds;
                }
                return new RustType((String)data);
            }
            case 'B': {
                s.backChar();
                String b1 = s.parseBackref();
                int b2 = Integer.parseInt(b1);
                RustBackref b3 = new RustBackref(b2, s);
                return new RustType(new RustPath(b3));
            }
        }
        s.backChar();
        RustPath path = RustPath.parse(s);
        return new RustType(path);
    }

    public static String parseDynBounds(Symbol s) {
        ArrayList<String> traits = new ArrayList<String>();
        String binder = RustType.parseBinder(s);
        while (s.nextChar() != 'E') {
            String trait = RustType.parseDynTrait(s);
            traits.add(trait);
        }
        s.popChar();
        return " + " + String.join((CharSequence)" + ", traits);
    }

    public static String parseDynTrait(Symbol s) {
        RustPath path = RustPath.parse(s);
        Object bindings = "";
        while (s.nextChar() == 'p') {
            String binding = RustType.parseDynTraitAssocBinding(s);
            bindings = (String)bindings + binding;
        }
        if (path == null) {
            return "";
        }
        return path.toString();
    }

    public static String parseDynTraitAssocBinding(Symbol s) {
        s.popChar();
        RustIdentifier.parseUndisambiguatedIdentifier(s);
        RustType type = RustType.parse(s);
        return "dyn " + ((Object)type).toString();
    }

    public static String parseBinder(Symbol s) {
        if (s.nextChar() != 'G') {
            return null;
        }
        s.popChar();
        return s.parseBase62Number();
    }

    public String toString() {
        if (this.path != null) {
            return this.path.toString();
        }
        return this.typeName;
    }
}

