/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.StringUtilities;
import javax.swing.JComponent;

public class ProgramAddressRelationshipListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final int MAX_FILENAME_SIZE = 40;
    private static final String NAME = "Address Display";
    private static final String DESCRIPTION = "Shows the relationship between the hovered address and the base of memory and the containing memory block. For addresses in functions, the function offset is also shown; for addresses within a complex data (structure, array, etc.), the offset from the base of that data is shown.";
    private static final int PRIORITY = 20;

    public ProgramAddressRelationshipListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(programLocation instanceof AddressFieldLocation)) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html><table>");
        Address loc = programLocation.getAddress();
        if (this.isInDefaultSpace(program, loc)) {
            long imagebaseOffset = loc.subtract(program.getImageBase());
            ProgramAddressRelationshipListingHover.appendTableRow(sb, "Imagebase Offset", null, imagebaseOffset);
        }
        MemoryBlock block = program.getMemory().getBlock(loc);
        long memblockOffset = loc.subtract(block.getStart());
        ProgramAddressRelationshipListingHover.appendTableRow(sb, "Memory Block Offset", HTMLUtilities.escapeHTML((String)block.getName()), memblockOffset);
        this.addFunctionInfo(program, loc, sb);
        this.addDataInfo(program, loc, sb);
        this.addByteSourceInfo(program, loc, sb);
        return this.createTooltipComponent(sb.toString());
    }

    private boolean isInDefaultSpace(Program p, Address a) {
        AddressFactory factory = p.getAddressFactory();
        AddressSpace defaultSpace = factory.getDefaultAddressSpace();
        return a.getAddressSpace().equals(defaultSpace);
    }

    private void addDataInfo(Program program, Address loc, StringBuilder sb) {
        String name;
        Data data = program.getListing().getDataContaining(loc);
        if (data == null) {
            return;
        }
        long dataOffset = loc.subtract(data.getAddress());
        if (dataOffset == 0L) {
            return;
        }
        String description = "Data Offset";
        if (data.getDataType() instanceof Structure) {
            description = "Structure Offset";
        }
        if ((name = data.getLabel()) == null) {
            name = data.getDataType().getName();
        }
        if ((name = StringUtilities.trimMiddle((String)name, (int)60)) == null) {
            name = HTMLUtilities.italic((String)"Unnamed");
        }
        ProgramAddressRelationshipListingHover.appendTableRow(sb, description, name, dataOffset);
    }

    private void addByteSourceInfo(Program program, Address loc, StringBuilder sb) {
        AddressSourceInfo addressSourceInfo = program.getMemory().getAddressSourceInfo(loc);
        if (addressSourceInfo == null) {
            return;
        }
        if (addressSourceInfo.getFileName() == null) {
            return;
        }
        String filename = StringUtilities.trimMiddle((String)addressSourceInfo.getFileName(), (int)40);
        long fileOffset = addressSourceInfo.getFileOffset();
        String dataDescr = "Byte Source Offset";
        ProgramAddressRelationshipListingHover.appendTableRow(sb, dataDescr, "File: " + filename, fileOffset);
    }

    private void addFunctionInfo(Program program, Address loc, StringBuilder sb) {
        Function function = program.getFunctionManager().getFunctionContaining(loc);
        if (function != null) {
            long functionOffset = loc.subtract(function.getEntryPoint());
            String functionName = function.getName();
            functionName = StringUtilities.trimMiddle((String)functionName, (int)60);
            ProgramAddressRelationshipListingHover.appendTableRow(sb, "Function Offset", HTMLUtilities.escapeHTML((String)functionName), functionOffset);
        }
    }

    private static void appendTableRow(StringBuilder sb, String title, String reference, long offset) {
        sb.append("<tr><td>").append(HTMLUtilities.bold((String)title)).append("</td>");
        sb.append("<td style=\"text-align: right;\">");
        if (reference != null) {
            sb.append(HTMLUtilities.italic((String)reference)).append("&nbsp;");
        }
        sb.append(ProgramAddressRelationshipListingHover.formatOffset(offset));
        sb.append("</td></tr>");
    }

    private static String formatOffset(long offset) {
        return String.format("+%xh", offset);
    }
}

