/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.TaskScheduler;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import docking.widgets.pathmanager.PathnameTablePanel;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.cparser.CParserPlugin;
import ghidra.app.plugin.core.cparser.IncludeFileFinder;
import ghidra.app.plugin.core.processors.SetLanguageDialog;
import ghidra.app.util.cparser.C.CParserUtils;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import resources.Icons;

class ParseDialog
extends ReusableDialogComponentProvider {
    static final String PROFILE_DIR = "parserprofiles";
    private static String FILE_EXTENSION = ".prf";
    private static String CURRENT_PROFILE = "CurrentProfile";
    private static String USER_DEFINED = "IsUserDefined";
    private static String LAST_IMPORT_C_DIRECTORY = "LastImportCDirectory";
    private JPanel mainPanel;
    private CParserPlugin plugin;
    private JButton parseButton;
    private JButton parseToFileButton;
    private PathnameTablePanel pathPanel;
    private JTextArea parseOptionsField;
    protected JComponent languagePanel;
    protected JTextField languageTextField;
    protected JButton languageButton;
    protected String languageIDString = null;
    protected String compilerIDString = null;
    private GhidraComboBox<ComboBoxItem> comboBox;
    private DefaultComboBoxModel<ComboBoxItem> comboModel;
    private DockingAction saveAction;
    private DockingAction saveAsAction;
    private DockingAction clearAction;
    private DockingAction deleteAction;
    private DockingAction refreshAction;
    private DocumentListener docListener;
    private TableModelListener tableListener;
    private ItemListener comboItemListener;
    private TableModel tableModel;
    private PathnameTablePanel includePathPanel;
    private TableModel parsePathTableModel;
    private TableModelListener parsePathTableListener;
    private ArrayList<ComboBoxItem> itemList;
    private ComboBoxItemComparator comparator;
    private ResourceFile parentUserFile;
    private boolean saveAsInProgress;
    private boolean initialBuild = true;
    private boolean userDefined = false;
    private String currentProfileName = null;

    ParseDialog(CParserPlugin plugin) {
        super("Parse C Source", false, true, true, false);
        this.plugin = plugin;
    }

    public void setupForDisplay() {
        if (this.initialBuild) {
            this.itemList = new ArrayList();
            this.comparator = new ComboBoxItemComparator();
            this.addWorkPanel(this.buildMainPanel());
            this.addDismissButton();
            this.createActions();
            this.setActionsEnabled();
            if (this.currentProfileName != null) {
                for (int i = 0; i < this.itemList.size(); ++i) {
                    ComboBoxItem item = this.itemList.get(i);
                    if (this.userDefined != item.isUserDefined || !this.currentProfileName.equals(item.file.getName())) continue;
                    this.comboBox.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.toFront();
        }
    }

    void writeState(SaveState saveState) {
        if (!this.initialBuild) {
            ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
            this.currentProfileName = item.file.getName();
            this.userDefined = item.isUserDefined;
        }
        saveState.putString(CURRENT_PROFILE, this.currentProfileName);
        saveState.putBoolean(USER_DEFINED, this.userDefined);
    }

    void readState(SaveState saveState) {
        this.currentProfileName = saveState.getString(CURRENT_PROFILE, null);
        if (this.currentProfileName != null) {
            this.userDefined = saveState.getBoolean(USER_DEFINED, true);
        }
    }

    void closeProfile() {
        if (this.initialBuild) {
            return;
        }
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isChanged) {
            this.processItemChanged(item);
        }
    }

    protected TaskScheduler getTaskScheduler() {
        return super.getTaskScheduler();
    }

    protected JPanel buildMainPanel() {
        this.initialBuild = true;
        this.mainPanel = new JPanel(new BorderLayout(10, 5));
        this.comboModel = new DefaultComboBoxModel();
        this.populateComboBox();
        this.comboBox = new GhidraComboBox(this.comboModel);
        this.comboItemListener = e -> this.selectionChanged(e);
        this.comboBox.addItemListener(this.comboItemListener);
        JPanel cPanel = new JPanel(new BorderLayout());
        cPanel.setBorder(BorderFactory.createTitledBorder("Parse Configuration"));
        cPanel.add((Component)this.comboBox);
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        comboPanel.add(cPanel);
        this.pathPanel = new PathnameTablePanel(null, true, false, true);
        this.pathPanel.setBorder((Border)BorderFactory.createTitledBorder("Source files to parse"));
        String importDir = Preferences.getProperty((String)LAST_IMPORT_C_DIRECTORY);
        if (importDir == null && (importDir = Preferences.getProperty((String)"LastPathDirectory")) != null) {
            Preferences.setProperty((String)LAST_IMPORT_C_DIRECTORY, (String)importDir);
        }
        this.pathPanel.setFileChooserProperties("Choose Source Files", LAST_IMPORT_C_DIRECTORY, GhidraFileChooserMode.FILES_AND_DIRECTORIES, true, (GhidraFileFilter)new ExtensionFileFilter(new String[]{"h"}, "C Header Files"));
        this.pathPanel.getTable().setDefaultRenderer(String.class, (TableCellRenderer)new GTableCellRenderer(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Object value = data.getValue();
                String pathName = (String)value;
                String string = pathName = pathName == null ? "" : pathName.trim();
                if (pathName.length() == 0 || pathName.startsWith("#")) {
                    return label;
                }
                boolean fileExists = true;
                File file = new File(pathName);
                fileExists = file.exists();
                if (!fileExists) {
                    fileExists = ParseDialog.this.doesFileExist(pathName, fileExists);
                }
                label.setText(pathName.toString());
                if (!fileExists) {
                    label.setForeground(this.getErrorForegroundColor(data.isSelected()));
                }
                return label;
            }
        });
        this.tableListener = e -> {
            ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
            item.isChanged = !this.initialBuild;
            this.setActionsEnabled();
        };
        this.tableModel = this.pathPanel.getTable().getModel();
        this.tableModel.addTableModelListener(this.tableListener);
        this.includePathPanel = new PathnameTablePanel(null, true, false, true);
        this.includePathPanel.setBorder((Border)BorderFactory.createTitledBorder("Include paths"));
        this.includePathPanel.setFileChooserProperties("Choose Source Files", LAST_IMPORT_C_DIRECTORY, GhidraFileChooserMode.FILES_AND_DIRECTORIES, true, (GhidraFileFilter)new ExtensionFileFilter(new String[]{"h"}, "C Header Files"));
        this.parsePathTableListener = e -> {
            ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
            item.isChanged = !this.initialBuild;
            this.setActionsEnabled();
            this.pathPanel.getTable().repaint();
        };
        this.parsePathTableModel = this.includePathPanel.getTable().getModel();
        this.parsePathTableModel.addTableModelListener(this.parsePathTableListener);
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Parse Options"));
        this.parseOptionsField = new JTextArea(5, 70);
        JScrollPane pane = new JScrollPane(this.parseOptionsField);
        pane.getViewport().setPreferredSize(new Dimension(300, 200));
        optionsPanel.add((Component)pane, "Center");
        JPanel archPanel = new JPanel(new BorderLayout());
        archPanel.setBorder(BorderFactory.createTitledBorder("Program Architecture:"));
        archPanel.add((Component)new GLabel(" ", 4));
        this.languagePanel = this.buildLanguagePanel();
        archPanel.add(this.languagePanel);
        this.parseButton = new JButton("Parse to Program");
        this.parseButton.addActionListener(ev -> this.doParse(false));
        this.parseButton.setToolTipText("Parse files and add data types to current program");
        this.addButton(this.parseButton);
        this.parseToFileButton = new JButton("Parse to File...");
        this.parseToFileButton.addActionListener(ev -> this.doParse(true));
        this.parseToFileButton.setToolTipText("Parse files and output to archive file");
        this.addButton(this.parseToFileButton);
        this.mainPanel.add((Component)comboPanel, "North");
        this.includePathPanel.setPreferredSize(new Dimension(this.pathPanel.getPreferredSize().width, 200));
        JSplitPane optionsPane = new JSplitPane(0, (Component)this.includePathPanel, optionsPanel);
        optionsPane.setResizeWeight(0.5);
        this.pathPanel.setPreferredSize(new Dimension(this.pathPanel.getPreferredSize().width, 200));
        JSplitPane outerPane = new JSplitPane(0, (Component)this.pathPanel, optionsPane);
        outerPane.setResizeWeight(0.5);
        this.mainPanel.add((Component)outerPane, "Center");
        this.mainPanel.add((Component)archPanel, "South");
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), "Parse_C_Source"));
        this.loadProfile();
        this.initialBuild = false;
        return this.mainPanel;
    }

    private boolean doesFileExist(String pathName, boolean fileExists) {
        String path;
        File file;
        String[] includePaths;
        String[] stringArray = includePaths = this.includePathPanel.getPaths();
        int n = stringArray.length;
        for (int i = 0; !(i >= n || (file = CParserUtils.getFile(path = stringArray[i], pathName)) != null && (fileExists = file.exists())); ++i) {
        }
        return fileExists;
    }

    private JComponent buildLanguagePanel() {
        this.languageTextField = new JTextField();
        this.languageTextField.setEditable(false);
        this.languageTextField.setFocusable(false);
        this.languageButton = new BrowseButton();
        this.languageButton.addActionListener(e -> {
            SetLanguageDialog dialog = new SetLanguageDialog(this.plugin.getTool(), this.languageIDString, this.compilerIDString, "Select Program Architecture for File DataType Archive");
            LanguageID languageId = dialog.getLanguageDescriptionID();
            CompilerSpecID compilerSpecId = dialog.getCompilerSpecDescriptionID();
            if (languageId == null || compilerSpecId == null) {
                return;
            }
            String newLanguageIDString = languageId.getIdAsString();
            String newCompilerIDString = compilerSpecId.getIdAsString();
            if (!Objects.equals(newLanguageIDString, this.languageIDString) || !Objects.equals(newCompilerIDString, this.compilerIDString)) {
                this.itemChanged();
            }
            this.languageIDString = newLanguageIDString;
            this.compilerIDString = newCompilerIDString;
            this.updateArchitectureDescription();
        });
        this.updateArchitectureDescription();
        this.languageButton.setName("Set Processor Architecture");
        Font font = this.languageButton.getFont();
        this.languageButton.setFont(font.deriveFont(1));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.languageTextField, "Center");
        panel.add((Component)this.languageButton, "East");
        return panel;
    }

    private void updateArchitectureDescription() {
        String newProgramArchitectureSummary = "64/32 (primarily for backward compatibility)";
        if (this.languageIDString != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(this.languageIDString);
            buf.append("  /  ");
            buf.append(this.compilerIDString != null ? this.compilerIDString : "none");
            newProgramArchitectureSummary = buf.toString();
        }
        this.languageTextField.setText(newProgramArchitectureSummary);
    }

    private void selectionChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            ComboBoxItem item = (ComboBoxItem)e.getItem();
            if (item.isChanged && !this.saveAsInProgress && !this.initialBuild) {
                if (item.isUserDefined) {
                    if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Profile?", (String)("Profile " + item.file.getName() + " has changed.\nDo you want to save your changes?"), (String)"Yes", (int)3) == 1) {
                        this.save(item);
                    }
                } else if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Another Profile?", (String)("You have made changes to the default profile " + item.file.getName() + ",\nhowever, updating default profiles is not allowed.\nDo you want to save your changes to another profile?"), (String)"Yes", (int)3) == 1) {
                    this.saveAs(item);
                }
            }
        }
        if (e.getStateChange() == 1) {
            this.loadProfile();
        }
    }

    private void processItemChanged(ComboBoxItem item) {
        if (item.isUserDefined) {
            if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Profile?", (String)("Profile " + item.file.getName() + " has changed.\nDo you want to save your changes?"), (String)"Yes", (int)3) == 1) {
                this.save(item);
            }
        } else if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Save Changes to Another Profile?", (String)("You have made changes to the default profile " + item.file.getName() + ",\nhowever, updating default profiles is not allowed.\nDo you want to save your changes to another profile?"), (String)"Yes", (int)3) == 1) {
            this.saveAs(item);
        }
    }

    private void addDocumentListener() {
        if (this.docListener == null) {
            this.docListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ParseDialog.this.itemChanged();
                }
            };
        }
        this.parseOptionsField.getDocument().addDocumentListener(this.docListener);
    }

    private void itemChanged() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item == null) {
            return;
        }
        item.isChanged = true;
        this.setActionsEnabled();
    }

    private void createActions() {
        this.saveAction = new DockingAction("Save Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.save((ComboBoxItem)ParseDialog.this.comboBox.getSelectedItem());
            }
        };
        this.saveAction.setEnabled(false);
        Icon icon = Icons.SAVE_ICON;
        String saveGroup = "save";
        this.saveAction.setMenuBarData(new MenuData(new String[]{"Save"}, icon, saveGroup));
        this.saveAction.setToolBarData(new ToolBarData(icon, saveGroup));
        this.saveAction.setDescription("Save profile");
        this.addAction((DockingActionIf)this.saveAction);
        this.saveAsAction = new DockingAction("Save Profile As", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.saveAs((ComboBoxItem)ParseDialog.this.comboBox.getSelectedItem());
            }
        };
        this.saveAsAction.setEnabled(true);
        icon = Icons.SAVE_AS_ICON;
        this.saveAsAction.setMenuBarData(new MenuData(new String[]{"Save As..."}, icon, saveGroup));
        this.saveAsAction.setToolBarData(new ToolBarData(icon, saveGroup));
        this.saveAsAction.setDescription("Save profile to new name");
        this.addAction((DockingActionIf)this.saveAsAction);
        this.clearAction = new DockingAction("Clear Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.clear();
            }
        };
        this.clearAction.setEnabled(true);
        icon = Icons.CLEAR_ICON;
        String clearGroup = "clear";
        this.clearAction.setMenuBarData(new MenuData(new String[]{"Clear Profile"}, icon, clearGroup));
        this.clearAction.setToolBarData(new ToolBarData(icon, clearGroup));
        this.clearAction.setDescription("Clear profile");
        this.addAction((DockingActionIf)this.clearAction);
        this.refreshAction = new DockingAction("Refresh User Profiles", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.refresh();
            }
        };
        this.refreshAction.setEnabled(true);
        icon = Icons.REFRESH_ICON;
        String refreshGroup = "refresh";
        this.refreshAction.setMenuBarData(new MenuData(new String[]{"Refresh"}, icon, refreshGroup));
        this.refreshAction.setToolBarData(new ToolBarData(icon, refreshGroup));
        this.refreshAction.setDescription("Refresh list of user profiles");
        this.addAction((DockingActionIf)this.refreshAction);
        this.deleteAction = new DockingAction("Delete Profile", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ParseDialog.this.delete();
            }
        };
        this.deleteAction.setEnabled(false);
        icon = Icons.DELETE_ICON;
        String deleteGroup = "Xdelete";
        this.deleteAction.setMenuBarData(new MenuData(new String[]{"Delete"}, icon, deleteGroup));
        this.deleteAction.setToolBarData(new ToolBarData(icon, deleteGroup));
        this.deleteAction.setDescription("Delete profile");
        this.addAction((DockingActionIf)this.deleteAction);
    }

    private void refresh() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isChanged) {
            this.processItemChanged(item);
        }
        this.comboBox.removeItemListener(this.comboItemListener);
        this.itemList.clear();
        this.comboModel.removeAllElements();
        this.populateComboBox();
        this.comboBox.addItemListener(this.comboItemListener);
        if (this.itemList.contains(item)) {
            this.comboBox.setSelectedItem((Object)item);
        } else {
            this.loadProfile();
        }
    }

    private void clear() {
        this.pathPanel.clear();
        this.parseOptionsField.setText("");
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        item.isChanged = true;
    }

    private void save(ComboBoxItem item) {
        if (!item.isUserDefined) {
            this.saveAs(item);
        } else {
            this.writeProfile(item.file);
            item.isChanged = false;
            this.setActionsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAs(ComboBoxItem item) {
        InputDialog d = new InputDialog("Enter Profile Name", "Profile Name");
        this.plugin.getTool().showDialog((DialogComponentProvider)d, (Component)this.getComponent());
        Object name = d.getValue();
        if (name != null && ((String)name).length() > 0) {
            int index;
            ResourceFile file;
            if (!((String)name).endsWith(FILE_EXTENSION)) {
                name = (String)name + FILE_EXTENSION;
            }
            if ((file = new ResourceFile(this.parentUserFile, (String)name)).equals((Object)item.file)) {
                this.save(item);
                return;
            }
            if (file.exists()) {
                if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Overwrite Existing File?", (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to overwrite it?"), (String)"Yes", (int)3) != 1) {
                    return;
                }
                file.delete();
            }
            this.saveAsInProgress = true;
            ComboBoxItem newItem = new ComboBoxItem(file, true);
            if (this.itemList.contains(newItem)) {
                this.itemList.remove(newItem);
                this.comboModel.removeElement(newItem);
            }
            if ((index = Collections.binarySearch(this.itemList, newItem, this.comparator)) < 0) {
                index = -index - 1;
            }
            this.itemList.add(index, newItem);
            this.writeProfile(newItem.file);
            newItem.isChanged = false;
            item.isChanged = false;
            try {
                this.comboModel.insertElementAt(newItem, index);
                this.comboBox.setSelectedIndex(index);
            }
            finally {
                this.saveAsInProgress = false;
            }
            this.setActionsEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProfile() {
        if (this.docListener != null) {
            this.parseOptionsField.getDocument().removeDocumentListener(this.docListener);
        }
        this.tableModel.removeTableModelListener(this.tableListener);
        this.parsePathTableModel.removeTableModelListener(this.parsePathTableListener);
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        item.isChanged = false;
        StringBuffer sb = new StringBuffer();
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList<String> includeList = new ArrayList<String>();
        String langString = null;
        String compileString = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(item.file.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null && line.trim().length() > 0) {
                line = line.trim();
                pathList.add(line);
            }
            while ((line = br.readLine()) != null && line.trim().length() > 0) {
                line = line.trim();
                sb.append(line + "\n");
            }
            while ((line = br.readLine()) != null && line.trim().length() > 0) {
                line = line.trim();
                includeList.add(line);
            }
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String string = langString = line.length() == 0 ? null : line;
                break;
            }
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                compileString = line.length() == 0 ? null : line;
                break;
            }
            String[] paths = new String[pathList.size()];
            paths = pathList.toArray(paths);
            this.pathPanel.setPaths(paths);
            String[] incpaths = new String[includeList.size()];
            incpaths = includeList.toArray(incpaths);
            this.includePathPanel.setPaths(incpaths);
            this.parseOptionsField.setText(sb.toString());
            this.languageIDString = langString;
            this.compilerIDString = compileString;
            this.updateArchitectureDescription();
            br.close();
        }
        catch (FileNotFoundException e) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"File Not Found", (Object)("Could not find file\n" + item.file.getAbsolutePath()));
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error Loading Profile", (Object)("Exception occurred while reading file\n" + item.file.getAbsolutePath() + ": " + e));
        }
        finally {
            this.addDocumentListener();
            this.tableModel.addTableModelListener(this.tableListener);
            this.parsePathTableModel.addTableModelListener(this.parsePathTableListener);
            this.setActionsEnabled();
        }
    }

    private void writeProfile(ResourceFile outputFile) {
        try {
            String[] includePaths;
            String[] paths;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputFile.getOutputStream()));
            for (String path : paths = this.pathPanel.getPaths()) {
                writer.write(path.trim());
                writer.newLine();
            }
            writer.newLine();
            String optStr = this.parseOptionsField.getText();
            StringTokenizer st = new StringTokenizer(optStr, "\n");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                writer.write(tok);
                writer.newLine();
            }
            writer.newLine();
            for (String path : includePaths = this.includePathPanel.getPaths()) {
                writer.write(path.trim());
                writer.newLine();
            }
            writer.newLine();
            if (this.languageIDString != null) {
                writer.write(this.languageIDString);
            }
            writer.newLine();
            writer.newLine();
            if (this.compilerIDString != null) {
                writer.write(this.compilerIDString);
            }
            writer.newLine();
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error Writing Profile", (Object)("Writing profile " + outputFile.getName() + " failed"), (Throwable)e);
        }
    }

    private void delete() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (item.isUserDefined && OptionDialog.showOptionDialog((Component)this.getComponent(), (String)"Delete Profile?", (String)("Are you sure you want to delete profile " + item.getName()), (String)"Delete", (int)3) == 1) {
            item.file.delete();
            this.itemList.remove(item);
            this.comboModel.removeElement(item);
        }
    }

    private void doParse(boolean parseToFile) {
        this.clearStatusText();
        String options = this.getParseOptions();
        String[] includePaths = this.includePathPanel.getPaths();
        String[] paths = this.pathPanel.getPaths();
        if (paths.length == 0) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.rootPanel, (String)"Source Files Not Specified", (Object)"Please specify source files to parse.");
            return;
        }
        paths = this.expandPaths(paths);
        this.pathPanel.setPaths(paths);
        if (parseToFile) {
            if (this.languageIDString == null || this.compilerIDString == null) {
                Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.rootPanel, (String)"Program Architecture not Specified", (Object)"A Program Architecture must be specified in order to parse to a file.");
                return;
            }
            File file = this.getSaveFile();
            if (file != null) {
                this.plugin.parse(paths, includePaths, options, this.languageIDString, this.compilerIDString, file.getAbsolutePath());
            }
            return;
        }
        this.plugin.parse(paths, includePaths, options);
    }

    private String[] expandPaths(String[] paths) {
        ArrayList<String> list = new ArrayList<String>();
        for (String path : paths) {
            File file = new File(path);
            if (file.isDirectory()) {
                IncludeFileFinder includeFileFinder = new IncludeFileFinder(file);
                try {
                    List<String> includeFileRoots = includeFileFinder.getIncludeFileRoots(true);
                    for (String element : includeFileRoots) {
                        String string = element;
                        if (!string.endsWith(".h")) continue;
                        list.add(string);
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            list.add(path);
        }
        return list.toArray(new String[0]);
    }

    private void populateComboBox() {
        ResourceFile parent = null;
        try {
            parent = Application.getModuleDataSubDirectory((String)PROFILE_DIR);
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)"Couldn't find user parser profile dir: parserprofiles", (Throwable)e);
        }
        this.addToComboModel(parent, false);
        this.parentUserFile = new ResourceFile(this.plugin.getUserProfileDir());
        this.addToComboModel(this.parentUserFile, true);
    }

    private void addToComboModel(ResourceFile parent, boolean isUserDefined) {
        ResourceFile[] children = parent.listFiles();
        List<ResourceFile> sorted = Arrays.asList(children);
        Collections.sort(sorted);
        for (ResourceFile resourceFile : sorted) {
            if (resourceFile.getName().startsWith(".")) continue;
            ComboBoxItem item = new ComboBoxItem(resourceFile, isUserDefined);
            this.comboModel.addElement(item);
            this.itemList.add(item);
        }
    }

    private void setActionsEnabled() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        if (this.saveAction != null) {
            this.saveAction.setEnabled(item.isChanged && item.isUserDefined);
            this.deleteAction.setEnabled(item.isUserDefined);
        }
    }

    private File getSaveFile() {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.rootPanel);
        fileChooser.setTitle("Choose Save Archive File");
        fileChooser.setApproveButtonText("Choose Save Archive File");
        fileChooser.setApproveButtonToolTipText("Choose filename for archive");
        fileChooser.setLastDirectoryPreference("LastExportDirectory");
        File file = fileChooser.getSelectedFile();
        fileChooser.dispose();
        if (file != null) {
            File parent = file.getParentFile();
            if (parent != null) {
                Preferences.setProperty((String)"LastExportDirectory", (String)parent.getAbsolutePath());
            }
            String name = file.getName();
            if (!file.getName().endsWith(".gdt")) {
                file = new File(file.getParentFile(), name + ".gdt");
            }
            if (file.exists()) {
                if (OptionDialog.showOptionDialog((Component)this.rootPanel, (String)"Overwrite Existing File?", (String)("The file " + file.getAbsolutePath() + " already exists.\nDo you want to overwrite it?"), (String)"Yes", (int)3) != 1) {
                    file = null;
                } else {
                    try {
                        PackedDatabase.delete((File)file);
                    }
                    catch (IOException e) {
                        Msg.showError((Object)((Object)this), (Component)this.mainPanel, (String)"Archive Overwrite Failed", (Object)e.getMessage());
                        return null;
                    }
                }
            }
        }
        return file;
    }

    protected void dismissCallback() {
        this.close();
    }

    void setDialogText(String text) {
        this.setStatusText(text);
    }

    public void close() {
        this.cancelCurrentTask();
        super.close();
    }

    public String getParseOptions() {
        return this.parseOptionsField.getText();
    }

    GhidraComboBox<ComboBoxItem> getParseComboBox() {
        return this.comboBox;
    }

    PathnameTablePanel getSourceFiles() {
        return this.pathPanel;
    }

    PathnameTablePanel getIncludePaths() {
        return this.includePathPanel;
    }

    JTextArea getParseOptionsTextField() {
        return this.parseOptionsField;
    }

    JButton getLanguageButton() {
        return this.languageButton;
    }

    JTextField getLanguageText() {
        return this.languageTextField;
    }

    JButton getParseButton() {
        return this.parseButton;
    }

    JButton getParseToFileButton() {
        return this.parseToFileButton;
    }

    ArrayList<ComboBoxItem> getProfiles() {
        return this.itemList;
    }

    ComboBoxItem getCurrentItem() {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        return item;
    }

    ResourceFile getUserProfileParent() {
        return this.parentUserFile;
    }

    private class ComboBoxItemComparator
    implements Comparator<ComboBoxItem> {
        private ComboBoxItemComparator() {
        }

        @Override
        public int compare(ComboBoxItem item1, ComboBoxItem item2) {
            if (item1.isUserDefined == item2.isUserDefined) {
                return item1.getName().compareToIgnoreCase(item2.getName());
            }
            if (!item1.isUserDefined) {
                return -1;
            }
            return 1;
        }
    }

    class ComboBoxItem {
        private ResourceFile file;
        private boolean isUserDefined;
        private boolean isChanged;

        ComboBoxItem(ResourceFile file, boolean isUserDefined) {
            this.file = file;
            this.isUserDefined = isUserDefined;
        }

        public String toString() {
            String name = this.file.getName();
            return name + (this.isUserDefined ? "" : " (Default)");
        }

        public String getName() {
            return this.file.getName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ComboBoxItem item = (ComboBoxItem)obj;
                return this.file.equals((Object)item.file) && this.isUserDefined == item.isUserDefined;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.file, this.isUserDefined);
        }
    }
}

