/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncDialog;
import ghidra.app.plugin.core.datamgr.DataTypeSyncInfo;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DisassociateAction
extends DockingAction {
    public static final String MENU_NAME = "Disassociate Data Types From";
    private final SourceArchive sourceArchive;
    private final DataTypeManager dtm;
    private final DataTypeManagerHandler handler;
    private final DataTypeManagerPlugin plugin;
    private final ArchiveNode archiveNode;

    public DisassociateAction(DataTypeManagerPlugin plugin, DataTypeManagerHandler handler, DataTypeManager dtm, ArchiveNode archiveNode, SourceArchive sourceArchive) {
        super("Disassociate Archive", plugin.getName());
        this.plugin = plugin;
        this.handler = handler;
        this.dtm = dtm;
        this.archiveNode = archiveNode;
        this.sourceArchive = sourceArchive;
        this.setPopupMenuData(new MenuData(new String[]{MENU_NAME, sourceArchive.getName()}));
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Disassociate_Data_Types"));
    }

    private boolean isPreselectedForAction(DataTypeSyncInfo dataTypeSyncInfo) {
        return dataTypeSyncInfo.getSyncState() == DataTypeSyncState.ORPHAN;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DataTypesActionContext;
    }

    public void actionPerformed(ActionContext context) {
        DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(this.handler, this.dtm, this.sourceArchive);
        if (!this.dtm.isUpdatable()) {
            this.showRequiresArchiveOpenMessage(this.dtm.getName());
            return;
        }
        List<DataTypeSyncInfo> allAssociatedTypes = synchronizer.findAssociatedDataTypes();
        if (allAssociatedTypes.isEmpty()) {
            synchronizer.removeSourceArchive();
            this.showNoAssociationsMessage(synchronizer);
            return;
        }
        Set<DataTypeSyncInfo> preselectedInfos = this.getPreselectedInfos(allAssociatedTypes);
        List<DataTypeSyncInfo> typesToDisassociate = this.getSelectedDataTypes(synchronizer, allAssociatedTypes, preselectedInfos);
        if (typesToDisassociate.isEmpty()) {
            return;
        }
        if (!this.confirmOperation(typesToDisassociate)) {
            return;
        }
        MonitoredRunnable r = monitor -> this.doDisassociate(synchronizer, typesToDisassociate, allAssociatedTypes, monitor);
        new TaskBuilder("Disassociate From Archive", r).setStatusTextAlignment(10).launchModal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisassociate(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> typesToDisassociate, List<DataTypeSyncInfo> associatedDataTypes, TaskMonitor monitor) {
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GTreeState treeState = tree.getTreeState();
        tree.collapseAll((GTreeNode)this.archiveNode);
        try {
            this.disassociateTypes(synchronizer, typesToDisassociate, associatedDataTypes, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            tree.restoreTreeState(treeState);
        }
    }

    private void showNoAssociationsMessage(DataTypeSynchronizer synchronizer) {
        String source = synchronizer.getSourceName();
        String client = synchronizer.getClientName();
        Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"No Associations Found", (Object)("No associated datatypes found for archive \"" + source + "\"\nRemoving \"" + source + "\" information from \"" + client + "\"."));
    }

    private Set<DataTypeSyncInfo> getPreselectedInfos(List<DataTypeSyncInfo> all) {
        HashSet<DataTypeSyncInfo> set = new HashSet<DataTypeSyncInfo>();
        for (DataTypeSyncInfo dataTypeSyncInfo : all) {
            if (!this.isPreselectedForAction(dataTypeSyncInfo)) continue;
            set.add(dataTypeSyncInfo);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disassociateTypes(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> typesToDisassociate, List<DataTypeSyncInfo> allAssociatedTypes, TaskMonitor monitor) throws CancelledException {
        synchronizer.openTransactions();
        try {
            monitor.initialize((long)typesToDisassociate.size());
            for (DataTypeSyncInfo info : typesToDisassociate) {
                monitor.checkCancelled();
                monitor.setMessage("Disassociating " + info.getName());
                info.disassociate();
                monitor.incrementProgress(1L);
            }
            if (typesToDisassociate.size() == allAssociatedTypes.size()) {
                synchronizer.removeSourceArchive();
            }
        }
        finally {
            synchronizer.closeTransactions();
        }
    }

    private boolean confirmOperation(List<DataTypeSyncInfo> selectedList) {
        String message = "This will <b>permanently</b> disassociate these datatypes from the archive.<br><br>Are you sure you want to <b><u>disassociate</u></b> " + selectedList.size() + " datatype(s)?";
        String asHtml = HTMLUtilities.wrapAsHTML((String)message);
        int result = OptionDialog.showYesNoDialog((Component)this.plugin.getTool().getToolFrame(), (String)"Confirm Disassociate", (String)asHtml);
        return result == 1;
    }

    private void showRequiresArchiveOpenMessage(String archiveName) {
        Msg.showError(((Object)((Object)this)).getClass(), (Component)this.plugin.getTool().getToolFrame(), (String)"Disassociate Failed", (Object)("Archive \"" + archiveName + "\" must be open for editing."));
    }

    private List<DataTypeSyncInfo> getSelectedDataTypes(DataTypeSynchronizer synchronizer, List<DataTypeSyncInfo> all, Set<DataTypeSyncInfo> preselectedInfos) {
        String clientName = synchronizer.getClientName();
        String sourceName = synchronizer.getSourceName();
        DataTypeSyncDialog dialog = new DataTypeSyncDialog(this.plugin, clientName, sourceName, all, preselectedInfos, "Disassociate", this.getTitle(sourceName, clientName));
        dialog.setHelpLocation(new HelpLocation(this.plugin.getName(), "Disassociate_Data_Types"));
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
        return dialog.getSelectedInfos();
    }

    private String getTitle(String sourceName, String clientName) {
        return "Disassociate Datatype In \"" + clientName + "\" From Archive \"" + sourceName + "\"";
    }

    protected boolean containsConflicts(List<DataTypeSyncInfo> infos) {
        for (DataTypeSyncInfo dataTypeSyncInfo : infos) {
            if (dataTypeSyncInfo.getSyncState() != DataTypeSyncState.CONFLICT) continue;
            return true;
        }
        return false;
    }
}

