/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class AddressTableAnalyzer
extends AbstractAnalyzer {
    private static String DESCRIPTION = "Analyzes undefined data for address tables.";
    private static final String OPTION_NAME_MIN_TABLE_SIZE = "Minimum Table Size";
    private static final String OPTION_NAME_TABLE_ALIGNMENT = "Table Alignment";
    private static final String OPTION_NAME_PTR_ALIGNMENT = "Pointer Alignment";
    private static final String OPTION_NAME_AUTO_LABEL_TABLE = "Auto Label Table";
    private static final String OPTION_NAME_MIN_POINTER_ADDR = "Minimum Pointer Address";
    private static final String OPTION_NAME_MAX_POINTER_DIFF = "Maxmimum Pointer Distance";
    private static final String OPTION_NAME_RELOCATION_GUIDE = "Relocation Table Guide";
    private static final String OPTION_NAME_ALLOW_OFFCUT_REFERENCES = "Allow Offcut References";
    protected static final String OPTION_NAME_CREATE_BOOKMARKS = "Create Analysis Bookmarks";
    private static final String OPTION_DESCRIPTION_CREATE_BOOKMARKS = "If checked, an analysis bookmark will be created at each location where an address table is constructed.";
    private static final boolean OPTION_DEFAULT_CREATE_BOOKMARKS_ENABLED = true;
    private static final String OPTION_DESCRIPTION_MIN_TABLE_SIZE = "The minimum number of consecutive addresses that constitute an address table";
    private static final String OPTION_DESCRIPTION_TABLE_ALIGNMENT = "Only check for tables aligned to this number of bytes.";
    private static final String OPTION_DESCRIPTION_PTR_ALIGNMENT = "Only check for ptr table entries aligned to this number of bytes.";
    private static final String OPTION_DESCRIPTION_AUTO_LABEL_TABLE = "Label the start of the table and each entry as part of the table.";
    private static final String OPTION_DESCRIPTION_MIN_POINTER_ADDR = "Minimum Address that any value is considered a pointer";
    private static final String OPTION_DESCRIPTION_MAX_POINTER_DIFF = "Maximum distance in bytes between pointers before the table is broken up.";
    private static final String OPTION_DESCRIPTION_RELOCATION_GUIDE = "Select this check box to use relocation table entries to guide pointer analysis.";
    private static final String OPTION_DESCRIPTION_ALLOW_OFFCUT_REFERENCES = "Allow table entries that are offcut references to defined data or instructions.";
    private static final int OPTION_DEFAULT_TABLE_ALIGNMENT = 4;
    private static final int OPTION_DEFAULT_PTR_ALIGNMENT = 1;
    private static final boolean OPTION_DEFAULT_AUTO_LABEL_TABLE = false;
    private static final boolean OPTION_DEFAULT_RELOCATION_GUIDE_ENABLED = true;
    private static final boolean OPTION_DEFAULT_ALLOW_OFFCUT_REFERENCES = false;
    private static final int OPTION_DEFAULT_MIN_POINTER_ADDR = 4132;
    private static final int OPTION_DEFAULT_MAX_POINTER_DIFF = 0xFFFFFF;
    private int minimumTableSize = -1;
    private int tableAlignment = 4;
    private int ptrAlignment = 1;
    private boolean autoLabelTable = false;
    private boolean createBookmarksEnabled = true;
    private long minPointerAddress = 4132L;
    private long maxPointerDistance = 0xFFFFFFL;
    private boolean relocationGuideEnabled = true;
    private boolean allowOffcutReferences = false;
    private boolean ignoreBookmarks = false;
    private boolean processorHasLowBitCode = false;

    public AddressTableAnalyzer() {
        super("Create Address Tables", DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before());
        this.setSupportsOneTimeAnalysis();
        this.setDefaultEnablement(false);
    }

    @Override
    public boolean canAnalyze(Program program) {
        int addrSize = program.getAddressFactory().getDefaultAddressSpace().getSize();
        this.processorHasLowBitCode = PseudoDisassembler.hasLowBitCodeModeInAddrValues((Program)program);
        return addrSize == 32 || addrSize == 64;
    }

    @Override
    public boolean added(Program program, AddressSetView addrSet, TaskMonitor monitor, MessageLog log) {
        AddressSet set;
        Address minAddr;
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        if ((addrSet = this.removeNonSearchableMemory(program, addrSet)).isEmpty()) {
            this.ignoreBookmarks = false;
            return true;
        }
        long addrCount = program.getMemory().getNumAddresses();
        monitor.initialize(addrCount);
        monitor.setMessage("Analyze Address Tables");
        addrCount -= addrSet.getNumAddresses();
        Address maxAddr = minAddr = addrSet.getMinAddress();
        AddressIterator addrIter = addrSet.getAddresses(true);
        while (addrIter.hasNext() && !monitor.isCancelled()) {
            ArrayList<Address> validCodeList;
            int tableLen;
            AddressTable tableEntry;
            Address start;
            monitor.setProgress(++addrCount);
            maxAddr = start = addrIter.next();
            if (start.getOffset() % (long)this.tableAlignment != 0L) continue;
            if (addrCount % 2048L == 1L) {
                monitor.setMessage("Analyze Tables " + start);
            }
            if ((tableEntry = AddressTable.getEntry(program, start, monitor, true, this.minimumTableSize, this.ptrAlignment, 0, 1024L, this.relocationGuideEnabled)) == null || (tableLen = this.checkTable(tableEntry, program)) < this.minimumTableSize) continue;
            Bookmark bookmark = program.getBookmarkManager().getBookmark(tableEntry.getTopAddress(), "Analysis", "Address Table");
            if (!this.ignoreBookmarks && bookmark != null) {
                Address nextAddr = start.add((long)tableEntry.getByteLength());
                addrIter = addrSet.getAddresses(nextAddr, true);
                maxAddr = nextAddr;
                continue;
            }
            tableEntry.makeTable(program, 0, tableLen - 1, this.autoLabelTable, false);
            Address startTable = tableEntry.getTopAddress();
            Address endTable = start.add((long)tableEntry.getByteLength());
            mgr.codeDefined((AddressSetView)new AddressSet(startTable, endTable));
            if (this.createBookmarksEnabled) {
                program.getBookmarkManager().setBookmark(tableEntry.getTopAddress(), "Analysis", "Address Table", "Address table[" + tableEntry.getNumberAddressEntries() + "] created");
            }
            if ((validCodeList = tableEntry.getFunctionEntries(program, 0)) != null && validCodeList.size() >= tableEntry.getNumberAddressEntries()) {
                AddressSet validCodeSet = new AddressSet();
                AddressSet validFuncSet = new AddressSet();
                for (Address addr : validCodeList) {
                    PseudoDisassembler.setTargetContextForDisassembly((Program)program, (Address)addr);
                    if (program.getListing().getCodeUnitContaining(addr) != null) continue;
                    validCodeSet.addRange(addr, addr);
                }
                if (!validCodeSet.isEmpty()) {
                    mgr.disassemble((AddressSetView)validCodeSet, AnalysisPriority.DATA_TYPE_PROPOGATION.before());
                }
                if (!validFuncSet.isEmpty()) {
                    // empty if block
                }
            }
            int tableByteLen = tableEntry.getByteLength(0, tableLen - 1, false);
            addrCount += (long)tableByteLen;
            addrIter = this.skipBytes(addrIter, addrSet, start, tableByteLen);
            try {
                maxAddr = maxAddr.addNoWrap((long)(tableByteLen - 1));
            }
            catch (AddressOverflowException addressOverflowException) {}
            break;
        }
        if (!(set = addrSet.subtract((AddressSetView)program.getAddressFactory().getAddressSet(minAddr, maxAddr))).isEmpty()) {
            mgr.scheduleOneTimeAnalysis(this, (AddressSetView)set);
        } else {
            this.ignoreBookmarks = false;
        }
        return true;
    }

    private AddressSetView removeNonSearchableMemory(Program program, AddressSetView addrSet) {
        this.ignoreBookmarks |= addrSet.hasSameAddresses((AddressSetView)program.getMemory());
        addrSet = addrSet.intersect(program.getMemory().getLoadedAndInitializedAddressSet());
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        AddressSet badBlocks = new AddressSet();
        for (MemoryBlock memoryBlock : blocks) {
            if (memoryBlock.isWrite() || memoryBlock.isRead() || memoryBlock.isExecute() || memoryBlock.isVolatile()) continue;
            badBlocks.addRange(memoryBlock.getStart(), memoryBlock.getEnd());
        }
        addrSet = addrSet.subtract((AddressSetView)badBlocks);
        return addrSet;
    }

    private int checkTable(AddressTable tableEntry, Program program) {
        AddressSetView addrSet = tableEntry.getTableBody();
        AddressSet possibleStrings = this.findPossibleStrings(program, addrSet);
        Address start = tableEntry.getTopAddress();
        int tableLen = tableEntry.getNumberAddressEntries();
        Address[] addrs = tableEntry.getTableElements();
        for (int i = 0; i < tableLen; ++i) {
            CodeUnit cu;
            Address tableEntryAddr = start.add((long)(i * 4));
            Address targetAddr = addrs[i];
            if (possibleStrings.contains(tableEntryAddr)) {
                return i;
            }
            if (possibleStrings.contains(tableEntryAddr.add(3L))) {
                return i;
            }
            if (tableEntryAddr.getOffset() > 0L && tableEntryAddr.getOffset() < this.minPointerAddress) {
                return i;
            }
            if (i > 0) {
                long diff = addrs[i - 1].subtract(addrs[i]);
                if ((diff = Math.abs(diff)) > this.maxPointerDistance) {
                    return i;
                }
            }
            if ((cu = program.getListing().getCodeUnitContaining(targetAddr)) == null) continue;
            boolean atStartOfCU = cu.getMinAddress().equals((Object)targetAddr);
            if (this.allowOffcutReferences || atStartOfCU || this.processorHasLowBitCode && cu instanceof Instruction) continue;
            return i;
        }
        return tableLen;
    }

    private AddressSet findPossibleStrings(Program program, AddressSetView addrSet) {
        AddressSet possibleStrSet = new AddressSet();
        Memory memory = program.getMemory();
        AddressIterator addrIter = addrSet.getAddresses(true);
        long maxBytes = addrSet.getNumAddresses();
        MemoryBufferImpl buffer = new MemoryBufferImpl(memory, addrSet.getMinAddress(), (int)(maxBytes > 1024L ? 1024L : maxBytes));
        while (addrIter.hasNext()) {
            Address start = addrIter.next();
            int strLen = this.getWStrLen(buffer, start, (int)(maxBytes / 2L));
            if (strLen <= 4) continue;
            int numBytes = strLen * 2;
            addrIter = this.skipBytes(addrIter, addrSet, start, numBytes);
            possibleStrSet.addRange(start, start.add((long)numBytes));
        }
        return possibleStrSet;
    }

    private AddressIterator skipBytes(AddressIterator iter, AddressSetView addrSet, Address start, int numBytes) {
        try {
            start = start.addNoWrap((long)numBytes);
        }
        catch (AddressOverflowException e) {
            return iter;
        }
        iter = addrSet.getAddresses(start, true);
        return iter;
    }

    private int getWStrLen(MemoryBufferImpl memory, Address ad, int max) {
        int i = 0;
        memory.setPosition(ad);
        try {
            for (i = 0; i < max; ++i) {
                short value = memory.getShort(2 * i);
                if (value == 0) {
                    return i + 1;
                }
                if (value == 9 || value == 10 || value == 13 || value >= 32 && value < 127) continue;
                return i;
            }
        }
        catch (MemoryAccessException e) {
            return i;
        }
        return i;
    }

    @Override
    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        return false;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        if (this.minimumTableSize == -1) {
            this.calculateMinimumTableSize(program);
        }
        return this.minimumTableSize != 0x100000;
    }

    private void calculateMinimumTableSize(Program program) {
        this.minimumTableSize = AddressTable.getThresholdRunOfValidPointers(program, 0x40000000L);
        if (this.minimumTableSize < 2) {
            this.minimumTableSize = 2;
        }
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_MIN_TABLE_SIZE, (Object)this.minimumTableSize, null, OPTION_DESCRIPTION_MIN_TABLE_SIZE);
        options.registerOption(OPTION_NAME_TABLE_ALIGNMENT, (Object)this.tableAlignment, null, OPTION_DESCRIPTION_TABLE_ALIGNMENT);
        options.registerOption(OPTION_NAME_PTR_ALIGNMENT, (Object)this.ptrAlignment, null, OPTION_DESCRIPTION_PTR_ALIGNMENT);
        options.registerOption(OPTION_NAME_AUTO_LABEL_TABLE, (Object)this.autoLabelTable, null, OPTION_DESCRIPTION_AUTO_LABEL_TABLE);
        options.registerOption(OPTION_NAME_RELOCATION_GUIDE, (Object)this.relocationGuideEnabled, null, OPTION_DESCRIPTION_RELOCATION_GUIDE);
        options.registerOption(OPTION_NAME_ALLOW_OFFCUT_REFERENCES, (Object)this.allowOffcutReferences, null, OPTION_DESCRIPTION_ALLOW_OFFCUT_REFERENCES);
        options.registerOption(OPTION_NAME_MIN_POINTER_ADDR, (Object)this.minPointerAddress, null, OPTION_DESCRIPTION_MIN_POINTER_ADDR);
        options.registerOption(OPTION_NAME_MAX_POINTER_DIFF, (Object)this.maxPointerDistance, null, OPTION_DESCRIPTION_MAX_POINTER_DIFF);
        options.registerOption(OPTION_NAME_CREATE_BOOKMARKS, (Object)this.createBookmarksEnabled, null, OPTION_DESCRIPTION_CREATE_BOOKMARKS);
        this.optionsChanged(options, program);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        if (this.minimumTableSize == -1) {
            this.calculateMinimumTableSize(program);
        }
        this.minimumTableSize = options.getInt(OPTION_NAME_MIN_TABLE_SIZE, this.minimumTableSize);
        this.tableAlignment = options.getInt(OPTION_NAME_TABLE_ALIGNMENT, this.tableAlignment);
        this.ptrAlignment = options.getInt(OPTION_NAME_PTR_ALIGNMENT, this.ptrAlignment);
        this.autoLabelTable = options.getBoolean(OPTION_NAME_AUTO_LABEL_TABLE, this.autoLabelTable);
        this.relocationGuideEnabled = options.getBoolean(OPTION_NAME_RELOCATION_GUIDE, this.relocationGuideEnabled);
        this.allowOffcutReferences = options.getBoolean(OPTION_NAME_ALLOW_OFFCUT_REFERENCES, this.allowOffcutReferences);
        this.minPointerAddress = options.getLong(OPTION_NAME_MIN_POINTER_ADDR, this.minPointerAddress);
        this.maxPointerDistance = options.getLong(OPTION_NAME_MAX_POINTER_DIFF, this.maxPointerDistance);
        this.createBookmarksEnabled = options.getBoolean(OPTION_NAME_CREATE_BOOKMARKS, this.createBookmarksEnabled);
    }
}

