/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.ComponentProvider;
import docking.WindowPosition;
import docking.widgets.list.GListCellRenderer;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.GhidraOptions;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.UsrException;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Show Disassembled View", description="This plugin shows the disassembled address at the current ProgramLocation and displays the Instruction.  This work of this plugin is temporary in that it will not change the state of the program.")
public class DisassembledViewPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private static final Color ADDRESS_COLOR = new GColor("color.fg.plugin.disassembledview.address");
    private static final int LOOK_AHEAD_COUNT = 5;
    private DisassembledViewComponentProvider displayComponent = new DisassembledViewComponentProvider();
    private ProgramLocation lastUpdatedLocation;
    private PseudoDisassembler pseudoDisassembler;

    public DisassembledViewPlugin(PluginTool plugintool) {
        super(plugintool);
    }

    protected void init() {
        super.init();
        this.tool.addComponentProvider((ComponentProvider)this.displayComponent, false);
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.displayComponent);
        this.displayComponent.dispose();
        super.dispose();
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.displayComponent.clearContents();
        this.pseudoDisassembler = null;
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (this.displayComponent.isVisible()) {
            this.disassembleLocation(this.currentLocation);
        }
    }

    @Override
    protected void locationChanged(ProgramLocation loc) {
        if (loc == null || loc.equals((Object)this.lastUpdatedLocation) || !this.displayComponent.isVisible()) {
            return;
        }
        this.disassembleLocation(loc);
    }

    private boolean containsMultipleSelection() {
        if (this.currentSelection != null && !this.currentSelection.isEmpty()) {
            return this.currentSelection.getNumAddresses() > 1L;
        }
        return false;
    }

    @Override
    protected void selectionChanged(ProgramSelection selection) {
        if (!this.displayComponent.isVisible()) {
            return;
        }
        if (selection != null) {
            if (this.containsMultipleSelection()) {
                this.disassembleLocation(this.currentLocation);
            } else if (selection.isEmpty()) {
                this.disassembleLocation(this.currentLocation);
            }
        } else if (this.currentLocation != null) {
            this.disassembleLocation(this.currentLocation);
        }
    }

    private PseudoDisassembler getPseudoDisassembler() {
        if (this.pseudoDisassembler == null) {
            this.pseudoDisassembler = new PseudoDisassembler(this.currentProgram);
        }
        return this.pseudoDisassembler;
    }

    private DisassembledAddressInfo[] getAddressInformation(Address address) {
        ArrayList<DisassembledAddressInfo> infoList = new ArrayList<DisassembledAddressInfo>();
        if (address != null) {
            try {
                DisassembledAddressInfo addressInfo = new DisassembledAddressInfo(address);
                for (int i = 0; i < 5 && address != null && addressInfo.isValidAddress(); ++i) {
                    infoList.add(addressInfo);
                    address = address.addNoWrap((long)addressInfo.getCodeUnitLength());
                    if (address == null) continue;
                    addressInfo = new DisassembledAddressInfo(address);
                }
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return infoList.toArray(new DisassembledAddressInfo[infoList.size()]);
    }

    private void disassembleLocation(ProgramLocation newLocation) {
        if (newLocation != null) {
            this.lastUpdatedLocation = newLocation;
            DisassembledAddressInfo[] addressInfos = this.getAddressInformation(newLocation.getAddress());
            this.displayComponent.setContents(addressInfos);
        }
    }

    private class DisassembledViewComponentProvider
    extends ComponentProviderAdapter {
        private static final String TOOLTIP_TEXT_PREPEND = "<html>Currently selected<br> Code Browser program location<br>address: ";
        private JComponent component;
        private JList<DisassembledAddressInfo> contentList;
        private BrowserCodeUnitFormat addressPreviewFormat;
        private OptionsChangeListener optionsChangeListener;
        private HelpLocation pluginHelpLocation;
        private ChangeListener addressFormatChangeListener;

        private DisassembledViewComponentProvider() {
            super(DisassembledViewPlugin.this.getTool(), "Virtual Disassembler - Current Instruction", DisassembledViewPlugin.this.getName());
            this.optionsChangeListener = new DisassembledViewOptionsListener();
            this.pluginHelpLocation = new HelpLocation(DisassembledViewPlugin.this.getName(), DisassembledViewPlugin.this.getName());
            this.addressFormatChangeListener = e -> this.contentList.repaint();
            this.setTitle("Disassembled View");
            this.setHelpLocation(this.pluginHelpLocation);
            this.setDefaultWindowPosition(WindowPosition.BOTTOM);
            this.contentList = new JList();
            JScrollPane scrollPane = new JScrollPane(this.contentList);
            this.component = scrollPane;
            this.contentList.setSelectionMode(0);
            this.initializeDisplay();
            this.contentList.setCellRenderer((ListCellRenderer<DisassembledAddressInfo>)new GListCellRenderer<DisassembledAddressInfo>(){

                protected String getItemText(DisassembledAddressInfo value) {
                    return value.getAddressPreview(DisassembledViewComponentProvider.this.addressPreviewFormat);
                }

                public Component getListCellRendererComponent(JList<? extends DisassembledAddressInfo> list, DisassembledAddressInfo value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
                    this.setFont(Gui.getFont((String)"font.listing.base"));
                    this.setToolTipText(DisassembledViewComponentProvider.TOOLTIP_TEXT_PREPEND + HTMLUtilities.escapeHTML((String)DisassembledViewPlugin.this.currentLocation.getAddress().toString()));
                    if (index == 0) {
                        Color foreground = ADDRESS_COLOR;
                        Object background = GhidraOptions.DEFAULT_SELECTION_COLOR;
                        if (isSelected) {
                            foreground = Gui.brighter((Color)foreground);
                            background = Gui.darker((Color)background);
                        }
                        this.setForeground(foreground);
                        this.setBackground((Color)background);
                    }
                    return this;
                }
            });
        }

        private void initializeDisplay() {
            ToolOptions opt = this.tool.getOptions("Listing Fields");
            opt.addOptionsChangeListener(this.optionsChangeListener);
            this.addressPreviewFormat = new BrowserCodeUnitFormat((ServiceProvider)this.tool);
            this.addressPreviewFormat.addChangeListener(this.addressFormatChangeListener);
            opt = this.tool.getOptions("Listing Display");
            opt.addOptionsChangeListener(this.optionsChangeListener);
            this.contentList.setForeground(ADDRESS_COLOR);
            this.contentList.setBackground((Color)ListingColors.BACKGROUND);
            Gui.registerFont(this.contentList, (String)"font.listing.base");
        }

        void dispose() {
            ToolOptions opt = this.tool.getOptions("Listing Fields");
            opt.removeOptionsChangeListener(this.optionsChangeListener);
            opt = this.tool.getOptions("Listing Display");
            opt.removeOptionsChangeListener(this.optionsChangeListener);
        }

        void setContents(DisassembledAddressInfo[] addressInfos) {
            this.contentList.setListData((DisassembledAddressInfo[])addressInfos);
        }

        void clearContents() {
            this.contentList.setListData((DisassembledAddressInfo[])new DisassembledAddressInfo[0]);
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void closeComponent() {
            super.closeComponent();
            this.clearContents();
        }

        public void componentHidden() {
            this.clearContents();
        }

        public void componentShown() {
            DisassembledViewPlugin.this.disassembleLocation(DisassembledViewPlugin.this.currentLocation);
        }

        private class DisassembledViewOptionsListener
        implements OptionsChangeListener {
            private DisassembledViewOptionsListener() {
            }

            public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
                DisassembledViewComponentProvider.this.contentList.repaint();
            }
        }
    }

    private class DisassembledAddressInfo {
        private Address wrappedAddress;
        private CodeUnit addressCodeUnit;

        private DisassembledAddressInfo(Address address) {
            if (address == null) {
                Msg.showError((Object)this, (Component)DisassembledViewPlugin.this.displayComponent.getComponent(), (String)"Disassembled View Plugin Exception", null, (Throwable)new NullPointerException("Cannot construct a DisassembledAddressInfo with a null address."));
            }
            this.wrappedAddress = address;
            this.addressCodeUnit = this.getCodeUnitForAddress(address);
        }

        private Address getAddress() {
            return this.wrappedAddress;
        }

        public boolean isValidAddress() {
            return this.addressCodeUnit != null;
        }

        public int getCodeUnitLength() {
            if (this.isValidAddress()) {
                return this.addressCodeUnit.getLength();
            }
            return -1;
        }

        private CodeUnit getCodeUnitForAddress(Address address) {
            CodeUnit virtualCodeUnit;
            Listing listing;
            CodeUnit codeUnit = null;
            if (DisassembledViewPlugin.this.currentProgram != null && DisassembledViewPlugin.this.currentLocation != null && (codeUnit = (listing = DisassembledViewPlugin.this.currentProgram.getListing()).getCodeUnitAt(address)) instanceof Data && !((Data)codeUnit).isDefined() && (virtualCodeUnit = this.virtuallyDisassembleAddress(address)) != null) {
                codeUnit = virtualCodeUnit;
            }
            return codeUnit;
        }

        private CodeUnit virtuallyDisassembleAddress(Address address) {
            PseudoInstruction codeUnit = null;
            if (address != null) {
                PseudoDisassembler disassembler = DisassembledViewPlugin.this.getPseudoDisassembler();
                try {
                    codeUnit = disassembler.disassemble(address);
                }
                catch (UsrException usrException) {
                    // empty catch block
                }
            }
            return codeUnit;
        }

        public String getAddressPreview(CodeUnitFormat format) {
            return this.getAddress().toString() + " " + format.getRepresentationString(this.addressCodeUnit);
        }
    }
}

