/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import ghidra.app.cmd.function.RemoveFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagProvider;
import ghidra.app.plugin.core.function.tags.TagListPanel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import java.util.Set;

public class TargetTagsPanel
extends TagListPanel {
    public TargetTagsPanel(FunctionTagProvider provider, PluginTool tool, String title) {
        super(provider, tool, title);
        this.table.setDisabled(false);
    }

    @Override
    public void refresh(Function newFunction) {
        this.model.clear();
        this.function = newFunction;
        if (this.function == null) {
            this.setTitle("No Function Selected");
        } else {
            this.setTitle(this.function.getName() + " (" + this.function.getEntryPoint().toString() + ")");
        }
        this.table.setFunction(this.function);
        this.model.reload();
    }

    @Override
    protected Set<FunctionTag> backgroundLoadTags() {
        return this.getAssignedTags(this.function);
    }

    public void removeSelectedTags() {
        Set<FunctionTag> selectedTags = this.getSelectedTags();
        for (FunctionTag tag : selectedTags) {
            RemoveFunctionTagCmd cmd = new RemoveFunctionTagCmd(tag.getName(), this.function.getEntryPoint());
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }
}

